/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.copying;

import com.oracle.svm.enterprise.core.copying.o;
import java.util.Arrays;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GetObjectAddressNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueNodeInterface;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.memory.AbstractMemoryCheckpoint;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public final class RawMemCopyCallNode
extends AbstractMemoryCheckpoint
implements MemoryAccess,
SingleMemoryKill,
Canonicalizable,
Lowerable {
    public static final NodeClass<RawMemCopyCallNode> TYPE = NodeClass.create(RawMemCopyCallNode.class);
    @Node.Input
    protected ValueNode fS;
    @Node.Input
    protected ValueNode fT;
    @Node.Input
    protected ValueNode fU;
    @Node.Input
    protected ValueNode fV;
    @Node.Input
    protected ValueNode fW;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill fX;
    private final o fY;
    private final LocationIdentity fZ;
    private final LocationIdentity ga;
    private boolean cz;
    private final boolean gb;

    public RawMemCopyCallNode(o o2, ValueNode valueNode, ValueNode valueNode2, ValueNode valueNode3, ValueNode valueNode4, ValueNode valueNode5, LocationIdentity locationIdentity, LocationIdentity locationIdentity2, boolean bl2, boolean bl3) {
        super(TYPE, StampFactory.forVoid());
        this.fS = valueNode;
        this.fT = valueNode2;
        this.fU = valueNode3;
        this.fV = valueNode4;
        this.fW = valueNode5;
        this.fZ = locationIdentity;
        this.ga = locationIdentity2;
        this.cz = bl2;
        this.fY = o2;
        this.gb = bl3;
    }

    public ValueNode be() {
        return this.fS;
    }

    public ValueNode bf() {
        return this.fT;
    }

    public ValueNode bg() {
        return this.fU;
    }

    public ValueNode bh() {
        return this.fV;
    }

    public ValueNode bi() {
        return this.fW;
    }

    public boolean bj() {
        return this.cz;
    }

    public boolean bk() {
        return this.gb;
    }

    public MemoryKill getLastLocationAccess() {
        return this.fX;
    }

    public void setLastLocationAccess(MemoryKill memoryKill) {
        this.updateUsagesInterface((ValueNodeInterface)this.fX, (ValueNodeInterface)memoryKill);
        this.fX = memoryKill;
    }

    public LocationIdentity getLocationIdentity() {
        return this.fZ;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return this.ga;
    }

    public boolean hasSideEffect() {
        return !this.ga.isInit();
    }

    public Node canonical(CanonicalizerTool canonicalizerTool) {
        if (this.bi().isConstant() && this.bi().asConstant().isDefaultForKind()) {
            if (this.fX != null) {
                this.replaceAtUsages((Node)this.fX.asNode(), InputType.Memory);
            }
            return null;
        }
        return this;
    }

    public void lower(LoweringTool loweringTool) {
        if (this.graph().getGuardsStage().areFrameStatesAtDeopts()) {
            ForeignCallNode foreignCallNode;
            Object[] objectArray;
            StructuredGraph structuredGraph = this.graph();
            if (this.bk()) {
                objectArray = this.fY.b(this.bj(), this.getKilledLocationIdentity());
                assert (objectArray != null) : "no descriptor for rawmemcopy, disjoint " + this.bj() + ", object";
                foreignCallNode = (ForeignCallNode)structuredGraph.add((Node)new ForeignCallNode((ForeignCallDescriptor)objectArray, new ValueNode[]{this.be(), this.bf(), this.bg(), this.bh(), this.bi()}));
            } else {
                objectArray = this.fY.a(this.bj(), this.getKilledLocationIdentity());
                assert (objectArray != null) : "no descriptor for rawmemcopy, disjoint " + this.bj() + ", primitive";
                ValueNode valueNode = this.a(this.be(), this.bf());
                ValueNode valueNode2 = this.a(this.bg(), this.bh());
                foreignCallNode = (ForeignCallNode)structuredGraph.add((Node)new ForeignCallNode((ForeignCallDescriptor)objectArray, new ValueNode[]{valueNode, valueNode2, this.bi()}));
            }
            objectArray = foreignCallNode.getKilledLocationIdentities();
            assert (objectArray.length == 1 && objectArray[0].equals(this.getKilledLocationIdentity())) : String.format("%s: should kill %s, unexpected kills: %s", foreignCallNode, this.getKilledLocationIdentity(), Arrays.toString(objectArray));
            structuredGraph.replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)foreignCallNode);
        }
    }

    private ValueNode a(ValueNode valueNode, ValueNode valueNode2) {
        FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)this.graph().add((Node)new GetObjectAddressNode(valueNode));
        this.graph().addBeforeFixed((FixedNode)this, fixedWithNextNode);
        return (ValueNode)this.graph().unique((Node)new OffsetAddressNode((ValueNode)fixedWithNextNode, valueNode2));
    }
}

