/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.match.processor;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import jdk.graal.compiler.processor.AbstractProcessor;

@SupportedAnnotationTypes(value={"jdk.graal.compiler.core.match.MatchRule", "jdk.graal.compiler.core.match.MatchRules", "jdk.graal.compiler.core.match.MatchableNode", "jdk.graal.compiler.core.match.MatchableNodes"})
public class MatchProcessor
extends AbstractProcessor {
    private static final String VALUE_NODE_CLASS_NAME = "jdk.graal.compiler.nodes.ValueNode";
    private static final String COMPLEX_MATCH_RESULT_CLASS_NAME = "jdk.graal.compiler.core.match.ComplexMatchResult";
    private static final String MATCHABLE_NODES_CLASS_NAME = "jdk.graal.compiler.core.match.MatchableNodes";
    private static final String MATCHABLE_NODE_CLASS_NAME = "jdk.graal.compiler.core.match.MatchableNode";
    private static final String MATCH_RULE_CLASS_NAME = "jdk.graal.compiler.core.match.MatchRule";
    private static final String MATCH_RULES_CLASS_NAME = "jdk.graal.compiler.core.match.MatchRules";
    private final Set<Element> processedMatchRules = new HashSet<Element>();
    private final Set<Element> processedMatchableNodes = new HashSet<Element>();
    private static final Pattern tokenizer = Pattern.compile("\\s*([()=]|[A-Za-z][A-Za-z0-9]*)\\s*");
    private static final boolean DEBUG = false;
    private PrintWriter log;
    Map<String, TypeDescriptor> knownTypes = new HashMap<String, TypeDescriptor>();
    private TypeDescriptor valueType;
    private Element currentElement;
    private RoundEnvironment currentRound;

    private PrintWriter getLog() {
        if (this.log == null) {
            if (this.processingEnv.getClass().getName().contains(".javac.")) {
                this.log = new PrintWriter(System.err);
            } else {
                try {
                    FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", this.getClass().getSimpleName() + "log", new Element[0]);
                    this.log = new PrintWriter(new FileWriter(file.toUri().getPath(), true));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.log;
    }

    private void logMessage(String format, Object ... args) {
    }

    private void logException(Throwable t) {
    }

    private void reportExceptionThrow(Element element, Throwable t) {
        if (element != null) {
            this.logMessage("throw for %s:\n", element);
        }
        this.logException(t);
        this.printError(element, "Exception throw during processing: %s %s", t, Arrays.toString(Arrays.copyOf(t.getStackTrace(), 4)));
    }

    private void declareType(TypeMirror mirror, String shortName, String nodeClass, String nodePackage, List<String> inputs, boolean commutative, boolean shareable, boolean consumable, boolean ignoresSideEffects, Element element) {
        TypeDescriptor descriptor = new TypeDescriptor(mirror, shortName, nodeClass, nodePackage, inputs, commutative, shareable, consumable, ignoresSideEffects);
        descriptor.originatingElements.add(element);
        this.knownTypes.put(shortName, descriptor);
    }

    private String findPackage(Element type) {
        PackageElement p = this.processingEnv.getElementUtils().getPackageOf(type);
        if (p != null) {
            return p.getQualifiedName().toString();
        }
        throw new InternalError("Can't find package for " + String.valueOf(type));
    }

    private String fullClassName(Element element) {
        String pkg = this.findPackage(element);
        return ((TypeElement)element).getQualifiedName().toString().substring(pkg.length() + 1);
    }

    /*
     * WARNING - void declaration
     */
    private void createFiles(MatchRuleDescriptor info) {
        String pkg = ((PackageElement)info.topDeclaringType.getEnclosingElement()).getQualifiedName().toString();
        Name topDeclaringClass = info.topDeclaringType.getSimpleName();
        String matchStatementClassName = String.valueOf(topDeclaringClass) + "_MatchStatementSet";
        Element[] originatingElements = info.originatingElements.toArray(new Element[info.originatingElements.size()]);
        Types typeUtils = this.typeUtils();
        Filer filer = this.processingEnv.getFiler();
        try (PrintWriter out = MatchProcessor.createSourceFile(pkg, matchStatementClassName, filer, originatingElements);){
            void var11_24;
            out.println("// CheckStyle: stop header check");
            out.println("// CheckStyle: stop line length check");
            out.println("// GENERATED CONTENT - DO NOT EDIT");
            out.println("// Source: " + String.valueOf(topDeclaringClass) + ".java");
            out.println("package " + pkg + ";");
            out.println("");
            out.println("import java.util.*;");
            out.println("import jdk.graal.compiler.core.match.*;");
            out.println("import jdk.graal.compiler.core.gen.NodeMatchRules;");
            out.println("import jdk.graal.compiler.graph.Position;");
            for (String string : info.requiredPackages) {
                if (string.equals(pkg)) continue;
                out.println("import " + string + ".*;");
            }
            out.println("");
            out.println("public class " + matchStatementClassName + " implements MatchStatementSet {");
            out.println();
            for (MethodInvokerItem methodInvokerItem : info.invokers.values()) {
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder types = new StringBuilder();
                int count = methodInvokerItem.fields.size();
                int index = 0;
                for (VariableElement variableElement : methodInvokerItem.fields) {
                    stringBuilder.append('\"');
                    stringBuilder.append(variableElement.getSimpleName());
                    stringBuilder.append('\"');
                    types.append(String.format("(%s) args[%s]", this.fullClassName(typeUtils.asElement(variableElement.asType())), index++));
                    if (count-- <= 1) continue;
                    stringBuilder.append(", ");
                    types.append(", ");
                }
                out.printf("    private static final String[] %s = new String[] {%s};\n", methodInvokerItem.argumentsListName(), stringBuilder);
                out.printf("    private static final class %s implements MatchGenerator {\n", methodInvokerItem.wrapperClass());
                out.printf("        static final MatchGenerator instance = new %s();\n", methodInvokerItem.wrapperClass());
                out.printf("        @Override\n", new Object[0]);
                out.printf("        public ComplexMatchResult match(NodeMatchRules nodeMatchRules, Object...args) {\n", new Object[0]);
                out.printf("            return ((%s) nodeMatchRules).%s(%s);\n", methodInvokerItem.nodeLIRBuilderClass, methodInvokerItem.methodName, types);
                out.printf("        }\n", new Object[0]);
                out.printf("        @Override\n", new Object[0]);
                out.printf("        public String getName() {\n", new Object[0]);
                out.printf("             return \"%s\";\n", methodInvokerItem.methodName);
                out.printf("        }\n", new Object[0]);
                out.printf("    }\n", new Object[0]);
                out.println();
            }
            String desc = "MatchStatement";
            out.println("    @Override");
            out.println("    public Class<? extends NodeMatchRules> forClass() {");
            out.println("        return " + String.valueOf(topDeclaringClass) + ".class;");
            out.println("    }");
            out.println();
            out.println("    @Override");
            out.println("    public List<" + desc + "> statements() {");
            out.println("        // Checkstyle: stop ");
            for (String string : info.positionDeclarations) {
                out.println("        " + string);
            }
            out.println();
            out.println("        List<" + desc + "> statements = Collections.unmodifiableList(Arrays.asList(");
            boolean bl = false;
            for (MatchRuleItem matchRule : info.matchRules) {
                void var10_16;
                String comma = var10_16 == info.matchRules.size() - 1 ? "" : ",";
                out.printf("            %s%s\n", matchRule.ruleBuilder(), comma);
                ++var10_16;
            }
            out.println("        ));");
            out.println("        // Checkstyle: resume");
            out.println("        return statements;");
            out.println("    }");
            out.println();
            out.println("    @Override");
            out.println("    public String getArchitecture() {");
            String string = topDeclaringClass.toString().replace("NodeMatchRules", "");
            if (!string.equals("AMD64")) {
                String string2 = string.toLowerCase();
            }
            out.println("        return \"" + (String)var11_24 + "\";");
            out.println("    }");
            out.println("}");
        }
        this.createProviderFile(pkg + "." + matchStatementClassName, "jdk.graal.compiler.core.match.MatchStatementSet", originatingElements);
    }

    private static TypeElement topDeclaringType(Element element) {
        Element enclosing = element.getEnclosingElement();
        if (enclosing == null || enclosing.getKind() == ElementKind.PACKAGE) {
            return (TypeElement)element;
        }
        return MatchProcessor.topDeclaringType(enclosing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        this.logMessage("Starting round %s\n", roundEnv);
        TypeElement matchRulesTypeElement = this.getTypeElement(MATCH_RULES_CLASS_NAME);
        TypeElement matchRuleTypeElement = this.getTypeElement(MATCH_RULE_CLASS_NAME);
        TypeMirror matchRulesTypeMirror = matchRulesTypeElement.asType();
        TypeMirror matchRuleTypeMirror = matchRuleTypeElement.asType();
        TypeElement matchableNodeTypeElement = this.getTypeElement(MATCHABLE_NODE_CLASS_NAME);
        TypeElement matchableNodesTypeElement = this.getTypeElement(MATCHABLE_NODES_CLASS_NAME);
        this.currentRound = roundEnv;
        try {
            List<AnnotationMirror> matchRuleAnnotations;
            Element element;
            Element element2;
            Iterator<? extends Element> iterator = roundEnv.getElementsAnnotatedWith(matchableNodeTypeElement).iterator();
            while (iterator.hasNext()) {
                this.currentElement = element2 = iterator.next();
                this.logMessage("%s\n", element2);
                this.processMatchableNodes(element2);
            }
            iterator = roundEnv.getElementsAnnotatedWith(matchableNodesTypeElement).iterator();
            while (iterator.hasNext()) {
                this.currentElement = element2 = iterator.next();
                this.logMessage("%s\n", element2);
                this.processMatchableNodes(element2);
            }
            TypeMirror valueTypeMirror = this.getTypeElement(VALUE_NODE_CLASS_NAME).asType();
            this.valueType = new TypeDescriptor(valueTypeMirror, "Value", "ValueNode", "jdk.graal.compiler.nodes", Collections.emptyList(), false, false, false, false);
            HashMap<TypeElement, MatchRuleDescriptor> map = new HashMap<TypeElement, MatchRuleDescriptor>();
            Iterator<Element> iterator2 = roundEnv.getElementsAnnotatedWith(matchRuleTypeElement).iterator();
            while (iterator2.hasNext()) {
                this.currentElement = element = iterator2.next();
                AnnotationMirror matchRule = this.getAnnotation(element, matchRuleTypeMirror);
                matchRuleAnnotations = Collections.singletonList(matchRule);
                this.processMatchRules(map, element, matchRuleAnnotations);
            }
            iterator2 = roundEnv.getElementsAnnotatedWith(matchRulesTypeElement).iterator();
            while (iterator2.hasNext()) {
                this.currentElement = element = iterator2.next();
                AnnotationMirror matchRules = this.getAnnotation(element, matchRulesTypeMirror);
                matchRuleAnnotations = MatchProcessor.getAnnotationValueList(matchRules, "value", AnnotationMirror.class);
                this.processMatchRules(map, element, matchRuleAnnotations);
            }
            this.currentElement = null;
            for (MatchRuleDescriptor info : map.values()) {
                this.createFiles(info);
            }
        }
        catch (Throwable t) {
            this.reportExceptionThrow(this.currentElement, t);
        }
        finally {
            this.currentElement = null;
            this.currentRound = null;
        }
        return true;
    }

    private void processMatchableNodes(Element element) {
        if (!this.processedMatchableNodes.contains(element)) {
            try {
                List<AnnotationMirror> matchableNodeAnnotations;
                this.processedMatchableNodes.add(element);
                AnnotationMirror mirror = this.getAnnotation(element, this.getType(MATCHABLE_NODES_CLASS_NAME));
                if (mirror != null) {
                    matchableNodeAnnotations = MatchProcessor.getAnnotationValueList(mirror, "value", AnnotationMirror.class);
                } else {
                    mirror = this.getAnnotation(element, this.getType(MATCHABLE_NODE_CLASS_NAME));
                    if (mirror != null) {
                        matchableNodeAnnotations = Collections.singletonList(mirror);
                    } else {
                        return;
                    }
                }
                TypeElement topDeclaringType = MatchProcessor.topDeclaringType(element);
                for (AnnotationMirror matchableNode : matchableNodeAnnotations) {
                    this.processMatchableNode(element, topDeclaringType, matchableNode);
                }
            }
            catch (Throwable t) {
                this.reportExceptionThrow(element, t);
            }
        }
    }

    private void processMatchableNode(Element element, TypeElement topDeclaringType, AnnotationMirror matchable) {
        this.logMessage("processMatchableNode %s %s %s\n", topDeclaringType, element, matchable);
        TypeMirror nodeClassMirror = MatchProcessor.getAnnotationValue(matchable, "nodeClass", TypeMirror.class);
        if (nodeClassMirror == null) {
            throw new InternalError("Can't get mirror for node class " + String.valueOf(element));
        }
        String nodeClass = nodeClassMirror.toString().equals(MATCHABLE_NODE_CLASS_NAME) ? topDeclaringType.getQualifiedName().toString() : nodeClassMirror.toString();
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(nodeClass);
        if (typeElement == null) {
            this.printError(element, matchable, "Class \"%s\" cannot be resolved to a type", nodeClass);
            return;
        }
        String nodePackage = this.findPackage(typeElement);
        assert (nodeClass.startsWith(nodePackage));
        nodeClass = nodeClass.substring(nodePackage.length() + 1);
        assert (nodeClass.endsWith("Node"));
        String shortName = nodeClass.substring(0, nodeClass.length() - 4);
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement nodeClassElement = (TypeElement)typeUtils.asElement(nodeClassMirror);
        List<String> inputs = MatchProcessor.getAnnotationValueList(matchable, "inputs", String.class);
        for (String input : inputs) {
            boolean ok = false;
            TypeElement current = nodeClassElement;
            while (!ok && current != null) {
                for (Element element2 : ElementFilter.fieldsIn(current.getEnclosedElements())) {
                    if (!element2.getSimpleName().toString().equals(input)) continue;
                    ok = true;
                    break;
                }
                TypeMirror theSuper = current.getSuperclass();
                current = (TypeElement)typeUtils.asElement(theSuper);
            }
            if (ok) continue;
            this.printError(element, matchable, "Input named \"%s\" doesn't exist in %s", input, nodeClassElement.getSimpleName());
        }
        boolean commutative = MatchProcessor.getAnnotationValue(matchable, "commutative", Boolean.class);
        boolean shareable = MatchProcessor.getAnnotationValue(matchable, "shareable", Boolean.class);
        boolean consumable = MatchProcessor.getAnnotationValue(matchable, "consumable", Boolean.class);
        boolean ignoresSideEffects = MatchProcessor.getAnnotationValue(matchable, "ignoresSideEffects", Boolean.class);
        this.declareType(nodeClassMirror, shortName, nodeClass, nodePackage, inputs, commutative, shareable, consumable, ignoresSideEffects, element);
    }

    private void processMatchRules(Map<TypeElement, MatchRuleDescriptor> map, Element element, List<AnnotationMirror> matchRules) {
        if (!this.processedMatchRules.contains(element)) {
            try {
                this.processedMatchRules.add(element);
                assert (element instanceof ExecutableElement);
                this.findMatchableNodes(element);
                TypeElement topDeclaringType = MatchProcessor.topDeclaringType(element);
                MatchRuleDescriptor info = map.get(topDeclaringType);
                if (info == null) {
                    info = new MatchRuleDescriptor(topDeclaringType);
                    map.put(topDeclaringType, info);
                }
                for (AnnotationMirror matchRule : matchRules) {
                    this.processMatchRule((ExecutableElement)element, info, matchRule);
                }
            }
            catch (Throwable t) {
                this.reportExceptionThrow(element, t);
            }
        }
    }

    private void findMatchableNodes(Element element) {
        this.processMatchableNodes(element);
        for (Element enclosing = element.getEnclosingElement(); enclosing != null; enclosing = enclosing.getEnclosingElement()) {
            if (enclosing.getKind() != ElementKind.CLASS && enclosing.getKind() != ElementKind.INTERFACE) continue;
            TypeElement current = (TypeElement)enclosing;
            while (current != null) {
                this.processMatchableNodes(current);
                for (TypeMirror typeMirror : current.getInterfaces()) {
                    Element interfaceElement = this.typeUtils().asElement(typeMirror);
                    this.processMatchableNodes(interfaceElement);
                    this.findMatchableNodes(interfaceElement);
                }
                TypeMirror theSuper = current.getSuperclass();
                current = (TypeElement)this.typeUtils().asElement(theSuper);
            }
        }
    }

    private Types typeUtils() {
        return this.processingEnv.getTypeUtils();
    }

    /*
     * WARNING - void declaration
     */
    private void processMatchRule(ExecutableElement method, MatchRuleDescriptor info, AnnotationMirror matchRule) {
        this.logMessage("processMatchRule %s\n", method);
        Types typeUtils = this.typeUtils();
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.printError((Element)method, "MatchRule method %s must be public", method.getSimpleName());
            return;
        }
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            this.printError((Element)method, "MatchRule method %s must be non-static", method.getSimpleName());
            return;
        }
        try {
            TypeMirror returnType = method.getReturnType();
            if (!typeUtils.isSameType(returnType, this.processingEnv.getElementUtils().getTypeElement(COMPLEX_MATCH_RESULT_CLASS_NAME).asType())) {
                this.printError((Element)method, "MatchRule method return type must be %s", COMPLEX_MATCH_RESULT_CLASS_NAME);
                return;
            }
            String rule = MatchProcessor.getAnnotationValue(matchRule, "value", String.class);
            RuleParser parser = new RuleParser(rule);
            ArrayList<TypeDescriptor> expectedTypes = parser.capturedTypes();
            ArrayList<String> expectedNames = parser.capturedNames();
            List<? extends VariableElement> actualParameters = method.getParameters();
            if (expectedTypes.size() + 1 < actualParameters.size()) {
                this.printError((Element)method, "Too many arguments for match method %s != %s", expectedTypes.size() + 1, actualParameters.size());
                return;
            }
            for (VariableElement variableElement : actualParameters) {
                String name = variableElement.getSimpleName().toString();
                int nameIndex = expectedNames.indexOf(name);
                if (nameIndex == -1) {
                    this.printError((Element)method, "Argument \"%s\" isn't captured in the match rule", name);
                    return;
                }
                TypeMirror type = variableElement.asType();
                if (typeUtils.isAssignable(expectedTypes.get((int)nameIndex).mirror, type)) continue;
                this.printError((Element)method, "Captured value \"%s\" of type %s is not assignable to argument of type %s", name, expectedTypes.get((int)nameIndex).mirror, type);
                return;
            }
            String methodName = method.getSimpleName().toString();
            MethodInvokerItem methodInvokerItem = info.invokers.get(methodName);
            if (methodInvokerItem == null) {
                MethodInvokerItem methodInvokerItem2 = new MethodInvokerItem(methodName, MatchProcessor.topDeclaringType(method).getSimpleName().toString(), method, actualParameters);
                info.invokers.put(methodName, methodInvokerItem2);
            } else if (methodInvokerItem.method != method) {
                this.printError((Element)method, "Use unique method names for match methods: %s.%s != %s.%s", method.getReceiverType(), method.getSimpleName(), methodInvokerItem.method.getReceiverType(), methodInvokerItem.method.getSimpleName());
                return;
            }
            Object declaringClass = "";
            String separator = "";
            Set<Element> originatingElementsList = info.originatingElements;
            originatingElementsList.add(method);
            for (Element enclosing = method.getEnclosingElement(); enclosing != null; enclosing = enclosing.getEnclosingElement()) {
                if (enclosing.getKind() == ElementKind.CLASS || enclosing.getKind() == ElementKind.INTERFACE || enclosing.getKind() == ElementKind.ENUM) {
                    if (enclosing.getModifiers().contains((Object)Modifier.PRIVATE)) {
                        this.printError((Element)method, "MatchRule cannot be declared in a private %s %s", enclosing.getKind().name().toLowerCase(), enclosing);
                        return;
                    }
                } else {
                    if (enclosing.getKind() == ElementKind.PACKAGE) break;
                    this.printError((Element)method, "MatchRule cannot be declared in a %s", enclosing.getKind().name().toLowerCase());
                    return;
                }
                originatingElementsList.add(enclosing);
                declaringClass = String.valueOf(enclosing.getSimpleName()) + separator + (String)declaringClass;
                separator = ".";
            }
            originatingElementsList.addAll(parser.originatingElements);
            info.requiredPackages.addAll(parser.requiredPackages);
            parser.generatePositionDeclarations(info.positionDeclarations);
            List<String> matches = parser.generateVariants();
            for (String match : matches) {
                void var12_16;
                info.matchRules.add(new MatchRuleItem(match, (MethodInvokerItem)var12_16));
            }
        }
        catch (RuleParseError e) {
            this.printError((Element)method, matchRule, e.getMessage(), new Object[0]);
        }
    }

    private Element elementForMessage(Element e) {
        if (this.currentRound != null && !this.currentRound.getRootElements().contains(e) && this.currentElement != null) {
            return this.currentElement;
        }
        return e;
    }

    private void printError(Element annotatedElement, String format, Object ... args) {
        Element e = this.elementForMessage(annotatedElement);
        String prefix = e == annotatedElement ? "" : String.valueOf(annotatedElement) + ": ";
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, prefix + String.format(format, args), e);
    }

    private void printError(Element annotatedElement, AnnotationMirror annotation, String format, Object ... args) {
        Element e = this.elementForMessage(annotatedElement);
        String prefix = e == annotatedElement ? "" : String.valueOf(annotation) + " on " + String.valueOf(annotatedElement) + ": ";
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, prefix + String.format(format, args), e, annotation);
    }

    static class TypeDescriptor {
        final TypeMirror mirror;
        final String shortName;
        final String nodeClass;
        final String nodePackage;
        final List<String> inputs;
        final boolean commutative;
        final boolean shareable;
        final boolean consumable;
        final boolean ignoresSideEffects;
        final Set<Element> originatingElements = new HashSet<Element>();

        TypeDescriptor(TypeMirror mirror, String shortName, String nodeClass, String nodePackage, List<String> inputs, boolean commutative, boolean shareable, boolean consumable, boolean ignoresSideEffects) {
            this.mirror = mirror;
            this.shortName = shortName;
            this.nodeClass = nodeClass;
            this.nodePackage = nodePackage;
            this.inputs = inputs;
            this.commutative = commutative;
            this.shareable = shareable;
            this.consumable = consumable;
            this.ignoresSideEffects = ignoresSideEffects;
            assert (!commutative || inputs.size() == 2);
        }
    }

    static class MatchRuleDescriptor {
        final TypeElement topDeclaringType;
        final List<MatchRuleItem> matchRules = new ArrayList<MatchRuleItem>();
        private final Set<Element> originatingElements = new HashSet<Element>();
        public Set<String> positionDeclarations = new HashSet<String>();
        Map<String, MethodInvokerItem> invokers = new HashMap<String, MethodInvokerItem>();
        Set<String> requiredPackages = new HashSet<String>();

        MatchRuleDescriptor(TypeElement topDeclaringType) {
            this.topDeclaringType = topDeclaringType;
        }
    }

    static class MethodInvokerItem {
        final String methodName;
        final String nodeLIRBuilderClass;
        final ExecutableElement method;
        final List<? extends VariableElement> fields;

        MethodInvokerItem(String methodName, String nodeLIRBuilderClass, ExecutableElement method, List<? extends VariableElement> fields) {
            this.methodName = methodName;
            this.nodeLIRBuilderClass = nodeLIRBuilderClass;
            this.method = method;
            this.fields = fields;
        }

        String wrapperClass() {
            return "MatchGenerator_" + this.methodName;
        }

        String argumentsListName() {
            return this.methodName + "_arguments";
        }
    }

    static class MatchRuleItem {
        private final String matchPattern;
        private final MethodInvokerItem invoker;

        MatchRuleItem(String matchPattern, MethodInvokerItem invoker) {
            this.matchPattern = matchPattern;
            this.invoker = invoker;
        }

        public String ruleBuilder() {
            return String.format("new MatchStatement(\"%s\", %s, %s.instance, %s)", this.invoker.methodName, this.matchPattern, this.invoker.wrapperClass(), this.invoker.argumentsListName());
        }
    }

    private class RuleParser {
        private ArrayList<TypeDescriptor> capturedTypes = new ArrayList();
        private ArrayList<String> capturedNames = new ArrayList();
        private final String[] tokens;
        private int current;
        private MatchDescriptor matchDescriptor;
        private final Set<Element> originatingElements = new HashSet<Element>();
        private Set<String> requiredPackages = new HashSet<String>();

        RuleParser(String rule) {
            Matcher m = tokenizer.matcher(rule);
            ArrayList<String> list = new ArrayList<String>();
            int end = 0;
            while (m.lookingAt()) {
                list.add(m.group(1));
                end = m.end();
                m.region(m.end(), m.regionEnd());
            }
            if (end != m.regionEnd()) {
                throw new RuleParseError("Unexpected tokens :" + rule.substring(m.end(), m.regionEnd()), new Object[0]);
            }
            this.tokens = list.toArray(new String[0]);
            this.matchDescriptor = this.parseExpression();
            if (!this.done()) {
                throw new RuleParseError("didn't consume all tokens", new Object[0]);
            }
            this.capturedNames.add(0, "root");
            this.capturedTypes.add(0, this.matchDescriptor.nodeType);
        }

        String next() {
            return this.tokens[this.current++];
        }

        String peek(String name) {
            if (this.current >= this.tokens.length) {
                if (name == null) {
                    throw new RuleParseError("Out of tokens", new Object[0]);
                }
                throw new RuleParseError("Out of tokens looking for %s", name);
            }
            return this.tokens[this.current];
        }

        boolean done() {
            return this.current == this.tokens.length;
        }

        private MatchDescriptor parseExpression() {
            if (this.peek("(").equals("(")) {
                int n;
                this.next();
                MatchDescriptor descriptor = this.parseType(true);
                for (n = 0; n < descriptor.nodeType.inputs.size(); ++n) {
                    descriptor.inputs[n] = this.peek("(").equals("(") ? this.parseExpression() : this.parseType(false);
                }
                for (n = 0; n < descriptor.nodeType.inputs.size(); ++n) {
                    if (descriptor.inputs[n] != null) continue;
                    throw new RuleParseError("not enough inputs for " + descriptor.name, new Object[0]);
                }
                if (this.peek(")").equals(")")) {
                    this.next();
                    return descriptor;
                }
                throw new RuleParseError("Too many arguments to " + descriptor.nodeType.nodeClass, new Object[0]);
            }
            throw new RuleParseError("Extra tokens following match pattern: " + this.peek(null), new Object[0]);
        }

        private MatchDescriptor parseType(boolean forExpression) {
            TypeDescriptor type = null;
            String name = null;
            if (Character.isUpperCase(this.peek("node type or name").charAt(0))) {
                String token = this.next();
                type = MatchProcessor.this.knownTypes.get(token);
                if (type == null) {
                    throw new RuleParseError("Unknown node type: " + token, new Object[0]);
                }
                if (this.peek("=").equals("=")) {
                    this.next();
                    name = this.next();
                }
                this.originatingElements.addAll(type.originatingElements);
            } else if (Character.isLowerCase(this.peek("name").charAt(0))) {
                name = this.next();
                type = MatchProcessor.this.valueType;
            } else {
                throw new RuleParseError("Unexpected token \"%s\" when looking for name or node type", this.peek(null));
            }
            this.requiredPackages.add(type.nodePackage);
            if (name != null) {
                if (!this.capturedNames.contains(name)) {
                    this.capturedNames.add(name);
                    this.capturedTypes.add(type);
                } else {
                    int index = this.capturedNames.indexOf(name);
                    if (this.capturedTypes.get(index) != type) {
                        throw new RuleParseError("Captured node \"%s\" has differing types", name);
                    }
                }
            }
            return new MatchDescriptor(type, name, forExpression);
        }

        List<String> generateVariants() {
            return this.matchDescriptor.generateVariants();
        }

        void generatePositionDeclarations(Set<String> declarations) {
            this.matchDescriptor.generatePositionDeclarations(declarations);
        }

        public ArrayList<TypeDescriptor> capturedTypes() {
            return this.capturedTypes;
        }

        public ArrayList<String> capturedNames() {
            return this.capturedNames;
        }
    }

    private static class RuleParseError
    extends RuntimeException {
        private static final long serialVersionUID = 6456128283609257490L;

        RuleParseError(String format, Object ... args) {
            super(String.format(format, args));
        }
    }

    class MatchDescriptor {
        TypeDescriptor nodeType;
        String name;
        MatchDescriptor[] inputs;

        MatchDescriptor(TypeDescriptor nodeType, String name, boolean forExpression) {
            this.nodeType = nodeType;
            this.name = name;
            this.inputs = forExpression ? new MatchDescriptor[nodeType.inputs.size()] : new MatchDescriptor[0];
        }

        public void generatePositionDeclarations(Set<String> declarations) {
            if (this.inputs.length == 0) {
                return;
            }
            declarations.add(this.generatePositionDeclaration());
            for (MatchDescriptor desc : this.inputs) {
                desc.generatePositionDeclarations(declarations);
            }
        }

        List<String> recurseVariants(int index) {
            if (this.inputs.length == 0) {
                return new ArrayList<String>();
            }
            List<String> currentVariants = this.inputs[index].generateVariants();
            if (index == this.inputs.length - 1) {
                return currentVariants;
            }
            List<String> subVariants = this.recurseVariants(index + 1);
            ArrayList<String> result = new ArrayList<String>();
            for (String current : currentVariants) {
                for (String sub : subVariants) {
                    result.add(current + ", " + sub);
                    if (!this.nodeType.commutative) continue;
                    result.add(sub + ", " + current);
                }
            }
            return result;
        }

        List<String> generateVariants() {
            String prefix = this.formatPrefix();
            String suffix = this.formatSuffix();
            ArrayList<String> variants = new ArrayList<String>();
            if (this.inputs.length > 0) {
                for (String var : this.recurseVariants(0)) {
                    variants.add(prefix + ", " + var + suffix);
                }
            } else {
                assert (this.inputs.length == 0);
                variants.add(prefix + suffix);
            }
            return variants;
        }

        private String formatPrefix() {
            if (this.nodeType == MatchProcessor.this.valueType) {
                return String.format("new MatchPattern(%s, false, false, false", this.name != null ? "\"" + this.name + "\"" : "null");
            }
            return String.format("new MatchPattern(%s.class, %s", this.nodeType.nodeClass, this.name != null ? "\"" + this.name + "\"" : "null");
        }

        private String formatSuffix() {
            if (this.nodeType != null) {
                if (this.inputs.length != this.nodeType.inputs.size()) {
                    return ", true, " + this.nodeType.consumable + ", " + this.nodeType.ignoresSideEffects + ")";
                }
                if (this.nodeType.inputs.size() > 0) {
                    return ", " + this.nodeType.nodeClass + "_positions, " + !this.nodeType.shareable + ", " + this.nodeType.consumable + ", " + this.nodeType.ignoresSideEffects + ")";
                }
                if (this.nodeType.shareable) {
                    return ", false, " + this.nodeType.consumable + ", " + this.nodeType.ignoresSideEffects + ")";
                }
            }
            return ")";
        }

        String generatePositionDeclaration() {
            return String.format("Position[] %s_positions = MatchRuleRegistry.findPositions(%s.TYPE, new String[]{\"%s\"});", this.nodeType.nodeClass, this.nodeType.nodeClass, String.join((CharSequence)"\", \"", this.nodeType.inputs));
        }
    }
}

