/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;

final class ArrayBasedShapeGeneratorOffsetTransformer
implements FieldValueTransformerWithAvailability {
    static final Class<?> SHAPE_GENERATOR = TruffleBaseFeature.lookupClass("com.oracle.truffle.api.staticobject.ArrayBasedShapeGenerator");
    private final String storageClassFieldName;

    ArrayBasedShapeGeneratorOffsetTransformer(String storageClassFieldName) {
        this.storageClassFieldName = storageClassFieldName;
    }

    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    public Object transform(Object receiver, Object originalValue) {
        Class generatedStorageClass = (Class)ReflectionUtil.readField(SHAPE_GENERATOR, (String)"generatedStorageClass", (Object)receiver);
        Field field = ReflectionUtil.lookupField((Class)generatedStorageClass, (String)this.storageClassFieldName);
        int offset = ReflectionSubstitutionSupport.singleton().getFieldOffset(field, false);
        if (offset <= 0) {
            throw VMError.shouldNotReachHere((String)("Field is not marked as accessed: " + String.valueOf(field)));
        }
        return offset;
    }
}

