/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.wasmgc.snippets;

import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public class a
implements Snippets {
    @Snippet(allowMissingProbabilities=true)
    public static Object dynamicNewArraySnippet(Class<?> componentClass, int length) {
        Class clazz = PiNode.piCastNonNullClass(componentClass, (GuardingNode)SnippetAnchorNode.anchor());
        int n2 = PiNode.piCastPositive((int)length, (GuardingNode)SnippetAnchorNode.anchor());
        if (clazz == Integer.TYPE) {
            return new int[length];
        }
        if (clazz == Boolean.TYPE) {
            return new boolean[length];
        }
        if (clazz == Byte.TYPE) {
            return new byte[length];
        }
        if (clazz == Short.TYPE) {
            return new short[length];
        }
        if (clazz == Character.TYPE) {
            return new char[length];
        }
        if (clazz == Long.TYPE) {
            return new long[length];
        }
        if (clazz == Float.TYPE) {
            return new float[length];
        }
        if (clazz == Double.TYPE) {
            return new double[length];
        }
        return DynamicNewArrayNode.newArray((Class)clazz, (int)n2, (JavaKind)JavaKind.Object);
    }

    public static class a
    extends SubstrateTemplates {
        public final SnippetTemplate.SnippetInfo Fn;

        public a(OptionValues optionValues, Providers providers) {
            super(optionValues, providers);
            this.Fn = this.snippet(providers, a.class, "dynamicNewArraySnippet", new LocationIdentity[0]);
        }
    }
}

