/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.wasm.snippets;

import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public class a {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor Ca = SnippetRuntime.findForeignCall(a.class, (String)"byteCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor Cb = SnippetRuntime.findForeignCall(a.class, (String)"logicByteCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor Cc = SnippetRuntime.findForeignCall(a.class, (String)"charCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor Cd = SnippetRuntime.findForeignCall(a.class, (String)"logicCharCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor Ce = SnippetRuntime.findForeignCall(a.class, (String)"intCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor Cf = SnippetRuntime.findForeignCall(a.class, (String)"logicIntCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor Cg = SnippetRuntime.findForeignCall(a.class, (String)"longCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor Ch = SnippetRuntime.findForeignCall(a.class, (String)"logicLongCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor Ci = SnippetRuntime.findForeignCall(a.class, (String)"objectCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor Cj = SnippetRuntime.findForeignCall(a.class, (String)"logicObjectCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] Ck = new SnippetRuntime.SubstrateForeignCallDescriptor[]{Ca, Cb, Cc, Cd, Ce, Cf, Cg, Ch, Ci, Cj};

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int intCompareAndSwap(int addressNum, int expectedValue, int newValue) {
        Word word = (Word)WordFactory.unsigned((int)addressNum);
        int n2 = word.readInt(0);
        if (n2 == expectedValue) {
            word.writeInt(0, newValue);
        }
        return n2;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static byte byteCompareAndSwap(int addressNum, byte expectedValue, byte newValue) {
        Word word = (Word)WordFactory.unsigned((int)addressNum);
        byte by = word.readByte(0);
        if (by == expectedValue) {
            word.writeByte(0, newValue);
        }
        return by;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean logicByteCompareAndSwap(int address, char expectedValue, char newValue) {
        return a.charCompareAndSwap(address, expectedValue, newValue) == expectedValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static char charCompareAndSwap(int addressNum, char expectedValue, char newValue) {
        Word word = (Word)WordFactory.unsigned((int)addressNum);
        char c2 = word.readChar(0);
        if (c2 == expectedValue) {
            word.writeChar(0, newValue);
        }
        return c2;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean logicCharCompareAndSwap(int address, byte expectedValue, byte newValue) {
        return a.byteCompareAndSwap(address, expectedValue, newValue) == expectedValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean logicIntCompareAndSwap(int address, int expectedValue, int newValue) {
        return a.intCompareAndSwap(address, expectedValue, newValue) == expectedValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static long longCompareAndSwap(int addressNum, long expectedValue, long newValue) {
        Word word = (Word)WordFactory.unsigned((int)addressNum);
        long l2 = word.readLong(0);
        if (l2 == expectedValue) {
            word.writeLong(0, newValue);
        }
        return l2;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean logicLongCompareAndSwap(int address, long expectedValue, long newValue) {
        return a.longCompareAndSwap(address, expectedValue, newValue) == expectedValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object objectCompareAndSwap(int addressNum, Object expectedValue, Object newValue) {
        Word word = (Word)WordFactory.unsigned((int)addressNum);
        Object object = word.readObject(0);
        if (object == expectedValue) {
            word.writeObject(0, newValue);
        }
        return object;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean logicObjectCompareAndSwap(int address, Object expectedValue, Object newValue) {
        return a.objectCompareAndSwap(address, expectedValue, newValue) == expectedValue;
    }
}

