/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.aotjs.substitute.system;

import com.oracle.svm.aotjs.print.h;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

@TargetClass(value=FileOutputStream.class)
final class Target_java_io_FileOutputStream_Web {
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    OutputStream virtualOutputStream;
    @Alias
    private FileDescriptor fd;

    Target_java_io_FileOutputStream_Web() {
    }

    @Substitute
    private static void initIDs() {
    }

    @Substitute
    private void write(int b2, boolean append) throws IOException {
        if (this.fd == FileDescriptor.out) {
            h.dg.write(b2);
        } else if (this.fd == FileDescriptor.err) {
            h.dh.write(b2);
        } else {
            this.virtualOutputStream.write(b2);
        }
    }

    @Substitute
    private void writeBytes(byte[] b2, int off, int len, boolean append) throws IOException {
        if (this.fd == FileDescriptor.out) {
            h.dg.write(b2, off, len);
        } else if (this.fd == FileDescriptor.err) {
            h.dh.write(b2, off, len);
        } else {
            this.virtualOutputStream.write(b2, off, len);
        }
    }

    @Substitute
    private void open0(String name, boolean append) throws IOException {
        this.virtualOutputStream = append ? Files.newOutputStream(Paths.get(name, new String[0]), StandardOpenOption.APPEND) : Files.newOutputStream(Paths.get(name, new String[0]), new OpenOption[0]);
    }
}

