/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.x509;

import com.oracle.jipher.pki.internal.GeneralNameValue;
import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import com.oracle.jipher.tools.asn1.Asn1Exception;
import javax.security.auth.x500.X500Principal;

public class GeneralName {
    private GeneralNameValue name;
    private Type type;

    private GeneralName(Type type, GeneralNameValue gn) {
        this.type = type;
        this.name = gn;
    }

    public GeneralName(X500Principal directoryName) {
        this(Type.DIRECTORY_NAME, new GeneralNameValue.DirName(directoryName));
    }

    public GeneralName(Type type, String strRepn) {
        this(type, GeneralNameValue.create(type, strRepn));
    }

    public GeneralName(Type type, byte[] valueDer) {
        this.type = type;
        this.name = GeneralNameValue.decode(type, Asn1.decodeOne(valueDer));
    }

    public Type getType() {
        return this.type;
    }

    public <T> T getName(Class<T> nameClass) {
        if (nameClass == byte[].class) {
            return nameClass.cast(this.name.getEncoded());
        }
        if (String.class.isAssignableFrom(nameClass)) {
            return nameClass.cast(this.name.toString());
        }
        if (X500Principal.class.isAssignableFrom(nameClass)) {
            if (this.getType() != Type.DIRECTORY_NAME) {
                throw new IllegalArgumentException("Cannot return " + (Object)((Object)this.getType()) + " as X500Principal");
            }
            return nameClass.cast(new X500Principal(this.name.getEncoded()));
        }
        throw new IllegalArgumentException("Cannot return " + (Object)((Object)this.getType()) + " as " + nameClass);
    }

    public byte[] getEncoded() {
        if (this.type == Type.DIRECTORY_NAME) {
            return Asn1.newExplicitTag(this.type.tag, this.name.toAsn1BerValue()).encodeDerOctets();
        }
        Asn1BerValue val = this.name.toAsn1BerValue();
        if (val.constructed) {
            return Asn1.implicit(this.type.tag).newSequence(val.values()).encodeDerOctets();
        }
        return Asn1.implicit(this.type.tag).newPrimitive(val.content()).encodeDerOctets();
    }

    public String toString() {
        return (Object)((Object)this.type) + ":" + this.name.toString();
    }

    public static GeneralName decode(byte[] generalNameEncoding) {
        try {
            Asn1BerValue val = Asn1.decodeOne(generalNameEncoding);
            if (val.tagValue < 0 || val.tagValue > 8) {
                throw new Asn1Exception("Unsupported tag value " + val.tagValue);
            }
            Type type = Type.values()[val.tagValue];
            if (type == Type.DIRECTORY_NAME) {
                return new GeneralName(type, GeneralNameValue.decode(type, val.tag(val.tagValue).explicit()));
            }
            return new GeneralName(type, GeneralNameValue.decode(type, val.tag(val.tagValue)));
        }
        catch (Asn1Exception e) {
            throw new IllegalArgumentException("Invalid GeneralName encoding", e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeneralName)) {
            return false;
        }
        return this.type == ((GeneralName)obj).type && this.name.toString().equals(((GeneralName)obj).name.toString());
    }

    public int hashCode() {
        return this.type.hashCode() + this.name.toString().hashCode();
    }

    public static enum Type {
        OTHER_NAME(0),
        RFC822_NAME(1),
        DNS_NAME(2),
        X400_ADDRESS(3),
        DIRECTORY_NAME(4),
        EDI_PARTY_NAME(5),
        URI(6),
        IP_ADDRESS(7),
        REGISTERED_ID(8);

        int tag;

        private Type(int tag) {
            this.tag = tag;
        }
    }
}

