/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.internal;

import com.oracle.jipher.pki.internal.Util;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import com.oracle.jipher.tools.asn1.Asn1Exception;
import com.oracle.jipher.tools.asn1.UniversalTag;
import java.security.cert.CRLReason;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExtensionHelper {
    public static Map<String, byte[]> processExtns(List<Asn1BerValue> extns, Set<String> nonCriticalOids, Set<String> criticalOids) {
        HashMap<String, byte[]> extnMap = new HashMap<String, byte[]>();
        if (extns == null) {
            return extnMap;
        }
        for (Asn1BerValue ext : extns) {
            List<Asn1BerValue> extContent = ext.tag(UniversalTag.SEQUENCE).count(2, 3).sequence();
            Iterator<Asn1BerValue> iter = extContent.iterator();
            String oid = iter.next().tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
            Asn1BerValue next = iter.next();
            if (next.hasTag(UniversalTag.BOOLEAN)) {
                if (next.getBoolean()) {
                    criticalOids.add(oid);
                } else {
                    nonCriticalOids.add(oid);
                }
                next = iter.next();
            } else {
                nonCriticalOids.add(oid);
            }
            extnMap.put(oid, next.tag(UniversalTag.OCTET_STRING).encodeDerOctets());
            if (!iter.hasNext()) continue;
            throw new Asn1Exception("Unexpected component after extension value.");
        }
        return extnMap;
    }

    public static String extnPrinter(Map<String, byte[]> extns) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, byte[]> entry : extns.entrySet()) {
            sb.append(entry.getKey()).append("=").append(Util.toHex(entry.getValue())).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static CRLReason getReason(int enumeratedReason) {
        switch (enumeratedReason) {
            case 0: {
                return CRLReason.UNSPECIFIED;
            }
            case 1: {
                return CRLReason.KEY_COMPROMISE;
            }
            case 2: {
                return CRLReason.CA_COMPROMISE;
            }
            case 3: {
                return CRLReason.AFFILIATION_CHANGED;
            }
            case 4: {
                return CRLReason.SUPERSEDED;
            }
            case 5: {
                return CRLReason.CESSATION_OF_OPERATION;
            }
            case 6: {
                return CRLReason.CERTIFICATE_HOLD;
            }
            case 8: {
                return CRLReason.REMOVE_FROM_CRL;
            }
            case 9: {
                return CRLReason.PRIVILEGE_WITHDRAWN;
            }
            case 10: {
                return CRLReason.AA_COMPROMISE;
            }
        }
        throw new Asn1Exception("Unknown reason for revocation given");
    }
}

