/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry.range;

import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.range.Range;
import com.oracle.objectfile.debugentry.range.SubRange;

public class PrimaryRange
extends Range {
    protected SubRange firstCallee = null;
    protected SubRange lastCallee = null;

    protected PrimaryRange(MethodEntry methodEntry, int lo, int hi, int line) {
        super(methodEntry, lo, hi, line, -1);
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    protected void addCallee(SubRange callee) {
        assert (this.lo <= callee.lo);
        assert (this.hi >= callee.hi);
        assert (callee.caller == this);
        assert (callee.siblingCallee == null);
        if (this.firstCallee == null) {
            assert (this.lastCallee == null);
            this.firstCallee = this.lastCallee = callee;
        } else {
            this.lastCallee.siblingCallee = callee;
            this.lastCallee = callee;
        }
    }

    @Override
    public SubRange getFirstCallee() {
        return this.firstCallee;
    }

    @Override
    public boolean isLeaf() {
        return this.firstCallee == null;
    }
}

