/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.svm.core.foreign.AbiUtils;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.MemoryLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class FunctionDescriptorParser {
    private FunctionDescriptorParser() {
    }

    public static FunctionDescriptor parse(String input) {
        try {
            Impl parser = new Impl(input);
            FunctionDescriptor res = parser.parseDescriptor();
            parser.checkDone();
            return res;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(input + " could not be parsed as a function descriptor.", e);
        }
    }

    private static void handleError(String msg) {
        throw new FunctionDescriptorParserException(msg);
    }

    private static final class Impl {
        private final String layout;
        private int at;

        private Impl(String input) {
            this.layout = input;
            this.at = 0;
        }

        private char peek() {
            if (this.at == this.layout.length()) {
                return '\u0000';
            }
            return this.layout.charAt(this.at);
        }

        private char consume() {
            if (this.at == this.layout.length()) {
                return '\u0000';
            }
            return this.layout.charAt(this.at++);
        }

        private String consumeName() {
            int start = this.at;
            char c = this.peek();
            while (Character.getType(c) == 2 || c == '_' || c == '*' || c == ' ') {
                this.consume();
                c = this.peek();
            }
            return this.layout.substring(start, this.at).trim().replaceAll("\\h+", " ");
        }

        private String peekName() {
            int start = this.at;
            String word = this.consumeName();
            this.at = start;
            return word;
        }

        private void discardSpaces() {
            while (Character.isSpaceChar(this.peek())) {
                this.consume();
            }
        }

        private void consumeChecked(char expected) {
            char v = this.consume();
            if (v != expected) {
                FunctionDescriptorParser.handleError("Expected " + expected + " but got " + v + " in " + this.layout);
            }
        }

        private <T> List<T> parseSequence(char sep, char start, char end, Supplier<T> parser) {
            this.discardSpaces();
            this.consumeChecked(start);
            this.discardSpaces();
            ArrayList<T> elements = new ArrayList<T>();
            if (this.peek() != end) {
                elements.add(parser.get());
                this.discardSpaces();
            }
            while (this.peek() != end) {
                this.consumeChecked(sep);
                this.discardSpaces();
                elements.add(parser.get());
                this.discardSpaces();
            }
            this.consumeChecked(end);
            return elements;
        }

        private FunctionDescriptor parseDescriptor() {
            MemoryLayout[] arguments = this.parseSequence(',', '(', ')', this::parseLayout).toArray(new MemoryLayout[0]);
            this.discardSpaces();
            if (this.peekName().equals("void")) {
                this.consumeName();
                return FunctionDescriptor.ofVoid(arguments);
            }
            return FunctionDescriptor.of(this.parseLayout(), arguments);
        }

        private long parseInt() {
            int start = this.at;
            boolean atLeastOneDigit = Character.isDigit(this.peek());
            if (!atLeastOneDigit) {
                FunctionDescriptorParser.handleError("Expected a number at position " + this.at + " of layout " + this.layout);
            }
            while (Character.isDigit(this.peek())) {
                this.consume();
            }
            return Long.parseLong(this.layout.substring(start, this.at));
        }

        private MemoryLayout parseLayout() {
            MemoryLayout layout;
            long alignment = -1L;
            if (Character.isDigit(this.peek())) {
                alignment = this.parseInt();
                this.consumeChecked('%');
            }
            switch (this.peek()) {
                case '[': {
                    MemoryLayout memoryLayout = this.parseSequenceLayout();
                    break;
                }
                case '{': {
                    MemoryLayout memoryLayout = this.parseStructLayout();
                    break;
                }
                case '<': {
                    MemoryLayout memoryLayout = this.parseUnionLayout();
                    break;
                }
                case 'X': {
                    MemoryLayout memoryLayout = this.parsePaddingLayout();
                    break;
                }
                default: {
                    MemoryLayout memoryLayout = layout = this.parseValueLayout();
                }
            }
            if (alignment >= 0L) {
                layout = layout.withByteAlignment(alignment);
            }
            if (this.peek() == '(') {
                FunctionDescriptorParser.handleError("Layout parser does not support named layouts: " + String.valueOf(layout));
            }
            return layout;
        }

        private MemoryLayout parseUnionLayout() {
            return MemoryLayout.unionLayout(this.parseSequence(',', '<', '>', this::parseLayout).toArray(new MemoryLayout[0]));
        }

        private MemoryLayout parseStructLayout() {
            return MemoryLayout.structLayout(this.parseSequence(',', '{', '}', this::parseLayout).toArray(new MemoryLayout[0]));
        }

        private MemoryLayout parsePaddingLayout() {
            this.consumeChecked('X');
            return MemoryLayout.paddingLayout(this.parseInt());
        }

        private MemoryLayout parseSequenceLayout() {
            this.consumeChecked('[');
            long size = this.parseInt();
            this.consumeChecked(':');
            MemoryLayout element = this.parseLayout();
            this.consumeChecked(']');
            return MemoryLayout.sequenceLayout(size, element);
        }

        private MemoryLayout parseValueLayout() {
            String name = this.consumeName();
            if (!AbiUtils.singleton().canonicalLayouts().containsKey(name)) {
                FunctionDescriptorParser.handleError("Unknown value layout: " + name + " at " + this.at + " in " + this.layout);
            }
            return AbiUtils.singleton().canonicalLayouts().get(name);
        }

        private void checkDone() {
            if (this.at < this.layout.length()) {
                FunctionDescriptorParser.handleError("Layout parsing ended (at " + this.at + ") before its end: " + this.layout);
            }
        }
    }

    public static final class FunctionDescriptorParserException
    extends RuntimeException {
        public FunctionDescriptorParserException(String msg) {
            super(msg);
        }
    }
}

