/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.LinkToNativeSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.ForeignFunctionsRuntime;
import com.oracle.svm.core.foreign.LinkToNativeSupportImpl;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.foreign.RuntimeSystemLookup;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.foreign.DowncallStub;
import com.oracle.svm.hosted.foreign.ForeignFunctionsConfigurationParser;
import com.oracle.svm.hosted.foreign.LowLevelUpcallStub;
import com.oracle.svm.hosted.foreign.StronglyTypedRuntimeForeignAccessSupport;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.reflect.Executable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeForeignAccessSupport;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.HOSTED_ONLY.class})
public class ForeignFunctionsFeature
implements InternalFeature {
    private static final Map<String, String[]> REQUIRES_CONCEALED = Map.of("jdk.internal.vm.ci", new String[]{"jdk.vm.ci.code", "jdk.vm.ci.meta", "jdk.vm.ci.amd64"}, "java.base", new String[]{"jdk.internal.foreign", "jdk.internal.foreign.abi", "jdk.internal.foreign.abi.x64", "jdk.internal.foreign.abi.x64.sysv", "jdk.internal.foreign.abi.x64.windows"});
    private boolean sealed = false;
    private final RuntimeForeignAccessSupportImpl accessSupport = new RuntimeForeignAccessSupportImpl();
    private final Set<Pair<FunctionDescriptor, Linker.Option[]>> registeredDowncalls = ConcurrentHashMap.newKeySet();
    private int downcallCount = -1;
    private final Set<Pair<FunctionDescriptor, Linker.Option[]>> registeredUpcalls = ConcurrentHashMap.newKeySet();
    private int upcallCount = -1;

    @Fold
    public static ForeignFunctionsFeature singleton() {
        return (ForeignFunctionsFeature)ImageSingletons.lookup(ForeignFunctionsFeature.class);
    }

    private void checkNotSealed() {
        UserError.guarantee((!this.sealed ? 1 : 0) != 0, (String)"Registration of foreign functions was closed.", (Object[])new Object[0]);
    }

    ForeignFunctionsFeature() {
        for (Map.Entry<String, String[]> modulePackages : REQUIRES_CONCEALED.entrySet()) {
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.EXPORT, ForeignFunctionsFeature.class, (boolean)false, (String)modulePackages.getKey(), (String[])modulePackages.getValue());
        }
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        if (!((Boolean)SubstrateOptions.ForeignAPISupport.getValue()).booleanValue()) {
            return false;
        }
        UserError.guarantee((JavaVersionUtil.JAVA_SPEC >= 22 ? 1 : 0) != 0, (String)"Support for the Foreign Function and Memory API is available only with JDK 22 and later.", (Object[])new Object[0]);
        UserError.guarantee((boolean)SubstrateUtil.getArchitectureName().contains("amd64"), (String)"Support for the Foreign Function and Memory API is currently available only on the AMD64 architecture.", (Object[])new Object[0]);
        UserError.guarantee((!SubstrateOptions.useLLVMBackend() ? 1 : 0) != 0, (String)"Support for the Foreign Function and Memory API is not available with the LLVM backend.", (Object[])new Object[0]);
        return true;
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        ImageSingletons.add(AbiUtils.class, (Object)AbiUtils.create());
        ImageSingletons.add(ForeignFunctionsRuntime.class, (Object)new ForeignFunctionsRuntime());
        ImageSingletons.add(RuntimeForeignAccessSupport.class, (Object)this.accessSupport);
        ImageSingletons.add(LinkToNativeSupport.class, (Object)new LinkToNativeSupportImpl());
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ForeignFunctionsConfigurationParser parser = new ForeignFunctionsConfigurationParser(this.accessSupport);
        ConfigurationParserUtils.parseAndRegisterConfigurations((ConfigurationParser)parser, (ImageClassLoader)access.getImageClassLoader(), (String)"panama foreign", (HostedOptionKey)ConfigurationFiles.Options.ForeignConfigurationFiles, (HostedOptionKey)ConfigurationFiles.Options.ForeignResources, (String)ConfigurationFile.FOREIGN.getFileName());
    }

    private void createDowncallStubs(FeatureImpl.BeforeAnalysisAccessImpl access) {
        this.downcallCount = this.createStubs(this.registeredDowncalls, access, false, AbiUtils.singleton()::makeNativeEntrypoint, n -> new DowncallStub((NativeEntryPointInfo)n, access.getMetaAccess().getWrapped()), ForeignFunctionsRuntime.singleton()::addDowncallStubPointer);
    }

    private void createUpcallStubs(FeatureImpl.BeforeAnalysisAccessImpl access) {
        this.upcallCount = this.createStubs(this.registeredUpcalls, access, true, AbiUtils.singleton()::makeJavaEntryPoint, jepi -> LowLevelUpcallStub.make(jepi, access.getUniverse(), access.getMetaAccess().getWrapped()), ForeignFunctionsRuntime.singleton()::addUpcallStubPointer);
    }

    private <S> int createStubs(Set<Pair<FunctionDescriptor, Linker.Option[]>> source, FeatureImpl.BeforeAnalysisAccessImpl access, boolean registerAsEntryPoints, BiFunction<FunctionDescriptor, Linker.Option[], S> stubGenerator, Function<S, ResolvedJavaMethod> wrapper, BiConsumer<S, CFunctionPointer> register) {
        HashMap<S, AnalysisMethod> created = new HashMap<S, AnalysisMethod>();
        for (Pair<FunctionDescriptor, Linker.Option[]> fdOptionsPair : source) {
            S nepi = stubGenerator.apply((FunctionDescriptor)fdOptionsPair.getLeft(), (Linker.Option[])fdOptionsPair.getRight());
            if (created.containsKey(nepi)) continue;
            ResolvedJavaMethod stub = wrapper.apply(nepi);
            AnalysisMethod analysisStub = access.getUniverse().lookup((JavaMethod)stub);
            access.getBigBang().addRootMethod(analysisStub, false, (Object)("Foreign stub, registered in " + String.valueOf(ForeignFunctionsFeature.class)), new MultiMethod.MultiMethodKey[0]);
            if (registerAsEntryPoints) {
                analysisStub.registerAsEntryPoint((Object)CEntryPointData.createCustomUnpublished());
            }
            created.put(nepi, analysisStub);
            register.accept(nepi, (CFunctionPointer)new MethodPointer((ResolvedJavaMethod)analysisStub));
        }
        source.clear();
        return created.size();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        this.sealed = true;
        AbiUtils.singleton().checkLibrarySupport();
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.foreign.abi.DowncallLinker"), (String)"USE_SPEC"), (receiver, originalValue) -> false);
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.foreign.abi.UpcallLinker"), (String)"USE_SPEC"), (receiver, originalValue) -> false);
        RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{RuntimeSystemLookup.class});
        access.registerAsRoot((Executable)ReflectionUtil.lookupMethod(ForeignFunctionsRuntime.class, (String)"captureCallState", (Class[])new Class[]{Integer.TYPE, CIntPointer.class}), false, "Runtime support, registered in " + String.valueOf(ForeignFunctionsFeature.class), new MultiMethod.MultiMethodKey[0]);
        this.createDowncallStubs(access);
        this.createUpcallStubs(access);
        ProgressReporter.singleton().setForeignFunctionsInfo(this.getCreatedDowncallStubsCount(), this.getCreatedUpcallStubsCount());
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{ForeignFunctionsRuntime.CAPTURE_CALL_STATE});
    }

    public int getCreatedDowncallStubsCount() {
        assert (this.sealed);
        assert (this.downcallCount >= 0);
        return this.downcallCount;
    }

    public int getCreatedUpcallStubsCount() {
        assert (this.sealed);
        assert (this.upcallCount >= 0);
        return this.upcallCount;
    }

    private class RuntimeForeignAccessSupportImpl
    extends ConditionalConfigurationRegistry
    implements StronglyTypedRuntimeForeignAccessSupport {
        private RuntimeForeignAccessSupportImpl() {
        }

        @Override
        public void registerForDowncall(ConfigurationCondition condition, FunctionDescriptor desc, Linker.Option ... options) {
            ForeignFunctionsFeature.this.checkNotSealed();
            this.registerConditionalConfiguration(condition, cnd -> ForeignFunctionsFeature.this.registeredDowncalls.add((Pair<FunctionDescriptor, Linker.Option[]>)Pair.create((Object)desc, (Object)options)));
        }

        @Override
        public void registerForUpcall(ConfigurationCondition condition, FunctionDescriptor desc, Linker.Option ... options) {
            ForeignFunctionsFeature.this.checkNotSealed();
            this.registerConditionalConfiguration(condition, ignored -> ForeignFunctionsFeature.this.registeredUpcalls.add((Pair<FunctionDescriptor, Linker.Option[]>)Pair.create((Object)desc, (Object)options)));
        }
    }
}

