/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.JavaEntryPointInfo;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.foreign.TrampolineSet;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.headers.WindowsAPIs;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.internal.foreign.abi.CapturableState;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public class ForeignFunctionsRuntime {
    private final AbiUtils.TrampolineTemplate trampolineTemplate = AbiUtils.singleton().generateTrampolineTemplate();
    private final EconomicMap<NativeEntryPointInfo, FunctionPointerHolder> downcallStubs = EconomicMap.create();
    private final EconomicMap<JavaEntryPointInfo, FunctionPointerHolder> upcallStubs = EconomicMap.create();
    private final Map<Long, TrampolineSet> trampolines = new HashMap<Long, TrampolineSet>();
    private TrampolineSet currentTrampolineSet;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CAPTURE_CALL_STATE = SnippetRuntime.findForeignCall(ForeignFunctionsRuntime.class, (String)"captureCallState", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});

    @Fold
    public static ForeignFunctionsRuntime singleton() {
        return (ForeignFunctionsRuntime)ImageSingletons.lookup(ForeignFunctionsRuntime.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ForeignFunctionsRuntime() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addDowncallStubPointer(NativeEntryPointInfo nep, CFunctionPointer ptr) {
        VMError.guarantee((!this.downcallStubs.containsKey((Object)nep) ? 1 : 0) != 0, (String)"Seems like multiple stubs were generated for %s", (Object)nep);
        VMError.guarantee((this.downcallStubs.put((Object)nep, (Object)new FunctionPointerHolder(ptr)) == null ? 1 : 0) != 0);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addUpcallStubPointer(JavaEntryPointInfo jep, CFunctionPointer ptr) {
        VMError.guarantee((!this.upcallStubs.containsKey((Object)jep) ? 1 : 0) != 0, (String)("Seems like multiple stubs were generated for " + String.valueOf(jep)));
        VMError.guarantee((this.upcallStubs.put((Object)jep, (Object)new FunctionPointerHolder(ptr)) == null ? 1 : 0) != 0);
    }

    CFunctionPointer getDowncallStubPointer(NativeEntryPointInfo nep) {
        FunctionPointerHolder holder = (FunctionPointerHolder)this.downcallStubs.get((Object)nep);
        if (holder == null) {
            throw new UnregisteredForeignStubException(nep);
        }
        return holder.functionPointer;
    }

    CFunctionPointer getUpcallStubPointer(JavaEntryPointInfo jep) {
        FunctionPointerHolder holder = (FunctionPointerHolder)this.upcallStubs.get((Object)jep);
        if (holder == null) {
            throw new UnregisteredForeignStubException(jep);
        }
        return holder.functionPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pointer registerForUpcall(MethodHandle methodHandle, JavaEntryPointInfo jep) {
        Map<Long, TrampolineSet> map = this.trampolines;
        synchronized (map) {
            if (this.currentTrampolineSet == null || !this.currentTrampolineSet.hasFreeTrampolines()) {
                this.currentTrampolineSet = new TrampolineSet(this.trampolineTemplate);
                this.trampolines.put(this.currentTrampolineSet.base().rawValue(), this.currentTrampolineSet);
            }
            return this.currentTrampolineSet.assignTrampoline(methodHandle, this.getUpcallStubPointer(jep));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeTrampoline(long addr) {
        Map<Long, TrampolineSet> map = this.trampolines;
        synchronized (map) {
            long base = TrampolineSet.getAllocationBase((Pointer)WordFactory.pointer((long)addr)).rawValue();
            TrampolineSet trampolineSet = this.trampolines.get(base);
            if (trampolineSet.tryFree()) {
                this.trampolines.remove(base);
            }
        }
    }

    @Fold
    static int getMask(CapturableState state) {
        return state.mask();
    }

    @Fold
    static boolean isWindows() {
        return OS.WINDOWS.isCurrent();
    }

    @Uninterruptible(reason="Interruptions might change call state.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+12/src/hotspot/share/prims/downcallLinker.cpp")
    public static void captureCallState(int statesToCapture, CIntPointer captureBuffer) {
        assert (statesToCapture != 0);
        assert (captureBuffer.isNonNull());
        int i = 0;
        if (ForeignFunctionsRuntime.isWindows()) {
            assert (WindowsAPIs.isSupported()) : "Windows APIs should be supported on Windows OS";
            if ((statesToCapture & ForeignFunctionsRuntime.getMask(CapturableState.GET_LAST_ERROR)) != 0) {
                captureBuffer.write(i, WindowsAPIs.getLastError());
            }
            ++i;
            if ((statesToCapture & ForeignFunctionsRuntime.getMask(CapturableState.WSA_GET_LAST_ERROR)) != 0) {
                captureBuffer.write(i, WindowsAPIs.wsaGetLastError());
            }
            ++i;
        }
        assert (LibC.isSupported()) : "LibC should always be supported";
        if ((statesToCapture & ForeignFunctionsRuntime.getMask(CapturableState.ERRNO)) != 0) {
            captureBuffer.write(i, LibC.errno());
        }
        ++i;
    }

    public static class UnregisteredForeignStubException
    extends RuntimeException {
        UnregisteredForeignStubException(NativeEntryPointInfo nep) {
            super(UnregisteredForeignStubException.generateMessage(nep));
        }

        UnregisteredForeignStubException(JavaEntryPointInfo jep) {
            super(UnregisteredForeignStubException.generateMessage(jep));
        }

        private static String generateMessage(NativeEntryPointInfo nep) {
            return "Cannot perform downcall with leaf type " + String.valueOf(nep.methodType()) + " as it was not registered at compilation time.";
        }

        private static String generateMessage(JavaEntryPointInfo jep) {
            return "Cannot perform upcall with leaf type " + String.valueOf(jep.cMethodType()) + " as it was not registered at compilation time.";
        }
    }
}

