// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SubstrateGCOptions.java
package com.oracle.svm.core;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class SubstrateGCOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "DisableExplicitGC": {
            return OptionDescriptor.create(
                /*name*/ "DisableExplicitGC",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Ignore calls to System.gc().",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "DisableExplicitGC",
                /*option*/ SubstrateGCOptions.DisableExplicitGC,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ExitOnOutOfMemoryError": {
            return OptionDescriptor.create(
                /*name*/ "ExitOnOutOfMemoryError",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exit on the first occurrence of an out-of-memory error that is thrown because the Java heap is out of memory.",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "ExitOnOutOfMemoryError",
                /*option*/ SubstrateGCOptions.ExitOnOutOfMemoryError,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxHeapSize": {
            return OptionDescriptor.create(
                /*name*/ "MaxHeapSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The maximum heap size at run-time, in bytes.",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "MaxHeapSize",
                /*option*/ SubstrateGCOptions.MaxHeapSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxNewSize": {
            return OptionDescriptor.create(
                /*name*/ "MaxNewSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The maximum size of the young generation at run-time, in bytes",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "MaxNewSize",
                /*option*/ SubstrateGCOptions.MaxNewSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MinHeapSize": {
            return OptionDescriptor.create(
                /*name*/ "MinHeapSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The minimum heap size at run-time, in bytes.",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "MinHeapSize",
                /*option*/ SubstrateGCOptions.MinHeapSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGC": {
            return OptionDescriptor.create(
                /*name*/ "PrintGC",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print summary GC information after each collection.",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "PrintGC",
                /*option*/ SubstrateGCOptions.PrintGC,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReportFatalErrorOnOutOfMemoryError": {
            return OptionDescriptor.create(
                /*name*/ "ReportFatalErrorOnOutOfMemoryError",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report a fatal error on the first occurrence of an out-of-memory error that is thrown because the Java heap is out of memory.",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "ReportFatalErrorOnOutOfMemoryError",
                /*option*/ SubstrateGCOptions.ReportFatalErrorOnOutOfMemoryError,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReservedAddressSpaceSize": {
            return OptionDescriptor.create(
                /*name*/ "ReservedAddressSpaceSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of bytes that should be reserved for the heap address space.",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "ReservedAddressSpaceSize",
                /*option*/ SubstrateGCOptions.ReservedAddressSpaceSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TreatRuntimeCodeInfoReferencesAsWeak": {
            return OptionDescriptor.create(
                /*name*/ "TreatRuntimeCodeInfoReferencesAsWeak",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if references from runtime-compiled code to Java heap objects should be treated as strong or weak.",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "TreatRuntimeCodeInfoReferencesAsWeak",
                /*option*/ SubstrateGCOptions.TreatRuntimeCodeInfoReferencesAsWeak,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerboseGC": {
            return OptionDescriptor.create(
                /*name*/ "VerboseGC",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print more information about the heap before and after each collection.",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "VerboseGC",
                /*option*/ SubstrateGCOptions.VerboseGC,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyHeap": {
            return OptionDescriptor.create(
                /*name*/ "VerifyHeap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the heap before and after each collection.",
                /*declaringClass*/ SubstrateGCOptions.class,
                /*fieldName*/ "VerifyHeap",
                /*option*/ SubstrateGCOptions.VerifyHeap,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 11;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("DisableExplicitGC");
                    case 1: return get("ExitOnOutOfMemoryError");
                    case 2: return get("MaxHeapSize");
                    case 3: return get("MaxNewSize");
                    case 4: return get("MinHeapSize");
                    case 5: return get("PrintGC");
                    case 6: return get("ReportFatalErrorOnOutOfMemoryError");
                    case 7: return get("ReservedAddressSpaceSize");
                    case 8: return get("TreatRuntimeCodeInfoReferencesAsWeak");
                    case 9: return get("VerboseGC");
                    case 10: return get("VerifyHeap");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
