/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_en_CA extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Gulf = new String[] {
               "Gulf Standard Time",
               "Gulf Time",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Iran Standard Time",
               "IRST",
               "Iran Daylight Saving Time",
               "IRDT",
               "Iran Time",
               "",
            };
        final String[] Peru = new String[] {
               "Peru Standard Time",
               "",
               "Peru Summer Time",
               "",
               "Peru Time",
               "PET",
            };
        final String[] Cocos = new String[] {
               "Cocos Islands Time",
               "CCT",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India Standard Time",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Nepal = new String[] {
               "Nepal Time",
               "NPT",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa Standard Time",
               "SST",
               "Samoan Time",
               "SST",
               "Samoa Time",
               "SST",
            };
        final String[] Alaska = new String[] {
               "Alaska Standard Time",
               "AKST",
               "Alaska Daylight Saving Time",
               "AKDT",
               "Alaska Time",
               "AKT",
            };
        final String[] Bhutan = new String[] {
               "Bhutan Time",
               "BTT",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam Time",
               "BNT",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Easter Island Standard Time",
               "EAST",
               "Easter Island Summer Time",
               "EASST",
               "Easter Island Time",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana Time",
               "GYT",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis and Futuna Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham Standard Time",
               "CHAST",
               "Chatham Daylight Time",
               "CHADT",
               "Chatham Time",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuador Time",
               "ECT",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha Standard Time",
               "",
               "Fernando de Noronha Summer Time",
               "",
               "Fernando de Noronha Time",
               "FNT",
            };
        final String[] Uruguay = new String[] {
               "Uruguay Standard Time",
               "UYT",
               "Uruguay Summer Time",
               "UYST",
               "Uruguay Time",
               "",
            };
        final String[] Brasilia = new String[] {
               "Brasilia Standard Time",
               "",
               "Brasilia Summer Time",
               "BRST",
               "Brasilia Time",
               "BRT",
            };
        final String[] Colombia = new String[] {
               "Colombia Standard Time",
               "",
               "Colombia Summer Time",
               "COST",
               "Colombia Time",
               "",
            };
        final String[] Falkland = new String[] {
               "Falkland Islands Standard Time",
               "",
               "Falkland Islands Summer Time",
               "FKST",
               "Falkland Islands Time",
               "FKT",
            };
        final String[] Malaysia = new String[] {
               "Malaysia Time",
               "MYT",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldives Time",
               "MVT",
               "",
               "",
               "",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Standard Time",
               "PKT",
               "Pakistan Summer Time",
               "PKST",
               "Pakistan Time",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay Standard Time",
               "",
               "Paraguay Summer Time",
               "PYST",
               "Paraguay Time",
               "PYT",
            };
        final String[] Argentina = new String[] {
               "Argentina Standard Time",
               "",
               "Argentina Summer Time",
               "",
               "Argentina Time",
               "ART",
            };
        final String[] Christmas = new String[] {
               "Christmas Island Time",
               "CXT",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos Time",
               "GALT",
               "",
               "",
               "",
               "",
            };
        final String[] Indochina = new String[] {
               "Indochina Time",
               "ICT",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela Time",
               "VET",
               "",
               "",
               "",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesh Standard Time",
               "BST",
               "Bangladesh Summer Time",
               "",
               "Bangladesh Time",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "East Timor Time",
               "TLT",
               "",
               "",
               "",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan Time",
               "AFT",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland Standard Time",
               "NST",
               "Newfoundland Daylight Time",
               "NDT",
               "Newfoundland Time",
               "NT",
            };
        final String[] America_Central = new String[] {
               "Central Standard Time",
               "CST",
               "Central Daylight Saving Time",
               "CDT",
               "Central Time",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern Standard Time",
               "EST",
               "Eastern Daylight Saving Time",
               "EDT",
               "Eastern Time",
               "ET",
            };
        final String[] French_Southern = new String[] {
               "French Southern and Antarctic Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre-et-Miquelon Standard Time",
               "PMST",
               "Saint-Pierre-et-Miquelon Daylight Saving Time",
               "PMDT",
               "Saint-Pierre-et-Miquelon Time",
               "PMT",
            };
        final String[] Australia_Eastern = new String[] {
               "Australian Eastern Standard Time",
               "AEST",
               "Australian Eastern Daylight Time",
               "AEDT",
               "Eastern Australia Time",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Australian Western Standard Time",
               "AWST",
               "Australian Western Daylight Time",
               "AWDT",
               "Western Australia Time",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia Time",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia Time",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia Time",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australian Central Western Standard Time",
               "ACWST",
               "Australian Central Western Daylight Time",
               "ACWDT",
               "Australian Central Western Time",
               "ACWT",
            };
        final Object[][] data = new Object[][] {
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "America/Anchorage", Alaska },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "UTC", EMPTY_ZONE },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "EST", America_Eastern },
            { "IET", America_Eastern },
            { "IST", India },
            { "PLT", Pakistan },
            { "VST", Indochina },
            { "Iran", Iran },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Jamaica", America_Eastern },
            { "NZ-CHAT", Chatham },
            { "US/Samoa", Samoa },
            { "Asia/Dili", East_Timor },
            { "US/Alaska", Alaska },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Muscat", Gulf },
            { "Asia/Saigon", Indochina },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "US/Michigan", America_Eastern },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Bangkok", Indochina },
            { "Asia/Colombo", India },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Thimphu", Bhutan },
            { "Indian/Cocos", Cocos },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Makassar", Indonesia_Central },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/NSW", Australia_Eastern },
            { "Pacific/Samoa", Samoa },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Guyana", Guyana },
            { "America/Juneau", Alaska },
            { "America/Maceio", Brasilia },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Singapore", Malaysia },
            { "Asia/Vientiane", Indochina },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Indian/Reunion", Gulf },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Midway", Samoa },
            { "Pacific/Tarawa", Wallis },
            { "Pacific/Wallis", Wallis },
            { "America/Caracas", Venezuela },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Mendoza", Argentina },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Toronto", America_Eastern },
            { "America/Yakutat", Alaska },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/YST9YDT", Alaska },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "America/Araguaina", Brasilia },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Pago_Pago", Samoa },
            { "US/Indiana-Starke", America_Central },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Louisville", America_Eastern },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "America/El_Salvador", America_Central },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "America/Buenos_Aires", Argentina },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Atlantic/St_Helena", "Saint Helena" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
        };
        return data;
    }
}
