/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import com.oracle.svm.util.LogUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.debug.GraalError;

public class FileDumpingUtil {
    public static Path createTempFile(Path directory, String name, String suffix) {
        try {
            long start = System.nanoTime();
            String filePrefix = String.format(name + "-%d", start);
            return Files.createTempFile(directory, filePrefix, suffix, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw GraalError.shouldNotReachHere((Throwable)e, (String)"Error during temporary file creation.");
        }
    }

    @SuppressFBWarnings(value={""}, justification="FB reports null pointer dereferencing although it is not possible in this case.")
    public static void dumpFile(Path path, String name, String suffix, Consumer<OutputStream> streamConsumer) {
        Path tempPath = FileDumpingUtil.createTempFile(path.getParent(), name, suffix);
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempPath.toFile());){
                streamConsumer.accept(fileOutputStream);
            }
            FileDumpingUtil.moveTryAtomically(tempPath, path);
        }
        catch (Exception e) {
            throw GraalError.shouldNotReachHere((Throwable)e, (String)"Error during file dumping.");
        }
    }

    public static void moveTryAtomically(Path source, Path target) throws IOException {
        try {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            LogUtils.warning("Could not move temporary file (" + String.valueOf(source.toAbsolutePath()) + ") to (" + String.valueOf(target.toAbsolutePath()) + ") atomically. This might result in inconsistencies while reading the file.");
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

