/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted;

import com.oracle.graal.vector.replacements.vectorapi.VectorAPIExpansionPhase;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.VectorAPISupport;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.IntFunction;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.LoweringPhase;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapePhase;
import jdk.internal.misc.Unsafe;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

@AutomaticallyRegisteredFeature
public class t
implements InternalFeature {
    public static final String qu = "jdk.incubator.vector";
    static final Unsafe qv = Unsafe.getUnsafe();

    public String getDescription() {
        return "Registers Vector API classes for initialization at build time and pre-populates some caches.";
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        boolean bl2;
        boolean bl3 = bl2 = isInConfigurationAccess.findClassByName("jdk.incubator.vector.VectorShape") != null;
        if (!bl2) {
            return false;
        }
        if (!((Boolean)SubstrateOptions.VectorAPISupport.getValue()).booleanValue()) {
            LogUtils.warning((String)"This application uses the Vector API module %s. Please enable %s to optimize Vector API operations.", (Object[])new Object[]{qu, SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.VectorAPISupport, (String)"+")});
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        void var16_28;
        Object object4;
        String string;
        void var14_18;
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{qu});
        Class clazz = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.VectorShape");
        qv.ensureClassInitialized(clazz);
        int n2 = Math.max(VectorAPISupport.singleton().getMaxVectorBytes() * 8, 64);
        Class[] classArray = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE};
        String[] stringArray = new String[]{"Byte", "Short", "Int", "Long", "Float", "Double"};
        String[] string2 = new String[]{"64", "128", "256", "512", "Max"};
        Object object5 = ReflectionUtil.readStaticField((Class)clazz, (String)"S_Max_BIT");
        beforeAnalysisAccess.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)clazz, (String)"vectorBitSize"), (object2, object3) -> object2 == object5 ? Integer.valueOf(n2) : object3);
        beforeAnalysisAccess.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)clazz, (String)"vectorBitSizeLog2"), (object2, object3) -> object2 == object5 ? Integer.valueOf(Integer.numberOfTrailingZeros(n2)) : object3);
        int n3 = Math.min(Integer.numberOfTrailingZeros(n2 / 64), string2.length - 1);
        String string3 = string2[n3];
        Object object6 = ReflectionUtil.readStaticField((Class)clazz, (String)("S_" + string3 + "_BIT"));
        EconomicMap economicMap = EconomicMap.create();
        Class[] object10 = classArray;
        int object11 = object10.length;
        boolean bl2 = false;
        while (var14_18 < object11) {
            Class clazz2 = object10[var14_18];
            String string4 = clazz2.getName().substring(0, 1).toUpperCase(Locale.ROOT) + clazz2.getName().substring(1);
            String string5 = "jdk.incubator.vector." + string4 + "Vector";
            Class clazz3 = ReflectionUtil.lookupClass((String)string5);
            qv.ensureClassInitialized(clazz3);
            Object object7 = ReflectionUtil.readStaticField((Class)clazz3, (String)"SPECIES_MAX");
            economicMap.put(object7, (Object)new a(VectorAPISupport.singleton().getMaxLaneCount(clazz2), Integer.numberOfTrailingZeros(VectorAPISupport.singleton().getMaxLaneCount(clazz2)) + 1, n2, n2 / 8));
            Object object8 = ReflectionUtil.lookupMethod((Class)clazz3, (String)"species", (Class[])new Class[]{clazz});
            beforeAnalysisAccess.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)clazz3, (String)"SPECIES_PREFERRED"), (arg_0, arg_1) -> t.a((Method)object8, object6, arg_0, arg_1));
            string = "jdk.incubator.vector." + string4 + "MaxVector";
            object4 = ReflectionUtil.lookupClass((String)string);
            beforeAnalysisAccess.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)object4, (String)"VSIZE"), (object, object2) -> n2);
            beforeAnalysisAccess.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)object4, (String)"VLENGTH"), (object, object2) -> VectorAPISupport.singleton().getMaxLaneCount(clazz2));
            ++var14_18;
        }
        Class clazz4 = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.AbstractSpecies");
        beforeAnalysisAccess.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)clazz4, (String)"laneCount"), (FieldValueTransformer)new b((EconomicMap<Object, a>)economicMap, a::el));
        beforeAnalysisAccess.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)clazz4, (String)"laneCountLog2P1"), (FieldValueTransformer)new b((EconomicMap<Object, a>)economicMap, a::em));
        beforeAnalysisAccess.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)clazz4, (String)"vectorBitSize"), (FieldValueTransformer)new b((EconomicMap<Object, a>)economicMap, a::en));
        beforeAnalysisAccess.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)clazz4, (String)"vectorByteSize"), (FieldValueTransformer)new b((EconomicMap<Object, a>)economicMap, a::eo));
        for (String string6 : stringArray) {
            for (Object object8 : string2) {
                string = string6 + (String)object8;
                object4 = "jdk.incubator.vector." + string + "Vector";
                Class clazz5 = ReflectionUtil.lookupClass((String)((String)object4 + "$" + string + "Shuffle"));
                qv.ensureClassInitialized(clazz5);
                beforeAnalysisAccess.registerAsUsed(clazz5);
                Class clazz6 = ReflectionUtil.lookupClass((String)((String)object4 + "$" + string + "Mask"));
                qv.ensureClassInitialized(clazz6);
                beforeAnalysisAccess.registerAsUsed(clazz6);
            }
        }
        c c2 = new c();
        String[] stringArray2 = stringArray;
        int n4 = stringArray2.length;
        boolean bl3 = false;
        while (var16_28 < n4) {
            String string7 = stringArray2[var16_28];
            String string8 = "jdk.incubator.vector." + string7 + "Vector";
            Class clazz7 = ReflectionUtil.lookupClass((String)string8);
            qv.ensureClassInitialized(clazz7);
            t.a(clazz7, "UN_IMPL", "unaryOperations", c2);
            t.a(clazz7, "BIN_IMPL", "binaryOperations", c2);
            t.a(clazz7, "TERN_IMPL", "ternaryOperations", c2);
            t.a(clazz7, "REDUCE_IMPL", "reductionOperations", c2);
            ++var16_28;
        }
        Class clazz8 = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.VectorOperators$ConversionImpl");
        qv.ensureClassInitialized(clazz8);
        t.a(clazz8, c2);
    }

    private static void a(Class<?> clazz, String string, String string2, c c2) {
        Object object = ReflectionUtil.readStaticField(clazz, (String)string);
        Method method = ReflectionUtil.lookupMethod(clazz, (String)string2, (Class[])new Class[]{Integer.TYPE});
        IntFunction<Object> intFunction = n2 -> {
            try {
                return method.invoke(null, n2);
            }
            catch (Throwable throwable) {
                throw VMError.shouldNotReachHere((Throwable)throwable);
            }
        };
        for (int n3 : c2.qF) {
            try {
                c2.qE.invoke(object, null, n3, intFunction);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof UnsupportedOperationException) continue;
                throw VMError.shouldNotReachHere((Throwable)invocationTargetException);
            }
            catch (Throwable throwable) {
                throw VMError.shouldNotReachHere((Throwable)throwable);
            }
        }
    }

    public static void a(Class<?> clazz, c c2) {
        Method method = ReflectionUtil.lookupMethod(clazz, (String)"makeConv", (Class[])new Class[]{Character.TYPE, c2.qG, c2.qG});
        for (char c3 : c.qJ) {
            for (Object object : c2.qH) {
                for (Object object2 : c2.qH) {
                    ReflectionUtil.invokeMethod((Method)method, null, (Object[])new Object[]{Character.valueOf(c3), object, object2});
                }
            }
        }
    }

    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason parsingReason) {
        if (com.oracle.graal.vector.replacements.vectorapi.b.b((OptionValues)HostedOptionValues.singleton(), (boolean)true)) {
            com.oracle.graal.vector.replacements.vectorapi.b.a((InvocationPlugins)plugins.getInvocationPlugins(), (OptionValues)HostedOptionValues.singleton(), (Replacements)providers.getReplacements(), (boolean)true);
        }
    }

    public void registerGraalPhases(Providers providers, Suites suites, boolean bl2) {
        if (com.oracle.graal.vector.replacements.vectorapi.b.b((OptionValues)HostedOptionValues.singleton(), (boolean)true)) {
            ListIterator listIterator = suites.getHighTier().findPhase(PartialEscapePhase.class, true);
            if (listIterator == null) {
                listIterator = suites.getHighTier().findPhase(LoweringPhase.class);
                listIterator.previous();
            }
            listIterator.add(new VectorAPIExpansionPhase(CanonicalizerPhase.create()));
        }
    }

    private static /* synthetic */ Object a(Method method, Object object, Object object2, Object object3) {
        return ReflectionUtil.invokeMethod((Method)method, null, (Object[])new Object[]{object});
    }

    private static final class a
    extends Record {
        private final int qw;
        private final int qx;
        private final int qy;
        private final int qz;

        private a(int n2, int n3, int n4, int n5) {
            this.qw = n2;
            this.qx = n3;
            this.qy = n4;
            this.qz = n5;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "laneCount;laneCountLog2P1;vectorBitSize;vectorByteSize", "qw", "qx", "qy", "qz"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "laneCount;laneCountLog2P1;vectorBitSize;vectorByteSize", "qw", "qx", "qy", "qz"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "laneCount;laneCountLog2P1;vectorBitSize;vectorByteSize", "qw", "qx", "qy", "qz"}, this, object);
        }

        public int el() {
            return this.qw;
        }

        public int em() {
            return this.qx;
        }

        public int en() {
            return this.qy;
        }

        public int eo() {
            return this.qz;
        }
    }

    private static final class b
    extends Record
    implements FieldValueTransformer {
        private final EconomicMap<Object, a> qA;
        private final Function<a, Object> qB;

        private b(EconomicMap<Object, a> economicMap, Function<a, Object> function) {
            this.qA = economicMap;
            this.qB = function;
        }

        public Object transform(Object object, Object object2) {
            a a2 = (a)this.qA.get(object);
            if (a2 != null) {
                return this.qB.apply(a2);
            }
            return object2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "map;accessor", "qA", "qB"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "map;accessor", "qA", "qB"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "map;accessor", "qA", "qB"}, this, object);
        }

        public EconomicMap<Object, a> ep() {
            return this.qA;
        }

        public Function<a, Object> eq() {
            return this.qB;
        }
    }

    private static final class c {
        final Class<?> qC = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.VectorOperators$ImplCache");
        final Class<?> qD = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.VectorOperators$Operator");
        final Method qE = ReflectionUtil.lookupMethod(this.qC, (String)"find", (Class[])new Class[]{this.qD, Integer.TYPE, IntFunction.class});
        final int[] qF;
        final Class<?> qG;
        final Object[] qH;
        private static final String[] qI = new String[]{"FLOAT", "DOUBLE", "BYTE", "SHORT", "INT", "LONG"};
        private static final char[] qJ = "ICRZ".toCharArray();

        private c() {
            Class clazz = ReflectionUtil.lookupClass((String)"jdk.internal.vm.vector.VectorSupport");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Field[] objectArray = clazz.getDeclaredFields();
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Field field = objectArray[i2];
                if (field.getType() != Integer.TYPE || !field.accessFlags().contains((Object)AccessFlag.STATIC) || !field.accessFlags().contains((Object)AccessFlag.FINAL) || !field.getName().startsWith("VECTOR_OP_")) continue;
                arrayList.add((Integer)ReflectionUtil.readStaticField((Class)clazz, (String)field.getName()));
            }
            int[] nArray = new int[arrayList.size()];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = (Integer)arrayList.get(n2);
            }
            this.qF = nArray;
            this.qG = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.LaneType");
            this.qH = new Object[qI.length];
            for (n2 = 0; n2 < this.qH.length; ++n2) {
                this.qH[n2] = ReflectionUtil.readStaticField(this.qG, (String)qI[n2]);
            }
        }
    }
}

