/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.graal;

import com.oracle.graal.duplication.phases.simulation.j;
import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import java.util.ArrayList;
import java.util.BitSet;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeFlood;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.loop.phases.SpeculativeGuardMovementPhase;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.AnchoringNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.OpaqueLogicNode;
import jdk.graal.compiler.nodes.loop.CountedLoopInfo;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.loop.LoopFragmentWhole;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.PostRunCanonicalizationPhase;
import jdk.graal.compiler.phases.common.util.OptimizationUtility;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import org.graalvm.collections.EconomicSet;

public class GuardHoistingLoopDuplicationPhase
extends PostRunCanonicalizationPhase<MidTierContext> {
    private final d gt;

    public GuardHoistingLoopDuplicationPhase(d d2, CanonicalizerPhase canonicalizerPhase) {
        super(canonicalizerPhase);
        this.gt = d2;
    }

    protected void a(StructuredGraph structuredGraph, MidTierContext midTierContext) {
        this.b(structuredGraph, midTierContext);
    }

    private void b(StructuredGraph structuredGraph, MidTierContext midTierContext) {
        if (!structuredGraph.hasLoops()) {
            return;
        }
        if (!this.gt.a(structuredGraph)) {
            return;
        }
        LoopsData loopsData = midTierContext.getLoopsDataProvider().getLoopsData(structuredGraph);
        loopsData.detectCountedLoops();
        ArrayList<b> arrayList = this.a(structuredGraph, loopsData);
        if (arrayList == null) {
            return;
        }
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after duplicating %d loops and floating guards", (Object)arrayList.size());
        loopsData = midTierContext.getLoopsDataProvider().getLoopsData(structuredGraph);
        loopsData.detectCountedLoops();
        boolean bl2 = true;
        boolean bl3 = false;
        SpeculativeGuardMovementPhase.performSpeculativeGuardMovement((MidTierContext)midTierContext, (StructuredGraph)structuredGraph, (LoopsData)loopsData, (boolean)true, (boolean)false);
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after base speculative guard movement");
        GuardHoistingLoopDuplicationPhase.a(structuredGraph, arrayList);
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after postprocessing duplicated loops");
    }

    private ArrayList<b> a(StructuredGraph structuredGraph, LoopsData loopsData) {
        ArrayList<b> arrayList = null;
        try (Indent indent = structuredGraph.getDebug().logAndIndent("Consider %s for duplication before speculative guard movement", (Object)structuredGraph.method().format("%h.%n"));){
            for (Loop loop : loopsData.countedLoops()) {
                FrameState frameState;
                InductionVariable inductionVariable;
                if (!this.gt.a(loop, structuredGraph, loopsData) || !(loop.counted().getCountedExit() instanceof LoopExitNode) || !(inductionVariable = loop.counted().getLimitCheckedIV()).isConstantStride() || NumUtil.absOverflows((long)inductionVariable.constantStride(), (ValueNode)inductionVariable.strideNode()) || !CodeUtil.isPowerOf2((long)NumUtil.safeAbs((long)inductionVariable.constantStride(), (ValueNode)inductionVariable.strideNode())) || (frameState = com.oracle.graal.duplication.util.d.e((FixedNode)loop.entryPoint())) == null) continue;
                structuredGraph.getDebug().dump(4, (Object)structuredGraph, "before duplicating %s", (Object)loop.loopBegin());
                loop.loopBegin().getDebug().log("Duplicating loop: %s", (Object)loop.loopBegin());
                LoopFragmentWhole loopFragmentWhole = loop.whole().duplicate();
                assert (loop.entryPoint().predecessor() instanceof FixedWithNextNode);
                FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)loop.entryPoint().predecessor();
                fixedWithNextNode.clearSuccessors();
                AbstractBeginNode abstractBeginNode = BeginNode.begin((FixedNode)loop.entryPoint());
                AbstractBeginNode abstractBeginNode2 = BeginNode.begin((FixedNode)loopFragmentWhole.entryPoint());
                LogicNode logicNode = (LogicNode)structuredGraph.addWithoutUnique((Node)new OpaqueLogicNode((LogicNode)LogicConstantNode.contradiction((Graph)structuredGraph)));
                IfNode ifNode = (IfNode)structuredGraph.add((Node)new IfNode(logicNode, abstractBeginNode, abstractBeginNode2, BranchProbabilityNode.ALWAYS_TAKEN_PROFILE));
                fixedWithNextNode.setNext((FixedNode)ifNode);
                b b2 = new b(ifNode, loop);
                structuredGraph.getDebug().dump(4, (Object)structuredGraph, "after duplicating %s", (Object)loop.loopBegin());
                HIRBlock hIRBlock = loopsData.getCFG().blockFor((Node)loop.counted().getBody());
                e e2 = new e(loop, b2.gz);
                j.a((ControlFlowGraph)loopsData.getCFG(), (ControlFlowGraph.RecursiveVisitor)e2, (HIRBlock)hIRBlock, (int)0, (int)loopsData.getCFG().getMaxDominatorDepth());
                CountedLoopInfo countedLoopInfo = loop.counted();
                if (!countedLoopInfo.counterNeverOverflows()) {
                    LogicNode logicNode2 = loop.counted().createOverflowGuardCondition();
                    GuardNode guardNode = (GuardNode)structuredGraph.addWithoutUnique((Node)new GuardNode(logicNode2, (AnchoringNode)AbstractBeginNode.prevBegin((FixedNode)loop.entryPoint()), DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.None, true, null, abstractBeginNode.getNodeSourcePosition()));
                    b2.gz.add(0, new a(guardNode, null, null));
                    loop.loopBegin().setOverflowGuard((GuardingNode)guardNode);
                    structuredGraph.getDebug().dump(5, (Object)structuredGraph, "After creating overflow guard %s", (Object)guardNode);
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<b>();
                }
                arrayList.add(b2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private static void a(StructuredGraph structuredGraph, ArrayList<b> arrayList) {
        structuredGraph.getDebug().log("Postprocess %d loop dispatch ifs", arrayList.size());
        for (b b2 : arrayList) {
            double d2;
            boolean bl2;
            IfNode ifNode = b2.gx;
            LogicNode logicNode = ifNode.condition();
            ArrayList<a> arrayList2 = b2.gz;
            if (arrayList2.size() == 0) {
                GraalError.shouldNotReachHere((String)"should only have duplicated this loop if we were going to float guards");
            }
            AbstractBeginNode abstractBeginNode = ifNode.trueSuccessor();
            AbstractBeginNode abstractBeginNode2 = ifNode.falseSuccessor();
            FrameState frameState = com.oracle.graal.duplication.util.d.e((FixedNode)ifNode);
            GraalError.guarantee((frameState != null ? 1 : 0) != 0, (String)"We checked for a valid state before building a descriptor, there should still be one");
            Loop loop = b2.gy;
            EconomicSet economicSet = EconomicSet.create();
            for (a a2 : arrayList2) {
                GuardNode guardNode = a2.gu;
                if (!loop.isOutsideLoop((Node)guardNode.getAnchor().asNode())) continue;
                economicSet.add((Object)guardNode);
            }
            double d3 = (double)economicSet.size() / (double)arrayList2.size();
            boolean bl3 = bl2 = d3 >= (d2 = ((Double)c.gG.getValue(structuredGraph.getOptions())).doubleValue());
            if (OptimizationUtility.hotGlobalSelfTime((StructuredGraph)structuredGraph) && economicSet.size() > 0) {
                bl2 = true;
            }
            structuredGraph.getDebug().log(4, "%s: hoisted %s of %s guards, minimal hoisting fraction %s, should duplicate? %s", (Object)ifNode, (Object)economicSet.size(), (Object)arrayList2.size(), (Object)d2, (Object)bl2);
            if (bl2) {
                void var18_21;
                FixedNode fixedNode = abstractBeginNode.next();
                abstractBeginNode.setNext(null);
                AbstractBeginNode abstractBeginNode3 = abstractBeginNode;
                var19_24 = (MergeNode)structuredGraph.add((Node)new MergeNode());
                ArrayList<IfNode> arrayList3 = new ArrayList<IfNode>();
                for (a a2 : arrayList2) {
                    LogicNode logicNode2;
                    GuardNode guardNode = a2.gu;
                    boolean bl4 = economicSet.contains((Object)guardNode);
                    structuredGraph.getDebug().dump(5, (Object)structuredGraph, "before un-floating %s guard %s", (Object)(bl4 ? "hoisted" : "non-hoisted"), (Object)guardNode);
                    if (bl4) {
                        logicNode2 = guardNode.getCondition();
                        if (guardNode.isNegated()) {
                            logicNode2 = (LogicNode)structuredGraph.addOrUniqueWithInputs((Node)LogicNegationNode.create((LogicNode)logicNode2));
                        }
                        BeginNode beginNode = (BeginNode)structuredGraph.add((Node)new BeginNode());
                        EndNode endNode = (EndNode)structuredGraph.add((Node)new EndNode());
                        var19_24.addForwardEnd(endNode);
                        AbstractBeginNode abstractBeginNode4 = (AbstractBeginNode)structuredGraph.add((Node)new BeginNode());
                        abstractBeginNode4.setNext((FixedNode)endNode);
                        IfNode ifNode2 = (IfNode)structuredGraph.add((Node)new IfNode(logicNode2, (AbstractBeginNode)beginNode, abstractBeginNode4, BranchProbabilityNode.FAST_PATH_PROFILE));
                        guardNode.replaceAtUsagesAndDelete((Node)beginNode);
                        arrayList3.add(ifNode2);
                        var18_21.setNext((FixedNode)ifNode2);
                        BeginNode beginNode2 = beginNode;
                        structuredGraph.getDebug().dump(5, (Object)structuredGraph, "after un-floating guard %s cond %s with new if %s", (Object)guardNode, (Object)logicNode2, (Object)ifNode2);
                        if (a2.gv == null) continue;
                        structuredGraph.removeSplitPropagate((ControlSplitNode)a2.gv, a2.gw);
                        structuredGraph.getDebug().dump(5, (Object)structuredGraph, "after removing original exception split %s, keeping %s", (Object)a2.gv, (Object)a2.gw);
                        continue;
                    }
                    logicNode2 = a2.gw;
                    guardNode.replaceAtUsagesAndDelete((Node)logicNode2);
                    structuredGraph.getDebug().dump(5, (Object)structuredGraph, "after deleting guard %s and rewiring back to %s", (Object)guardNode, (Object)logicNode2);
                }
                var18_21.setNext(fixedNode);
                ifNode.setFalseSuccessor(null);
                var19_24.setNext((FixedNode)abstractBeginNode2);
                structuredGraph.removeSplitPropagate((ControlSplitNode)ifNode, ifNode.trueSuccessor());
                MergeNode.removeMergeIfDegenerated((MergeNode)var19_24);
                if (var19_24.isAlive()) {
                    var19_24.setStateAfter(frameState);
                }
            } else {
                for (a a3 : arrayList2) {
                    var19_24 = a3.gu;
                    var19_24.replaceAtUsagesAndDelete((Node)var19_24.getAnchor().asNode());
                }
                structuredGraph.removeSplitPropagate((ControlSplitNode)ifNode, ifNode.falseSuccessor());
            }
            logicNode.safeDelete();
        }
    }

    protected /* synthetic */ void run(StructuredGraph structuredGraph, Object object) {
        this.a(structuredGraph, (MidTierContext)object);
    }

    public static class d {
        public boolean a(StructuredGraph structuredGraph) {
            return true;
        }

        public boolean a(Loop loop, StructuredGraph structuredGraph, LoopsData loopsData) {
            int n2;
            int n3;
            assert (loop.isCounted());
            DebugContext debugContext = structuredGraph.getDebug();
            if (!loop.getCFGLoop().getChildren().isEmpty()) {
                debugContext.log(4, "don't duplicate %s: not an innermost loop", (Object)loop.loopBegin());
                return false;
            }
            double d2 = loop.localLoopFrequency() - (double)(!loop.counted().isInverted() ? 1 : 0);
            if (SchedulePhase.Instance.compareRelativeFrequencies((double)d2, (double)(n3 = ((Integer)OptimizationUtility.chooseAdaptiveBudgetFactor((StructuredGraph)structuredGraph, c.gC, c.gD)).intValue())) < 0) {
                debugContext.log(4, "don't duplicate %s: body iterations %s below limit of %s", (Object)loop.loopBegin(), (Object)d2, (Object)n3);
                return false;
            }
            double d3 = loopsData.getCFG().blockFor((Node)loop.loopBegin()).getRelativeFrequency();
            if (SchedulePhase.Instance.compareRelativeFrequencies((double)d3, (double)1.0) < 0) {
                debugContext.log(4, "don't duplicate %s: relative frequency %f too low", (Object)loop.loopBegin(), (Object)d3);
                return false;
            }
            NodeIterable nodeIterable = loop.inside().nodes().filter(ThrowBytecodeExceptionNode.class);
            if (nodeIterable.isEmpty()) {
                return false;
            }
            boolean bl2 = false;
            for (ThrowBytecodeExceptionNode throwBytecodeExceptionNode : nodeIterable) {
                Node node = throwBytecodeExceptionNode.predecessor();
                if (!(node instanceof AbstractBeginNode) || !(((AbstractBeginNode)node).predecessor() instanceof IfNode)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                debugContext.log(4, "don't duplicate %s: all bytecode exception throws have an unsupported graph shape", (Object)loop.loopBegin());
                return false;
            }
            int n4 = com.oracle.graal.compiler.enterprise.loop.d.c((Loop)loop);
            int n5 = n4 - d.a(loop);
            if (n5 > (n2 = ((Integer)OptimizationUtility.chooseAdaptiveBudgetFactor((StructuredGraph)structuredGraph, c.gE, c.gF)).intValue())) {
                debugContext.log(4, "don't duplicate %s: estimated loop size %d above limit of %d (original loop size %d)", (Object)loop.loopBegin(), (Object)n5, (Object)n2, (Object)n4);
                return false;
            }
            return true;
        }

        private static int a(Loop loop) {
            NodeFlood nodeFlood = new NodeFlood((Graph)loop.loopBegin().graph());
            int n2 = 0;
            for (ThrowBytecodeExceptionNode throwBytecodeExceptionNode : loop.inside().nodes().filter(ThrowBytecodeExceptionNode.class)) {
                n2 += throwBytecodeExceptionNode.estimatedNodeSize().value;
                nodeFlood.addAll((Iterable)throwBytecodeExceptionNode.inputs());
                Node node = throwBytecodeExceptionNode.predecessor();
                while (node instanceof BeginNode) {
                    node = ((BeginNode)node).predecessor();
                }
                if (!(node instanceof IfNode)) continue;
                IfNode ifNode = (IfNode)node;
                n2 += ifNode.estimatedNodeSize().value;
                nodeFlood.add((Node)ifNode.condition());
            }
            for (ThrowBytecodeExceptionNode throwBytecodeExceptionNode : nodeFlood) {
                if (!throwBytecodeExceptionNode.hasExactlyOneUsage() || loop.isOutsideLoop((Node)throwBytecodeExceptionNode)) continue;
                n2 += throwBytecodeExceptionNode.estimatedNodeSize().value;
                nodeFlood.addAll((Iterable)throwBytecodeExceptionNode.inputs());
            }
            return n2;
        }
    }

    private static class b {
        final IfNode gx;
        final Loop gy;
        final ArrayList<a> gz;

        b(IfNode ifNode, Loop loop) {
            this.gx = ifNode;
            this.gy = loop;
            this.gz = new ArrayList();
        }
    }

    public static class e
    implements ControlFlowGraph.RecursiveVisitor<Object> {
        private final ArrayList<a> gH;
        private final BitSet gI;
        private final StructuredGraph gJ;

        public e(Loop loop, ArrayList<a> arrayList) {
            this.gH = arrayList;
            this.gI = new BitSet(loop.loopsData().getCFG().getBlocks().length);
            for (HIRBlock hIRBlock : loop.getCFGLoop().getBlocks()) {
                this.gI.set(hIRBlock.getId());
            }
            this.gJ = loop.loopBegin().graph();
        }

        public Object enter(HIRBlock hIRBlock) {
            if (!this.gI.get(hIRBlock.getId())) {
                return null;
            }
            if (!(hIRBlock.getEndNode() instanceof IfNode)) {
                return null;
            }
            IfNode ifNode = (IfNode)hIRBlock.getEndNode();
            AbstractBeginNode abstractBeginNode = null;
            AbstractBeginNode abstractBeginNode2 = null;
            if (ifNode.trueSuccessor().next() instanceof ThrowBytecodeExceptionNode) {
                abstractBeginNode = ifNode.trueSuccessor();
                abstractBeginNode2 = ifNode.falseSuccessor();
            } else if (ifNode.falseSuccessor().next() instanceof ThrowBytecodeExceptionNode) {
                abstractBeginNode = ifNode.falseSuccessor();
                abstractBeginNode2 = ifNode.trueSuccessor();
            } else {
                return null;
            }
            IfNode ifNode2 = (IfNode)abstractBeginNode.predecessor();
            this.gJ.getDebug().dump(5, (Object)this.gJ, "before floating %s", (Object)ifNode2);
            boolean bl2 = abstractBeginNode == ifNode2.trueSuccessor();
            GuardNode guardNode = (GuardNode)this.gJ.addWithoutUnique((Node)new GuardNode(ifNode2.condition(), null, DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.None, bl2, null, abstractBeginNode2.getNodeSourcePosition()));
            abstractBeginNode2.replaceAtUsages((Node)guardNode, InputType.Guard);
            guardNode.setAnchor((AnchoringNode)abstractBeginNode2);
            this.gJ.getDebug().dump(5, (Object)this.gJ, "after floating %s as %s", (Object)ifNode2, (Object)guardNode);
            this.gH.add(new a(guardNode, ifNode2, abstractBeginNode2));
            return null;
        }

        public void exit(HIRBlock hIRBlock, Object object) {
        }
    }

    private static class a {
        final GuardNode gu;
        final IfNode gv;
        final AbstractBeginNode gw;

        a(GuardNode guardNode, IfNode ifNode, AbstractBeginNode abstractBeginNode) {
            this.gu = guardNode;
            this.gv = ifNode;
            this.gw = abstractBeginNode;
        }
    }

    public static class c {
        public static final OptionKey<Boolean> gA = new OptionKey((Object)true);
        public static final OptionKey<Long> gB = new OptionKey((Object)1L);
        public static final OptionKey<Integer> gC = new OptionKey((Object)4);
        public static final OptionKey<Integer> gD = new OptionKey((Object)0);
        public static final OptionKey<Integer> gE = new OptionKey((Object)64);
        public static final OptionKey<Integer> gF = new OptionKey((Object)2048);
        public static final OptionKey<Double> gG = new OptionKey((Object)0.5);
    }
}

