/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.buildreport;

import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.h;
import com.oracle.svm.enterprise.sbom.s;
import com.oracle.svm.hosted.EmbeddedResourceExporter;
import com.oracle.svm.hosted.HeapBreakdownProvider;
import com.oracle.svm.hosted.Log4ShellFeature;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.code.SourceMapping;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class a {
    private final List<f> a = new ArrayList<f>();

    public a() {
        this.a.add(new d());
        this.a.add(new a());
        this.a.add(new i());
        this.a.add(new e());
        this.a.add(new c());
    }

    public void a(Collection<HostedMethod> collection, Map<HostedMethod, CompileQueue.CompileTask> map) {
        this.a.add(new b(collection, map));
    }

    public void a(s s2, List<String> list) {
        this.a.add(new g(s2, list));
    }

    public void a(com.oracle.svm.enterprise.hosted.cai.e e2, String string) {
        try {
            this.a.add(new h(e2, string));
        }
        catch (IOException iOException) {
            throw VMError.shouldNotReachHere((String)"Failed to generate the sampler flame graph for Build Report", (Throwable)iOException);
        }
    }

    public String b() throws IOException {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("var data = ");
        this.a(new JsonWriter((Writer)stringWriter));
        stringWriter.append(";");
        return stringWriter.toString();
    }

    private void a(JsonWriter jsonWriter) throws IOException {
        jsonWriter.appendObjectStart();
        for (f f2 : this.a) {
            f2.a(jsonWriter);
            if (f2.equals(this.a.getLast())) continue;
            jsonWriter.appendSeparator();
        }
        jsonWriter.appendObjectEnd();
        jsonWriter.flush();
    }

    private static class d
    implements f {
        private d() {
        }

        private static String i() {
            return (String)SubstrateOptions.Name.getValue();
        }

        private static String j() {
            return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date());
        }

        @Override
        public void a(JsonWriter jsonWriter) throws IOException {
            jsonWriter.appendKeyValue("name", (Object)d.i()).appendSeparator();
            jsonWriter.appendKeyValue("datetime", (Object)d.j());
        }
    }

    private static class a
    implements f {
        private a() {
        }

        @Override
        public void a(JsonWriter jsonWriter) throws IOException {
            jsonWriter.quote("buildOutput").appendFieldSeparator();
            ProgressReporter.singleton().jsonHelper.print(jsonWriter);
        }
    }

    private static final class i
    implements f {
        private i() {
        }

        private static boolean r() {
            return com.oracle.svm.enterprise.hosted.h.r();
        }

        private static h.b s() {
            return ImageSingletons.contains(h.b.class) ? (h.b)ImageSingletons.lookup(h.b.class) : null;
        }

        private static boolean t() {
            return SubstrateControlFlowIntegrity.enabled();
        }

        private static String u() {
            return ImageSingletons.contains(Log4ShellFeature.class) ? ((Log4ShellFeature)ImageSingletons.lookup(Log4ShellFeature.class)).getUserWarning() : null;
        }

        @Override
        public void a(JsonWriter jsonWriter) throws IOException {
            jsonWriter.quote("securityReport").appendFieldSeparator();
            try (JsonBuilder.ObjectBuilder objectBuilder = jsonWriter.objectBuilder();){
                objectBuilder.append("deserialization", (Object)i.r());
                h.b b2 = i.s();
                if (b2 != null) {
                    try (JsonBuilder.ObjectBuilder objectBuilder2 = objectBuilder.append("sbomInformation").object();){
                        objectBuilder2.append("sbomReadableFormat", (Object)b2.eg());
                        objectBuilder2.append("numberOfComponents", (Object)b2.ef());
                        objectBuilder2.append("isExported", (Object)b2.ej());
                        if (b2.eh() != null) {
                            objectBuilder2.append("embeddedByteSize", (Object)b2.eh());
                        }
                        if (b2.ei() != null) {
                            objectBuilder2.append("targetClassPath", (Object)b2.ei());
                        }
                        objectBuilder2.append("isClassLevelEnabled", (Object)b2.ek());
                        if (!b2.n().isEmpty()) {
                            objectBuilder2.append("numberOfMissingTypes", (Object)b2.n().size());
                        }
                    }
                }
                objectBuilder.append("controlFlowIntegrity", (Object)i.t());
                objectBuilder.append("log4Warning", (Object)i.u());
            }
        }
    }

    public static class e
    implements f {
        protected static long k() {
            return HeapBreakdownProvider.singleton().getTotalHeapSize();
        }

        protected static List<HeapBreakdownProvider.HeapBreakdownEntry> l() {
            return HeapBreakdownProvider.singleton().getSortedBreakdownEntries();
        }

        @Override
        public void a(JsonWriter jsonWriter) throws IOException {
            jsonWriter.quote("heap").appendFieldSeparator();
            try (JsonBuilder.ObjectBuilder objectBuilder = jsonWriter.objectBuilder();){
                objectBuilder.append("total", (Object)e.k());
                try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append("items").array();){
                    a a2 = new a();
                    for (HeapBreakdownProvider.HeapBreakdownEntry heapBreakdownEntry : e.l()) {
                        JsonBuilder.ObjectBuilder objectBuilder2 = arrayBuilder.nextEntry().object();
                        try {
                            objectBuilder2.append("name", (Object)heapBreakdownEntry.getLabel().renderToString((ProgressReporter.LinkStrategy)a2));
                            objectBuilder2.append("count", (Object)heapBreakdownEntry.getCount());
                            objectBuilder2.append("size", (Object)heapBreakdownEntry.getByteSize());
                        }
                        finally {
                            if (objectBuilder2 == null) continue;
                            objectBuilder2.close();
                        }
                    }
                }
            }
        }

        private static final class a
        implements ProgressReporter.LinkStrategy {
            static final String p = "<a href=\"%s\" target=\"_blank\">%s</a>";

            private a() {
            }

            public void link(ProgressReporter.AbstractPrinter<?> abstractPrinter, String string, String string2) {
                abstractPrinter.a("<a href=\"" + string2 + "\" target=\"_blank\">").a(string).a("</a>");
            }

            public String asDocLink(String string, String string2) {
                return String.format(p, "https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/BuildOutput.md" + string2, string);
            }
        }
    }

    public static class c
    implements f {
        @Override
        public void a(JsonWriter jsonWriter) throws IOException {
            jsonWriter.quote("embeddedResources").appendFieldSeparator();
            EmbeddedResourceExporter.printReport((JsonWriter)jsonWriter);
        }
    }

    private static class b
    implements f {
        private static final String b = "bSize";
        private static final String c = "cSize";
        private static final String d = "rSize";
        private static final String e = "iSize";
        private static final String f = "uSize";
        private static final String g = "iCount";
        private final Set<HostedMethod> h;
        private final Map<HostedMethod, Integer> j;
        private final Map<HostedMethod, a> k;

        b(Collection<HostedMethod> collection, Map<HostedMethod, CompileQueue.CompileTask> map) {
            this.h = collection.stream().filter(hostedMethod -> hostedMethod.getWrapped().isReachable()).collect(Collectors.toSet());
            this.h.addAll(map.keySet());
            this.j = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((CompileQueue.CompileTask)entry.getValue()).result.getTargetCodeSize()));
            if (com.oracle.svm.enterprise.buildreport.b.w()) {
                this.k = new HashMap<HostedMethod, a>();
                this.a(map);
            } else {
                this.k = null;
            }
        }

        private void a(Map<HostedMethod, CompileQueue.CompileTask> map) {
            map.forEach((hostedMethod2, compileTask) -> {
                CompilationResult compilationResult = compileTask.result;
                int n2 = 0;
                HashSet<HostedMethod> hashSet = new HashSet<HostedMethod>();
                for (SourceMapping sourceMapping : compilationResult.getSourceMappings()) {
                    HostedMethod hostedMethod3 = (HostedMethod)sourceMapping.getSourcePosition().getMethod();
                    this.h.add(hostedMethod3);
                    a a2 = this.k.computeIfAbsent(hostedMethod3, hostedMethod -> new a());
                    int n3 = sourceMapping.getEndOffset() - sourceMapping.getStartOffset();
                    if (sourceMapping.getSourcePosition().getCaller() == null) {
                        a2.a(n3);
                    } else {
                        a2.b(n3);
                        hashSet.add(hostedMethod3);
                    }
                    n2 += n3;
                }
                this.k.computeIfAbsent((HostedMethod)hostedMethod2, hostedMethod -> new a()).c(compilationResult.getTargetCodeSize() - n2);
                for (HostedMethod hostedMethod4 : hashSet) {
                    this.k.get(hostedMethod4).h();
                }
            });
        }

        private boolean c() {
            return this.k != null;
        }

        @Override
        public void a(JsonWriter jsonWriter) throws IOException {
            jsonWriter.quote("code").appendFieldSeparator();
            try (JsonBuilder.ObjectBuilder objectBuilder = jsonWriter.objectBuilder();){
                Object object;
                HostedType hostedType;
                try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append("types").array();){
                    Set set = this.h.stream().map(HostedMethod::getDeclaringClass).collect(Collectors.toSet());
                    HostedMethod hostedMethod = set.iterator();
                    while (hostedMethod.hasNext()) {
                        hostedType = (HostedType)hostedMethod.next();
                        object = arrayBuilder.nextEntry().object();
                        try {
                            object.append("id", (Object)hostedType.getWrapped().getId());
                            object.append("name", (Object)hostedType.toJavaName());
                        }
                        finally {
                            if (object == null) continue;
                            object.close();
                        }
                    }
                }
                arrayBuilder = objectBuilder.append("methods").array();
                try {
                    for (HostedMethod hostedMethod : this.h) {
                        hostedType = arrayBuilder.nextEntry().object();
                        try {
                            hostedType.append("name", (Object)hostedMethod.format("%n(%p): %r"));
                            hostedType.append("declaringClass", (Object)hostedMethod.getDeclaringClass().getWrapped().getId());
                            if (hostedMethod.isOriginalMethod()) {
                                hostedType.append(b, (Object)hostedMethod.getCodeSize());
                            }
                            if (this.j.containsKey(hostedMethod)) {
                                hostedType.append(c, (Object)this.j.get(hostedMethod));
                            }
                            if (!this.c() || !this.k.containsKey(hostedMethod)) continue;
                            object = this.k.get(hostedMethod);
                            if (((a)object).f() > 0) {
                                hostedType.append(d, (Object)((a)object).d());
                            }
                            if (((a)object).e() > 0) {
                                hostedType.append(e, (Object)((a)object).e());
                            }
                            if (((a)object).f() > 0) {
                                hostedType.append(f, (Object)((a)object).f());
                            }
                            if (((a)object).g() <= 0) continue;
                            hostedType.append(g, (Object)((a)object).g());
                        }
                        finally {
                            if (hostedType == null) continue;
                            hostedType.close();
                        }
                    }
                }
                finally {
                    if (arrayBuilder != null) {
                        arrayBuilder.close();
                    }
                }
                objectBuilder.append("mappedSizeIncluded", (Object)this.c());
            }
        }

        private static final class a {
            private int l = 0;
            private int m = 0;
            private int n = 0;
            private int o = 0;

            private a() {
            }

            public int d() {
                return this.l;
            }

            public int e() {
                return this.m;
            }

            public int f() {
                return this.n;
            }

            public int g() {
                return this.o;
            }

            public void a(int n2) {
                this.l += n2;
            }

            public void b(int n2) {
                this.m += n2;
            }

            public void c(int n2) {
                this.n = n2;
            }

            public void h() {
                ++this.o;
            }
        }
    }

    private static final class g
    extends Record
    implements f {
        private final s q;
        private final List<String> r;

        private g(s s2, List<String> list) {
            this.q = s2;
            this.r = list;
        }

        @Override
        public void a(JsonWriter jsonWriter) throws IOException {
            jsonWriter.quote("sbom").appendFieldSeparator();
            try (JsonBuilder.ObjectBuilder objectBuilder = jsonWriter.objectBuilder();){
                jsonWriter.quote("data").appendFieldSeparator().append(this.q.kj()).appendSeparator();
                try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append("missingTypes").array();){
                    for (String string : this.r) {
                        arrayBuilder.append((Object)string);
                    }
                }
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{g.class, "sbom;missingTypes", "q", "r"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{g.class, "sbom;missingTypes", "q", "r"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{g.class, "sbom;missingTypes", "q", "r"}, this, object);
        }

        public s m() {
            return this.q;
        }

        public List<String> n() {
            return this.r;
        }
    }

    private static class h
    implements f {
        private final String s;

        h(com.oracle.svm.enterprise.hosted.cai.e e2, String string) throws IOException {
            this.s = com.oracle.svm.enterprise.buildreport.flamegraph.a.b(e2, string);
        }

        @Override
        public void a(JsonWriter jsonWriter) throws IOException {
            jsonWriter.appendKeyValue("samplerOutput", (Object)Base64.getEncoder().encodeToString(this.s.getBytes()));
        }
    }

    private static interface f {
        public void a(JsonWriter var1) throws IOException;
    }
}

