/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.PublishWritesNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.replacements.nodes.ReadRegisterNode;
import jdk.graal.compiler.replacements.nodes.WriteRegisterNode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;

class ForeignGraphKit
extends HostedGraphKit {
    ForeignGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method, GraphProvider.Purpose purpose) {
        super(debug, providers, method);
    }

    Pair<List<ValueNode>, ValueNode> unpackArgumentsAndExtractNEP(ValueNode argumentsArray, MethodType methodType) {
        List args = this.loadArrayElements(argumentsArray, JavaKind.Object, methodType.parameterCount() + 1);
        ValueNode nep = (ValueNode)args.remove(args.size() - 1);
        return Pair.create((Object)args, (Object)nep);
    }

    public ValueNode packArguments(List<ValueNode> arguments) {
        AnalysisMetaAccess metaAccess = this.getMetaAccess();
        ValueNode argumentArray = (ValueNode)this.append((Node)new NewArrayNode(metaAccess.lookupJavaType(Object.class), (ValueNode)ConstantNode.forInt((int)arguments.size(), (StructuredGraph)this.getGraph()), false));
        for (int i = 0; i < arguments.size(); ++i) {
            ValueNode argument = arguments.get(i);
            assert (argument.getStackKind().equals((Object)JavaKind.Object));
            this.createStoreIndexed(argumentArray, i, JavaKind.Object, argument);
        }
        return (ValueNode)this.append((Node)new PublishWritesNode(argumentArray));
    }

    List<ValueNode> unboxArguments(List<ValueNode> args, MethodType methodType) {
        assert (args.size() == methodType.parameterCount()) : args.size() + " " + methodType.parameterCount();
        ArrayList<ValueNode> newArgs = new ArrayList<ValueNode>(args);
        for (int i = 0; i < newArgs.size(); ++i) {
            ValueNode argument = newArgs.get(i);
            JavaKind targetKind = JavaKind.fromJavaClass((Class)methodType.parameterType(i));
            if (!targetKind.isPrimitive()) continue;
            newArgs.set(i, this.createUnboxing(argument, targetKind));
        }
        return newArgs;
    }

    public List<ValueNode> boxArguments(List<ValueNode> args, MethodType methodType) {
        assert (args.size() == methodType.parameterCount()) : args.size() + " " + methodType.parameterCount();
        ArrayList<ValueNode> newArgs = new ArrayList<ValueNode>(args);
        for (int i = 0; i < newArgs.size(); ++i) {
            ValueNode argument = newArgs.get(i);
            JavaKind kind = JavaKind.fromJavaClass((Class)methodType.parameterType(i));
            AnalysisType boxed = this.getMetaAccess().lookupJavaType(kind.toBoxedJavaClass());
            argument = this.createBoxing(argument, kind, (ResolvedJavaType)boxed);
            newArgs.set(i, argument);
        }
        return newArgs;
    }

    public ValueNode boxAndReturn(ValueNode returnValue, MethodType methodType) {
        JavaKind returnKind = JavaKind.fromJavaClass((Class)methodType.returnType());
        if (returnKind.equals((Object)JavaKind.Void)) {
            return this.createReturn((ValueNode)this.createObject(null), JavaKind.Object);
        }
        AnalysisType boxed = this.getMetaAccess().lookupJavaType(returnKind.toBoxedJavaClass());
        return this.createReturn(this.createBoxing(returnValue, returnKind, (ResolvedJavaType)boxed), JavaKind.Object);
    }

    public ValueNode unbox(ValueNode returnValue, MethodType methodType) {
        JavaKind returnKind = JavaKind.fromJavaClass((Class)methodType.returnType());
        if (returnKind.equals((Object)JavaKind.Void)) {
            return returnValue;
        }
        return this.createUnboxing(returnValue, returnKind);
    }

    public ValueNode createReturn(ValueNode returnValue, MethodType methodType) {
        JavaKind returnKind = JavaKind.fromJavaClass((Class)methodType.returnType());
        return this.createReturn(returnValue, returnKind);
    }

    public ValueNode bindRegister(Register register, JavaKind kind) {
        return (ValueNode)this.append((Node)new ReadRegisterNode(register, kind, false, false));
    }

    public Map<Register, ValueNode> saveRegisters(Iterable<Register> registers) {
        return StreamSupport.stream(registers.spliterator(), false).collect(Collectors.toMap(reg -> reg, register -> this.bindRegister((Register)register, this.getWordTypes().getWordKind())));
    }

    public void restoreRegisters(Map<Register, ValueNode> save) {
        save.forEach((register, value) -> this.append((Node)new WriteRegisterNode(register, value)));
    }
}

