/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.ArrayTypeEntry;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.HeaderTypeEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.PrimitiveTypeEntry;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debugentry.range.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.ELFMachine;
import com.oracle.objectfile.elf.ELFObjectFile;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.constants.DwarfExpressionOpcode;
import com.oracle.objectfile.elf.dwarf.constants.DwarfFlag;
import com.oracle.objectfile.elf.dwarf.constants.DwarfLocationListEntry;
import com.oracle.objectfile.elf.dwarf.constants.DwarfRangeListEntry;
import com.oracle.objectfile.elf.dwarf.constants.DwarfSectionName;
import com.oracle.objectfile.elf.dwarf.constants.DwarfTag;
import com.oracle.objectfile.elf.dwarf.constants.DwarfUnitHeader;
import com.oracle.objectfile.elf.dwarf.constants.DwarfVersion;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import jdk.graal.compiler.debug.DebugContext;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class DwarfSectionImpl
extends BasicProgbitsSectionImpl {
    protected final DwarfDebugInfo dwarfSections;
    protected boolean debug = false;
    protected long debugTextBase = 0L;
    protected long debugAddress = 0L;
    protected int debugBase = 0;
    private final DwarfSectionName sectionName;
    private final DwarfSectionName targetSectionName;
    private final LayoutDecision.Kind[] targetSectionKinds;
    private static final LayoutDecision.Kind[] defaultTargetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};
    protected static final byte[] scratch = new byte[10];

    public DwarfSectionImpl(DwarfDebugInfo dwarfSections, DwarfSectionName name, DwarfSectionName targetName) {
        this(dwarfSections, name, targetName, defaultTargetSectionKinds);
    }

    public DwarfSectionImpl(DwarfDebugInfo dwarfSections, DwarfSectionName sectionName, DwarfSectionName targetSectionName, LayoutDecision.Kind[] targetKinds) {
        this.dwarfSections = dwarfSections;
        this.sectionName = sectionName;
        this.targetSectionName = targetSectionName;
        this.targetSectionKinds = targetKinds;
    }

    public boolean isAArch64() {
        return this.dwarfSections.elfMachine == ELFMachine.AArch64;
    }

    public abstract void createContent();

    public abstract void writeContent(DebugContext var1);

    public boolean contentByteArrayCreated() {
        return this.getContent() != null;
    }

    @Override
    public boolean isLoadable() {
        return false;
    }

    private String debugSectionLogName() {
        assert (this.getSectionName().startsWith(".debug"));
        return "dwarf" + this.getSectionName();
    }

    protected void enableLog(DebugContext context, int pos) {
        assert (this.contentByteArrayCreated());
        if (context.areScopesEnabled()) {
            this.debug = true;
            this.debugBase = pos;
            this.debugAddress = this.debugTextBase;
        }
    }

    protected void log(DebugContext context, String format, Object ... args) {
        if (this.debug) {
            context.logv(2, format, args);
        }
    }

    protected void verboseLog(DebugContext context, String format, Object ... args) {
        if (this.debug) {
            context.logv(3, format, args);
        }
    }

    protected boolean littleEndian() {
        return this.dwarfSections.getByteOrder() == ByteOrder.LITTLE_ENDIAN;
    }

    protected int putByte(byte b, byte[] buffer, int p) {
        int pos = p;
        buffer[pos++] = b;
        return pos;
    }

    protected int putShort(short s, byte[] buffer, int p) {
        int pos = p;
        if (this.littleEndian()) {
            buffer[pos++] = (byte)(s & 0xFF);
            buffer[pos++] = (byte)(s >> 8 & 0xFF);
        } else {
            buffer[pos++] = (byte)(s >> 8 & 0xFF);
            buffer[pos++] = (byte)(s & 0xFF);
        }
        return pos;
    }

    protected int putInt(int i, byte[] buffer, int p) {
        int pos = p;
        if (this.littleEndian()) {
            buffer[pos++] = (byte)(i & 0xFF);
            buffer[pos++] = (byte)(i >> 8 & 0xFF);
            buffer[pos++] = (byte)(i >> 16 & 0xFF);
            buffer[pos++] = (byte)(i >> 24 & 0xFF);
        } else {
            buffer[pos++] = (byte)(i >> 24 & 0xFF);
            buffer[pos++] = (byte)(i >> 16 & 0xFF);
            buffer[pos++] = (byte)(i >> 8 & 0xFF);
            buffer[pos++] = (byte)(i & 0xFF);
        }
        return pos;
    }

    protected int putLong(long l, byte[] buffer, int p) {
        int pos = p;
        if (this.littleEndian()) {
            buffer[pos++] = (byte)(l & 0xFFL);
            buffer[pos++] = (byte)(l >> 8 & 0xFFL);
            buffer[pos++] = (byte)(l >> 16 & 0xFFL);
            buffer[pos++] = (byte)(l >> 24 & 0xFFL);
            buffer[pos++] = (byte)(l >> 32 & 0xFFL);
            buffer[pos++] = (byte)(l >> 40 & 0xFFL);
            buffer[pos++] = (byte)(l >> 48 & 0xFFL);
            buffer[pos++] = (byte)(l >> 56 & 0xFFL);
        } else {
            buffer[pos++] = (byte)(l >> 56 & 0xFFL);
            buffer[pos++] = (byte)(l >> 48 & 0xFFL);
            buffer[pos++] = (byte)(l >> 40 & 0xFFL);
            buffer[pos++] = (byte)(l >> 32 & 0xFFL);
            buffer[pos++] = (byte)(l >> 16 & 0xFFL);
            buffer[pos++] = (byte)(l >> 24 & 0xFFL);
            buffer[pos++] = (byte)(l >> 8 & 0xFFL);
            buffer[pos++] = (byte)(l & 0xFFL);
        }
        return pos;
    }

    protected int putRelocatableCodeOffset(long l, byte[] buffer, int p) {
        int pos = p;
        this.markRelocationSite(pos, ObjectFile.RelocationKind.DIRECT_8, DwarfSectionName.TEXT_SECTION.value(), l);
        pos = this.writeLong(0L, buffer, pos);
        return pos;
    }

    protected int putRelocatableHeapOffset(long l, byte[] buffer, int p) {
        int pos = p;
        this.markRelocationSite(pos, ObjectFile.RelocationKind.DIRECT_8, "__svm_heap_begin", l);
        pos = this.writeLong(0L, buffer, pos);
        return pos;
    }

    protected int putRelocatableDwarfSectionOffset(int offset, byte[] buffer, String referencedSectionName, int p) {
        int pos = p;
        this.markRelocationSite(pos, ObjectFile.RelocationKind.DIRECT_4, referencedSectionName, offset);
        pos = this.writeInt(0, buffer, pos);
        return pos;
    }

    protected int putULEB(long val, byte[] buffer, int p) {
        int pos = p;
        long l = val;
        for (int i = 0; i < 9; ++i) {
            boolean done;
            byte b = (byte)(l & 0x7FL);
            boolean bl = done = (l >>>= 7) == 0L;
            if (!done) {
                b = (byte)(b | 0x80);
            }
            pos = this.writeByte(b, buffer, pos);
            if (done) break;
        }
        return pos;
    }

    protected int putSLEB(long val, byte[] buffer, int p) {
        int pos = p;
        long l = val;
        for (int i = 0; i < 9; ++i) {
            boolean done;
            byte b = (byte)(l & 0x7FL);
            boolean bIsSigned = (b & 0x40) != 0;
            boolean bl = done = bIsSigned && (l >>= 7) == -1L || !bIsSigned && l == 0L;
            if (!done) {
                b = (byte)(b | 0x80);
            }
            pos = this.writeByte(b, buffer, pos);
            if (done) break;
        }
        return pos;
    }

    protected static int countUTF8Bytes(String s) {
        return DwarfSectionImpl.countUTF8Bytes(s, 0);
    }

    protected static int countUTF8Bytes(String s, int startChar) {
        byte[] bytes = s.substring(startChar).getBytes(StandardCharsets.UTF_8);
        return bytes.length;
    }

    protected int putUTF8StringBytes(String s, int startChar, byte[] buffer, int p) {
        int pos = p;
        byte[] bytes = s.substring(startChar).getBytes(StandardCharsets.UTF_8);
        System.arraycopy(bytes, 0, buffer, pos, bytes.length);
        pos += bytes.length;
        buffer[pos++] = 0;
        return pos;
    }

    protected int writeByte(byte b, byte[] buffer, int p) {
        if (buffer != null) {
            return this.putByte(b, buffer, p);
        }
        return p + 1;
    }

    protected int writeShort(short s, byte[] buffer, int p) {
        if (buffer != null) {
            return this.putShort(s, buffer, p);
        }
        return p + 2;
    }

    protected int writeInt(int i, byte[] buffer, int p) {
        if (buffer != null) {
            return this.putInt(i, buffer, p);
        }
        return p + 4;
    }

    protected int writeLong(long l, byte[] buffer, int p) {
        if (buffer != null) {
            return this.putLong(l, buffer, p);
        }
        return p + 8;
    }

    protected int writeRelocatableCodeOffset(long l, byte[] buffer, int p) {
        if (buffer != null) {
            return this.putRelocatableCodeOffset(l, buffer, p);
        }
        return p + 8;
    }

    protected int writeRelocatableHeapOffset(long l, byte[] buffer, int p) {
        if (buffer != null) {
            return this.putRelocatableHeapOffset(l, buffer, p);
        }
        return p + 8;
    }

    protected int writeULEB(long val, byte[] buffer, int p) {
        if (buffer != null) {
            return this.putULEB(val, buffer, p);
        }
        return p + this.putULEB(val, scratch, 0);
    }

    protected int writeSLEB(long val, byte[] buffer, int p) {
        if (buffer != null) {
            return this.putSLEB(val, buffer, p);
        }
        return p + this.putSLEB(val, scratch, 0);
    }

    protected int writeUTF8StringBytes(String s, byte[] buffer, int pos) {
        return this.writeUTF8StringBytes(s, 0, buffer, pos);
    }

    protected int writeUTF8StringBytes(String s, int startChar, byte[] buffer, int p) {
        if (buffer != null) {
            return this.putUTF8StringBytes(s, startChar, buffer, p);
        }
        return s.substring(startChar).getBytes(StandardCharsets.UTF_8).length;
    }

    protected int writeExprOpcode(DwarfExpressionOpcode opcode, byte[] buffer, int p) {
        return this.writeByte(opcode.value(), buffer, p);
    }

    protected int writeExprOpcodeLiteral(int offset, byte[] buffer, int p) {
        byte value = DwarfExpressionOpcode.DW_OP_lit0.value();
        assert (offset >= 0 && offset < 32);
        value = (byte)(value + offset);
        return this.writeByte(value, buffer, p);
    }

    protected int writeExprOpcodeReg(byte reg, byte[] buffer, int p) {
        byte value = DwarfExpressionOpcode.DW_OP_reg0.value();
        assert (reg >= 0 && reg < 32);
        value = (byte)(value + reg);
        return this.writeByte(value, buffer, p);
    }

    protected int writeExprOpcodeBReg(byte reg, byte[] buffer, int p) {
        byte value = DwarfExpressionOpcode.DW_OP_breg0.value();
        assert (reg >= 0 && reg < 32);
        value = (byte)(value + reg);
        return this.writeByte(value, buffer, p);
    }

    protected void patchLength(int lengthPos, byte[] buffer, int pos) {
        int length = pos - (lengthPos + 4);
        this.writeInt(length, buffer, lengthPos);
    }

    protected int writeAbbrevCode(DwarfDebugInfo.AbbrevCode code, byte[] buffer, int pos) {
        return this.writeSLEB(code.ordinal(), buffer, pos);
    }

    protected int writeRangeListEntry(DwarfRangeListEntry rangeListEntry, byte[] buffer, int pos) {
        return this.writeByte(rangeListEntry.value(), buffer, pos);
    }

    protected int writeLocationListEntry(DwarfLocationListEntry locationListEntry, byte[] buffer, int pos) {
        return this.writeByte(locationListEntry.value(), buffer, pos);
    }

    protected int writeTag(DwarfTag dwarfTag, byte[] buffer, int pos) {
        int code = dwarfTag.value();
        if (code == 0) {
            return this.writeByte((byte)0, buffer, pos);
        }
        return this.writeSLEB(code, buffer, pos);
    }

    protected int writeDwarfVersion(DwarfVersion dwarfVersion, byte[] buffer, int pos) {
        return this.writeShort(dwarfVersion.value(), buffer, pos);
    }

    protected int writeDwarfUnitHeader(DwarfUnitHeader dwarfUnitHeader, byte[] buffer, int pos) {
        return this.writeByte(dwarfUnitHeader.value(), buffer, pos);
    }

    protected int writeTypeSignature(long typeSignature, byte[] buffer, int pos) {
        return this.writeLong(typeSignature, buffer, pos);
    }

    protected int writeFlag(DwarfFlag flag, byte[] buffer, int pos) {
        return this.writeByte(flag.value(), buffer, pos);
    }

    protected int writeAttrAddress(long address, byte[] buffer, int pos) {
        return this.writeRelocatableCodeOffset(address, buffer, pos);
    }

    protected int writeAttrData8(long value, byte[] buffer, int pos) {
        return this.writeLong(value, buffer, pos);
    }

    protected int writeAttrData4(int value, byte[] buffer, int pos) {
        return this.writeInt(value, buffer, pos);
    }

    protected int writeAttrData2(short value, byte[] buffer, int pos) {
        return this.writeShort(value, buffer, pos);
    }

    protected int writeAttrData1(byte value, byte[] buffer, int pos) {
        return this.writeByte(value, buffer, pos);
    }

    protected int writeInfoSectionOffset(int offset, byte[] buffer, int pos) {
        return this.writeDwarfSectionOffset(offset, buffer, DwarfSectionName.DW_INFO_SECTION, pos);
    }

    protected int writeLineSectionOffset(int offset, byte[] buffer, int pos) {
        return this.writeDwarfSectionOffset(offset, buffer, DwarfSectionName.DW_LINE_SECTION, pos);
    }

    protected int writeRangeListsSectionOffset(int offset, byte[] buffer, int pos) {
        return this.writeDwarfSectionOffset(offset, buffer, DwarfSectionName.DW_RNGLISTS_SECTION, pos);
    }

    protected int writeAbbrevSectionOffset(int offset, byte[] buffer, int pos) {
        return this.writeDwarfSectionOffset(offset, buffer, DwarfSectionName.DW_ABBREV_SECTION, pos);
    }

    protected int writeStrSectionOffset(String value, byte[] buffer, int p) {
        int pos = p;
        int idx = this.debugStringIndex(value);
        return this.writeStrSectionOffset(idx, buffer, pos);
    }

    private int writeStrSectionOffset(int offset, byte[] buffer, int pos) {
        return this.writeDwarfSectionOffset(offset, buffer, DwarfSectionName.DW_STR_SECTION, pos);
    }

    protected int writeLocSectionOffset(int offset, byte[] buffer, int pos) {
        return this.writeDwarfSectionOffset(offset, buffer, DwarfSectionName.DW_LOCLISTS_SECTION, pos);
    }

    protected int writeDwarfSectionOffset(int offset, byte[] buffer, DwarfSectionName referencedSectionName, int pos) {
        if (buffer != null) {
            return this.putRelocatableDwarfSectionOffset(offset, buffer, referencedSectionName.value(), pos);
        }
        return pos + 4;
    }

    protected int writeAttrNull(byte[] buffer, int pos) {
        return this.writeTag(DwarfTag.DW_TAG_null, buffer, pos);
    }

    protected int writeHeapLocationExprLoc(long offset, byte[] buffer, int p) {
        int pos = p;
        int size = this.writeHeapLocation(offset, null, 0);
        pos = this.writeULEB(size, buffer, pos);
        return this.writeHeapLocation(offset, buffer, pos);
    }

    protected int writeHeapLocationLocList(long offset, byte[] buffer, int p) {
        int pos = p;
        int len = 0;
        int lenPos = pos;
        int zeroPos = pos = this.writeULEB(len, buffer, pos);
        pos = this.writeHeapLocation(offset, buffer, pos);
        pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_stack_value, buffer, pos);
        len = pos - zeroPos;
        this.writeULEB(len, buffer, lenPos);
        return pos;
    }

    protected int writeHeapLocation(long offset, byte[] buffer, int p) {
        if (this.dwarfSections.useHeapBase()) {
            return this.writeHeapLocationBaseRelative(offset, buffer, p);
        }
        return this.writeHeapLocationRelocatable(offset, buffer, p);
    }

    private int writeHeapLocationBaseRelative(long offset, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeExprOpcodeBReg(this.dwarfSections.getHeapbaseRegister(), buffer, pos);
        return this.writeSLEB(offset, buffer, pos);
    }

    private int writeHeapLocationRelocatable(long offset, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_addr, buffer, pos);
        return this.writeRelocatableHeapOffset(offset, buffer, pos);
    }

    protected static String formatValue(DebugInfoProvider.DebugLocalValueInfo value) {
        switch (value.localKind()) {
            case REGISTER: {
                return "REG:" + value.regIndex();
            }
            case STACKSLOT: {
                return "STACK:" + value.stackSlot();
            }
            case CONSTANT: {
                return "CONST:" + String.valueOf(value.constantValue()) + "[" + Long.toHexString(value.heapOffset()) + "]";
            }
        }
        return "-";
    }

    public final String targetName() {
        return this.targetSectionName.value();
    }

    public final String getSectionName() {
        return this.sectionName.value();
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        if (this.targetName().startsWith(".debug")) {
            ObjectFile.Element previousElement = this.getElement().getOwner().elementForName(this.targetName());
            DwarfSectionImpl previousSection = (DwarfSectionImpl)previousElement.getImpl();
            assert (previousSection.contentByteArrayCreated());
        }
        this.createContent();
        return this.getContent().length;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        assert (this.contentByteArrayCreated());
        this.getOwner().debugContext(this.debugSectionLogName(), this::writeContent);
        return super.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public Set<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        Iterable deps = super.getDependencies((Map)decisions);
        String targetName = this.targetName();
        ELFObjectFile.ELFSection targetSection = (ELFObjectFile.ELFSection)this.getElement().getOwner().elementForName(targetName);
        LayoutDecision ourContent = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.CONTENT);
        LayoutDecision ourSize = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.SIZE);
        for (LayoutDecision.Kind targetKind : this.targetSectionKinds) {
            LayoutDecision targetDecision;
            if (targetKind == LayoutDecision.Kind.SIZE) {
                targetDecision = decisions.get(targetSection).getDecision(targetKind);
                deps.add(BuildDependency.createOrGet(ourSize, targetDecision));
                continue;
            }
            if (targetKind == LayoutDecision.Kind.CONTENT) {
                targetDecision = decisions.get(targetSection).getDecision(targetKind);
                deps.add(BuildDependency.createOrGet(ourContent, targetDecision));
                continue;
            }
            targetDecision = decisions.get(targetSection).getDecision(targetKind);
            deps.add(BuildDependency.createOrGet(ourSize, targetDecision));
        }
        return deps;
    }

    protected Stream<TypeEntry> typeStream() {
        return this.dwarfSections.getTypes().stream();
    }

    protected Stream<PrimitiveTypeEntry> primitiveTypeStream() {
        return this.typeStream().filter(TypeEntry::isPrimitive).map(entry -> (PrimitiveTypeEntry)entry);
    }

    protected Stream<ArrayTypeEntry> arrayTypeStream() {
        return this.typeStream().filter(TypeEntry::isArray).map(entry -> (ArrayTypeEntry)entry);
    }

    protected HeaderTypeEntry headerType() {
        return this.dwarfSections.lookupHeaderType();
    }

    protected TypeEntry voidType() {
        return this.dwarfSections.lookupVoidType();
    }

    protected Stream<ClassEntry> instanceClassStream() {
        return this.dwarfSections.getInstanceClasses().stream();
    }

    protected Stream<CompiledMethodEntry> compiledMethodsStream() {
        return this.dwarfSections.getCompiledMethods().stream();
    }

    protected int compiledMethodsCount() {
        return this.dwarfSections.getCompiledMethods().size();
    }

    protected Stream<FileEntry> fileStream() {
        return this.dwarfSections.getFiles().stream();
    }

    protected int fileCount() {
        return this.dwarfSections.getFiles().size();
    }

    protected Stream<DirEntry> dirStream() {
        return this.dwarfSections.getDirs().stream();
    }

    protected int dirCount() {
        return this.dwarfSections.getDirs().size();
    }

    protected Iterable<? extends ClassEntry> getInstanceClasses() {
        return this.dwarfSections.getInstanceClasses();
    }

    protected int debugStringIndex(String str) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.debugStringIndex(str);
    }

    protected String uniqueDebugString(String str) {
        return this.dwarfSections.uniqueDebugString(str);
    }

    protected TypeEntry lookupType(ResolvedJavaType type) {
        return this.dwarfSections.lookupTypeEntry(type);
    }

    protected ClassEntry lookupObjectClass() {
        return this.dwarfSections.lookupObjectClass();
    }

    protected int getCUIndex(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getCUIndex(classEntry);
    }

    protected void setCUIndex(ClassEntry classEntry, int idx) {
        this.dwarfSections.setCUIndex(classEntry, idx);
    }

    protected void setCodeRangesIndex(ClassEntry classEntry, int pos) {
        this.dwarfSections.setCodeRangesIndex(classEntry, pos);
    }

    protected int getCodeRangesIndex(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getCodeRangesIndex(classEntry);
    }

    protected void setLocationListIndex(ClassEntry classEntry, int pos) {
        this.dwarfSections.setLocationListIndex(classEntry, pos);
    }

    protected int getLocationListIndex(ClassEntry classEntry) {
        return this.dwarfSections.getLocationListIndex(classEntry);
    }

    protected void setLineIndex(ClassEntry classEntry, int pos) {
        this.dwarfSections.setLineIndex(classEntry, pos);
    }

    protected int getLineIndex(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getLineIndex(classEntry);
    }

    protected void setLinePrologueSize(ClassEntry classEntry, int pos) {
        this.dwarfSections.setLinePrologueSize(classEntry, pos);
    }

    protected int getLinePrologueSize(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getLinePrologueSize(classEntry);
    }

    protected void setFieldDeclarationIndex(StructureTypeEntry entry, String fieldName, int pos) {
        this.dwarfSections.setFieldDeclarationIndex(entry, fieldName, pos);
    }

    protected int getFieldDeclarationIndex(StructureTypeEntry entry, String fieldName) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getFieldDeclarationIndex(entry, fieldName);
    }

    protected void setMethodDeclarationIndex(MethodEntry methodEntry, int pos) {
        this.dwarfSections.setMethodDeclarationIndex(methodEntry, pos);
    }

    protected int getMethodDeclarationIndex(MethodEntry methodEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getMethodDeclarationIndex(methodEntry);
    }

    protected void setAbstractInlineMethodIndex(ClassEntry classEntry, MethodEntry methodEntry, int pos) {
        this.dwarfSections.setAbstractInlineMethodIndex(classEntry, methodEntry, pos);
    }

    protected int getAbstractInlineMethodIndex(ClassEntry classEntry, MethodEntry methodEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getAbstractInlineMethodIndex(classEntry, methodEntry);
    }

    protected void setMethodLocalIndex(ClassEntry classEntry, MethodEntry methodEntry, DebugInfoProvider.DebugLocalInfo localInfo, int index) {
        this.dwarfSections.setMethodLocalIndex(classEntry, methodEntry, localInfo, index);
    }

    protected int getMethodLocalIndex(ClassEntry classEntry, MethodEntry methodEntry, DebugInfoProvider.DebugLocalInfo localInfo) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getMethodLocalIndex(classEntry, methodEntry, localInfo);
    }

    protected void setRangeLocalIndex(Range range, DebugInfoProvider.DebugLocalInfo localInfo, int index) {
        this.dwarfSections.setRangeLocalIndex(range, localInfo, index);
    }

    protected int getRangeLocalIndex(Range range, DebugInfoProvider.DebugLocalInfo localInfo) {
        return this.dwarfSections.getRangeLocalIndex(range, localInfo);
    }

    protected class Cursor {
        private int pos;

        public Cursor(DwarfSectionImpl this$0) {
            this(this$0, 0);
        }

        public Cursor(DwarfSectionImpl this$0, int p) {
            assert (p >= 0);
            this.set(p);
        }

        public void set(int p) {
            assert (p >= 0);
            this.pos = p;
        }

        public int add(int d) {
            assert (this.pos + d >= 0);
            this.pos += d;
            return this.pos;
        }

        public int get() {
            return this.pos;
        }
    }
}

