/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.wasm.gc;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.RuntimeCodeInfoGCSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.aotjs.wasm.gc.ac;
import com.oracle.svm.hosted.aotjs.wasm.gc.aj;
import com.oracle.svm.hosted.aotjs.wasm.gc.ap;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class af
extends Heap {
    private final ap AY = new ap();
    public final ImageHeapInfo AZ = new ImageHeapInfo();
    private final aj Ba = new aj();
    private List<Class<?>> Bb;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public af() {
    }

    @Fold
    public static af getHeapImpl() {
        Heap heap = Heap.getHeap();
        assert (heap instanceof af) : "VMConfiguration heap is not a WasmHeap. " + String.valueOf(heap);
        return (af)heap;
    }

    public static ImageHeapInfo hE() {
        return af.getHeapImpl().AZ;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void attachThread(IsolateThread isolateThread) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void detachThread(IsolateThread isolateThread) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public void suspendAllocation() {
    }

    public void resumeAllocation() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAllocationDisallowed() {
        return NoAllocationVerifier.isActive() || VMThreads.SafepointBehavior.ignoresSafepoints() || this.Ba.hJ();
    }

    static void a(String string, String string2) {
        if (af.getHeapImpl().isAllocationDisallowed()) {
            NoAllocationVerifier.exit((String)string, (String)string2);
        }
    }

    public aj getGC() {
        return this.Ba;
    }

    public RuntimeCodeInfoGCSupport getRuntimeCodeInfoGCSupport() {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public boolean walkObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"must only be executed at a safepoint");
        return this.walkImageHeapObjects(visitor) && this.walkCollectedHeapObjects(visitor);
    }

    public boolean walkImageHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"Must only be called at a safepoint");
        if (visitor != null) {
            return ImageHeapWalker.walkImageHeapObjects((ImageHeapInfo)this.AZ, (ObjectVisitor)visitor) && (!AuxiliaryImageHeap.isPresent() || AuxiliaryImageHeap.singleton().walkObjects(visitor));
        }
        return true;
    }

    public boolean walkCollectedHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"Must only be called at a safepoint");
        return ac.walkObjects(visitor);
    }

    public boolean a(MemoryWalker.ImageHeapRegionVisitor imageHeapRegionVisitor) {
        return ImageHeapWalker.walkRegions((ImageHeapInfo)this.AZ, (MemoryWalker.ImageHeapRegionVisitor)imageHeapRegionVisitor) && (!AuxiliaryImageHeap.isPresent() || AuxiliaryImageHeap.singleton().walkRegions(imageHeapRegionVisitor));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getClassCount() {
        return this.AZ.dynamicHubCount;
    }

    protected List<Class<?>> getAllClasses() {
        if (this.Bb == null) {
            ArrayList arrayList = new ArrayList(this.AZ.dynamicHubCount);
            ImageHeapWalker.walkRegions((ImageHeapInfo)this.AZ, (MemoryWalker.ImageHeapRegionVisitor)new a(arrayList));
            arrayList.trimToSize();
            this.Bb = arrayList;
        }
        assert (this.Bb.size() == this.AZ.dynamicHubCount);
        return this.Bb;
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord hF() {
        return WordFactory.unsigned((long)ac.hy());
    }

    public UnsignedWord getImageHeapReservedBytes() {
        throw VMError.unimplemented((String)"Native Memory Tracking is not supported");
    }

    public UnsignedWord getImageHeapCommittedBytes() {
        throw VMError.unimplemented((String)"Native Memory Tracking is not supported");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ObjectHeader getObjectHeader() {
        return this.AY;
    }

    ap getObjectHeaderImpl() {
        return this.AY;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean tearDown() {
        throw VMError.unimplemented((String)"WasmHeap.tearDown");
    }

    public void prepareForSafepoint() {
    }

    public void endSafepoint() {
    }

    public int getPreferredAddressSpaceAlignment() {
        throw VMError.unimplemented((String)"WasmHeap.getPreferredAddressSpaceAlignment");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer getImageHeapStart() {
        return ((Word)Isolates.IMAGE_HEAP_BEGIN.get()).add(this.getImageHeapOffsetInAddressSpace());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getImageHeapOffsetInAddressSpace() {
        return 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Object obj) {
        return this.isInImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer objPointer) {
        return this.isInPrimaryImageHeap(objPointer);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInPrimaryImageHeap(Object obj) {
        return this.isInPrimaryImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInPrimaryImageHeap(Pointer objPointer) {
        return this.AZ.isInImageHeap(objPointer);
    }

    boolean o(Pointer pointer) {
        return this.isInImageHeap(pointer) || ac.d(pointer);
    }

    public void doReferenceHandling() {
        throw VMError.unimplemented((String)"WasmHeap.doReferenceHandling");
    }

    public boolean hasReferencePendingList() {
        throw VMError.unimplemented((String)"WasmHeap.hasReferencePendingList");
    }

    public void waitForReferencePendingList() {
        throw VMError.unimplemented((String)"WasmHeap.waitForReferencePendingList");
    }

    public void wakeUpReferencePendingListWaiters() {
        throw VMError.unimplemented((String)"WasmHeap.wakeUpReferencePendingListWaiters");
    }

    public Reference<?> getAndClearReferencePendingList() {
        throw VMError.unimplemented((String)"WasmHeap.getAndClearReferencePendingList");
    }

    public boolean printLocationInfo(Log log, UnsignedWord value, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        throw VMError.unimplemented((String)"WasmHeap.printLocationInfo");
    }

    public void optionValueChanged(RuntimeOptionKey<?> key) {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadAllocatedMemory(IsolateThread thread) {
        throw VMError.unimplemented((String)"WasmHeap.getThreadAllocatedMemory");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getUsedMemoryAfterLastGC() {
        throw VMError.unimplemented((String)"WasmHeap.getUsedMemoryAfterLastGC");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyAllReferencesOf(Object obj) {
        throw VMError.unimplemented((String)"WasmHeap.dirtyAllReferencesOf");
    }

    public long getMillisSinceLastWholeHeapExamined() {
        throw VMError.unimplemented((String)"WasmHeap.getMillisSinceLastWholeHeapExamined");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getIdentityHashSalt(Object obj) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"identity hash codes are never computed from addresses");
        return 0L;
    }

    public boolean verifyImageHeapMapping() {
        return true;
    }

    private static final class a
    implements MemoryWalker.ImageHeapRegionVisitor,
    ObjectVisitor {
        private final List<Class<?>> Bc;

        private a(List<Class<?>> list) {
            this.Bc = list;
        }

        public <T> boolean visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            if (!access.isWritable(region) && !access.consistsOfHugeObjects(region)) {
                access.visitObjects(region, (ObjectVisitor)this);
            }
            return true;
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Allocation is fine: this method traverses only the image heap.")
        public boolean visitObject(Object o2) {
            if (o2 instanceof Class) {
                this.Bc.add((Class)o2);
            }
            return true;
        }
    }
}

