/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.aotjs.substitute.system;

import com.oracle.svm.aotjs.functionintrinsics.e;
import com.oracle.svm.aotjs.substitute.system.a;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDKLatest;
import com.oracle.svm.core.util.VMError;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

@TargetClass(value=FileInputStream.class)
final class Target_java_io_FileInputStream_Web {
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    InputStream virtualInputStream;
    @Alias
    private FileDescriptor fd;

    Target_java_io_FileInputStream_Web() {
    }

    @Substitute
    private static void initIDs() {
        a.al();
    }

    @Substitute
    public void close() throws IOException {
        if (this.virtualInputStream != null) {
            this.virtualInputStream.close();
        }
    }

    @Substitute
    private int readBytes(byte[] b2, int off, int len) throws IOException {
        if (this.fd.equals(FileDescriptor.in)) {
            return e.a(b2, off, len);
        }
        return this.virtualInputStream.read(b2, off, len);
    }

    @Substitute
    public long skip(long n2) throws IOException {
        if (this.fd.equals(FileDescriptor.in)) {
            return 0L;
        }
        return this.virtualInputStream.skip(n2);
    }

    @Substitute
    public int available() throws IOException {
        if (this.fd.equals(FileDescriptor.in)) {
            return 0;
        }
        return this.virtualInputStream.available();
    }

    @Substitute
    private void open0(String name) throws IOException {
        this.virtualInputStream = Files.newInputStream(Paths.get(name, new String[0]), new OpenOption[0]);
    }

    @Substitute
    public int read() throws IOException {
        if (this.virtualInputStream != null) {
            return this.virtualInputStream.read();
        }
        throw VMError.unimplemented((String)"reading from file descriptor");
    }

    @Substitute
    public FileChannel getChannel() {
        throw VMError.unimplemented((String)"FileInputStream.getChannel");
    }

    @Substitute
    private long position0() {
        throw VMError.unimplemented((String)"FileInputStream.position0");
    }

    @Substitute
    private long length0() {
        throw VMError.unimplemented((String)"FileInputStream.length0");
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    private boolean isRegularFile() {
        return !this.fd.equals(FileDescriptor.in);
    }
}

