/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.aotjs.functionintrinsics;

import com.oracle.svm.aotjs.annotation.a;
import com.oracle.svm.aotjs.annotation.d;
import com.oracle.svm.aotjs.b;
import com.oracle.svm.aotjs.e;
import java.math.BigInteger;
import org.graalvm.aotjs.api.JS;
import org.graalvm.aotjs.api.JSBigInt;
import org.graalvm.aotjs.api.JSBoolean;
import org.graalvm.aotjs.api.JSError;
import org.graalvm.aotjs.api.JSNumber;
import org.graalvm.aotjs.api.JSString;
import org.graalvm.aotjs.api.JSValue;

public class c {
    public static boolean extractJavaScriptBoolean(Boolean b2) {
        return b2;
    }

    public static double extractJavaScriptNumber(Double d2) {
        return d2;
    }

    @a
    @JS(value="return s.toJSString();")
    public static native Object extractJavaScriptString(String var0);

    @a
    @JS(value="const javaScriptNative = self[runtime.symbol.javaScriptNative]; return javaScriptNative === undefined ? null : javaScriptNative;")
    public static native Object extractJavaScriptNative(Object var0);

    @a
    @JS(value="return undefined;")
    private static native Object javaScriptUndefined();

    @a
    @JS(value="return toProxy(self);")
    public static native Object extractJavaScriptProxy(Object var0);

    @a
    @JS(value="const javaNative = proxy[runtime.symbol.javaNative]; return javaNative === undefined ? null : javaNative;")
    public static native Object unproxy(Object var0);

    public static Boolean createJavaBoolean(boolean b2) {
        return b2;
    }

    public static Byte createJavaByte(byte b2) {
        return b2;
    }

    public static Short createJavaShort(short s2) {
        return s2;
    }

    public static Character createJavaCharacter(char c2) {
        return Character.valueOf(c2);
    }

    public static Integer createJavaInteger(int i2) {
        return i2;
    }

    public static Float createJavaFloat(float f2) {
        return Float.valueOf(f2);
    }

    public static Long createJavaLong(long l2) {
        return l2;
    }

    public static Double createJavaDouble(double d2) {
        return d2;
    }

    @a
    @JS(value="return createJSObject(javaScriptObject);")
    public static native Object createJSObject(Object var0);

    public static boolean coerceToJavaScriptBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw c.throwClassCastException(obj, "boolean");
    }

    public static double coerceToJavaScriptNumber(Object obj) {
        if (obj instanceof Double || obj instanceof Long || obj instanceof Integer || obj instanceof Float || obj instanceof Short || obj instanceof Byte) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        throw c.throwClassCastException(obj, "number");
    }

    @d.a
    public static Object coerceToJavaScriptBigInt(Object obj) {
        if (obj instanceof Double || obj instanceof Long || obj instanceof Integer || obj instanceof Float || obj instanceof Short || obj instanceof Byte) {
            String string = Long.valueOf(((Number)obj).longValue()).toString();
            return c.extractJavaScriptString(string);
        }
        if (obj instanceof Character) {
            return c.extractJavaScriptString(Long.valueOf(((Character)obj).charValue()).toString());
        }
        if (obj instanceof BigInteger) {
            return c.extractJavaScriptString(obj.toString());
        }
        throw c.throwClassCastException(obj, "number");
    }

    public static Object coerceToJavaScriptString(Object obj) {
        if (obj instanceof String) {
            return c.extractJavaScriptString((String)obj);
        }
        throw c.throwClassCastException(obj, "string");
    }

    public static Object coerceToJavaScriptObject(Object obj) {
        if (obj instanceof boolean[] || obj instanceof byte[] || obj instanceof char[] || obj instanceof short[] || obj instanceof int[] || obj instanceof float[] || obj instanceof long[] || obj instanceof double[]) {
            return obj;
        }
        throw c.throwClassCastException(obj, "object");
    }

    public static Object coerceToJavaScriptUint8Array(Object obj) {
        if (obj instanceof boolean[]) {
            return obj;
        }
        throw c.throwClassCastException(obj, "Uint8Array");
    }

    public static Object coerceToJavaScriptInt8Array(Object obj) {
        if (obj instanceof byte[]) {
            return obj;
        }
        throw c.throwClassCastException(obj, "Int8Array");
    }

    public static Object coerceToJavaScriptUint16Array(Object obj) {
        if (obj instanceof char[]) {
            return obj;
        }
        throw c.throwClassCastException(obj, "Uint16Array");
    }

    public static Object coerceToJavaScriptInt16Array(Object obj) {
        if (obj instanceof short[]) {
            return obj;
        }
        throw c.throwClassCastException(obj, "Int16Array");
    }

    public static Object coerceToJavaScriptInt32Array(Object obj) {
        if (obj instanceof int[]) {
            return obj;
        }
        throw c.throwClassCastException(obj, "Int32Array");
    }

    public static Object coerceToJavaScriptFloat32Array(Object obj) {
        if (obj instanceof float[]) {
            return obj;
        }
        throw c.throwClassCastException(obj, "Float32Array");
    }

    public static Object coerceToJavaScriptBigInt64Array(Object obj) {
        if (obj instanceof long[]) {
            return obj;
        }
        throw c.throwClassCastException(obj, "BigInt64Array");
    }

    public static char[] createCharArray(int length) {
        return new char[length];
    }

    public static Object coerceToJavaScriptFloat64Array(Object obj) {
        if (obj instanceof double[]) {
            return obj;
        }
        throw c.throwClassCastException(obj, "Float64Array");
    }

    public static int lengthOf(Object[] array) {
        return array.length;
    }

    public static Class<?> hubOf(Object x2) {
        return x2.getClass();
    }

    public static boolean isSupertype(Class<?> x2, Class<?> y2) {
        return x2.isAssignableFrom(y2);
    }

    public static boolean isJavaLangString(Object x2) {
        return x2 instanceof String;
    }

    @a
    @JS(value="return isInternalJavaObject(obj) ? obj : toJavaString(obj.toString());")
    private static native Object asJavaObjectOrString(Object var0);

    public static ClassCastException throwClassCastExceptionForClass(Object obj, Class<?> tpe) {
        throw new ClassCastException("'" + String.valueOf(c.asJavaObjectOrString(obj)) + "' cannot be coerced to '" + tpe.getSimpleName() + "'.");
    }

    public static ClassCastException throwClassCastException(Object obj, String tpe) {
        throw new ClassCastException("'" + String.valueOf(c.asJavaObjectOrString(obj)) + "' cannot be coerced to a JavaScript '" + tpe + "'.");
    }

    public static Object javaToJavaScript(Object x2) {
        if (x2 == null) {
            return null;
        }
        if (x2 == JSValue.undefined()) {
            return c.javaScriptUndefined();
        }
        Object object = c.extractJavaScriptNative(x2);
        if (object != null) {
            return object;
        }
        return c.extractJavaScriptProxy(x2);
    }

    @a
    @JS(value="return javaScriptToJava(x);")
    public static native Object javaScriptToJava(Object var0);

    public static Object coerceJavaToJavaScript(Object x2) {
        if (x2 == null) {
            return null;
        }
        if (x2 instanceof JSValue) {
            return x2;
        }
        if (x2 instanceof Number) {
            if (x2 instanceof BigInteger) {
                return JSBigInt.of((BigInteger)((BigInteger)x2));
            }
            if (x2 instanceof Long) {
                return JSBigInt.of((long)((Long)x2));
            }
            if (x2 instanceof Integer || x2 instanceof Float || x2 instanceof Double || x2 instanceof Byte || x2 instanceof Short) {
                return JSNumber.of((double)((Number)x2).doubleValue());
            }
        }
        if (x2 instanceof String) {
            return JSString.of((String)((String)x2));
        }
        if (x2 instanceof Boolean) {
            return JSBoolean.of((boolean)((Boolean)x2));
        }
        if (x2 instanceof Character) {
            return JSNumber.of((double)((Character)x2).charValue());
        }
        Class<?> clazz = x2.getClass();
        if (clazz.isArray() && clazz.getComponentType().isPrimitive()) {
            return c.createJSObject(x2);
        }
        return x2;
    }

    public static <T> T coerceJavaScriptToJava(Object x2, Class<T> target) {
        if (x2 == null) {
            return null;
        }
        if (x2 instanceof JSValue) {
            JSValue jSValue = (JSValue)x2;
            return (T)jSValue.as(target);
        }
        if (target.isAssignableFrom(x2.getClass())) {
            return (T)x2;
        }
        throw c.throwClassCastExceptionForClass(x2, target);
    }

    public static void handleJSError(Object excp) throws Throwable {
        if (b.a(excp)) {
            throw (Throwable)excp;
        }
        Object object = c.javaScriptToJava(excp);
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            throw throwable;
        }
        throw new JSError(object);
    }

    static {
        e.a("$as", "$vm");
    }
}

