/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.lambda;

import com.oracle.graal.pointsto.phases.NoClassInitializationPlugin;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.util.ClassUtil;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.stream.Stream;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.replacements.MethodHandlePlugin;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class LambdaParser {
    public static StructuredGraph createMethodGraph(ResolvedJavaMethod method, OptionValues options) {
        LambdaGraphBuilderPhase lambdaParserPhase = new LambdaGraphBuilderPhase();
        DebugContext.Description description = new DebugContext.Description((Object)method, ClassUtil.getUnqualifiedName((Class)method.getClass()) + ":" + method.getName());
        DebugContext debug = new DebugContext.Builder(options, (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalAccess.getOriginalSnippetReflection())).description(description).build();
        HighTierContext context = new HighTierContext(GraalAccess.getOriginalProviders(), null, OptimisticOptimizations.NONE);
        StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug).method(method).recordInlinedMethods(false).build();
        try (DebugContext.Scope ignored = debug.scope((Object)"ParsingToMaterializeLambdas");){
            lambdaParserPhase.apply(graph, context);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return graph;
    }

    public static Stream<? extends ResolvedJavaMethod> allExecutablesDeclaredInClass(ResolvedJavaType t) {
        return Stream.concat(Stream.concat(Arrays.stream(t.getDeclaredMethods(false)), Arrays.stream(t.getDeclaredConstructors(false))), t.getClassInitializer() == null ? Stream.empty() : Stream.of(t.getClassInitializer()));
    }

    public static Class<?> getLambdaClassFromConstantNode(ConstantNode constantNode) {
        Constant constant = constantNode.getValue();
        Class<?> lambdaClass = LambdaParser.getLambdaClassFromMemberField(constant);
        if (lambdaClass == null) {
            return null;
        }
        return LambdaUtils.isLambdaClass(lambdaClass) ? lambdaClass : null;
    }

    private static Class<?> getLambdaClassFromMemberField(Constant constant) {
        ResolvedJavaType constantType = GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType((JavaConstant)constant);
        if (constantType == null) {
            return null;
        }
        ResolvedJavaField[] fields = constantType.getInstanceFields(true);
        ResolvedJavaField targetField = null;
        for (ResolvedJavaField field : fields) {
            if (!field.getName().equals("member")) continue;
            targetField = field;
            break;
        }
        if (targetField == null) {
            return null;
        }
        JavaConstant fieldValue = GraalAccess.getOriginalProviders().getConstantReflection().readFieldValue(targetField, (JavaConstant)constant);
        Member memberField = (Member)GraalAccess.getOriginalProviders().getSnippetReflection().asObject(Member.class, fieldValue);
        return memberField.getDeclaringClass();
    }

    static class LambdaGraphBuilderPhase
    extends GraphBuilderPhase {
        LambdaGraphBuilderPhase() {
            super(LambdaGraphBuilderPhase.buildLambdaParserConfig());
        }

        LambdaGraphBuilderPhase(GraphBuilderConfiguration config) {
            super(config);
        }

        private static GraphBuilderConfiguration buildLambdaParserConfig() {
            GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(new InvocationPlugins());
            plugins.setClassInitializationPlugin((ClassInitializationPlugin)new NoClassInitializationPlugin());
            plugins.prependNodePlugin((NodePlugin)new MethodHandlePlugin(GraalAccess.getOriginalProviders().getConstantReflection().getMethodHandleAccess(), false));
            return GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)plugins).withEagerResolving(true);
        }

        public GraphBuilderPhase copyWithConfig(GraphBuilderConfiguration config) {
            return new LambdaGraphBuilderPhase(config);
        }

        protected GraphBuilderPhase.Instance createInstance(CoreProviders providers, GraphBuilderConfiguration instanceGBConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            return new GraphBuilderPhase.Instance(this, providers, instanceGBConfig, optimisticOpts, initialIntrinsicContext){

                protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
                    return new LambdaBytecodeParser(this, graph, parent, method, entryBCI, intrinsicContext);
                }
            };
        }

        static class LambdaBytecodeParser
        extends BytecodeParser {
            protected LambdaBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
                super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
            }
        }
    }
}

