/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.jni.CallVariant;
import com.oracle.svm.core.jni.JNIJavaCallTrampolineHolder;
import com.oracle.svm.core.jni.access.JNIAccessibleClass;
import com.oracle.svm.core.jni.access.JNIAccessibleField;
import com.oracle.svm.core.jni.access.JNIAccessibleMethod;
import com.oracle.svm.core.jni.access.JNIAccessibleMethodDescriptor;
import com.oracle.svm.core.jni.access.JNINativeLinkage;
import com.oracle.svm.core.jni.access.JNIReflectionDictionary;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.config.DynamicHubLayout;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.jni.JNICallTrampolineMethod;
import com.oracle.svm.hosted.jni.JNIJavaCallVariantWrapperMethod;
import com.oracle.svm.hosted.jni.JNIJavaCallWrapperMethod;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.KnownOffsetsFeature;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.reflect.NativeImageConditionResolver;
import com.oracle.svm.hosted.reflect.proxy.DynamicProxyFeature;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeJNIAccessSupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class JNIAccessFeature
implements Feature {
    private JNIRuntimeAccessibilitySupportImpl runtimeSupport;
    private boolean sealed = false;
    private final Map<String, JNICallTrampolineMethod> trampolineMethods = new ConcurrentHashMap<String, JNICallTrampolineMethod>();
    private final Map<ResolvedSignature<ResolvedJavaType>, JNIJavaCallWrapperMethod> javaCallWrapperMethods = new ConcurrentHashMap<ResolvedSignature<ResolvedJavaType>, JNIJavaCallWrapperMethod>();
    private final Map<ResolvedSignature<ResolvedJavaType>, JNIJavaCallVariantWrapperGroup> callVariantWrappers = new ConcurrentHashMap<ResolvedSignature<ResolvedJavaType>, JNIJavaCallVariantWrapperGroup>();
    private final Map<ResolvedSignature<ResolvedJavaType>, JNIJavaCallVariantWrapperGroup> nonvirtualCallVariantWrappers = new ConcurrentHashMap<ResolvedSignature<ResolvedJavaType>, JNIJavaCallVariantWrapperGroup>();
    private final List<JNICallableJavaMethod> calledJavaMethods = new ArrayList<JNICallableJavaMethod>();
    private int loadedConfigurations;
    private final Set<Class<?>> newClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> newNegativeClassLookups = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Executable> newMethods = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Class<?>, Set<Pair<String, Class<?>[]>>> newNegativeMethodLookups = new ConcurrentHashMap();
    private final Map<Field, Boolean> newFields = new ConcurrentHashMap<Field, Boolean>();
    private final Map<Class<?>, Set<String>> newNegativeFieldLookups = new ConcurrentHashMap();
    private final Map<JNINativeLinkage, JNINativeLinkage> newLinkages = new ConcurrentHashMap<JNINativeLinkage, JNINativeLinkage>();
    private final Map<JNINativeLinkage, JNINativeLinkage> nativeLinkages = new ConcurrentHashMap<JNINativeLinkage, JNINativeLinkage>();

    @Fold
    public static JNIAccessFeature singleton() {
        return (JNIAccessFeature)ImageSingletons.lookup(JNIAccessFeature.class);
    }

    private void abortIfSealed() {
        UserError.guarantee(!this.sealed, "Classes, methods and fields must be registered for JNI access before the analysis has completed.", new Object[0]);
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(KnownOffsetsFeature.class, DynamicProxyFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess arg) {
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)arg;
        JNIReflectionDictionary.create();
        this.runtimeSupport = new JNIRuntimeAccessibilitySupportImpl();
        ImageSingletons.add(RuntimeJNIAccessSupport.class, (Object)this.runtimeSupport);
        NativeImageConditionResolver conditionResolver = new NativeImageConditionResolver(access.getImageClassLoader(), ClassInitializationSupport.singleton());
        ReflectionConfigurationParser<ConfigurationCondition, Class<?>> parser = ConfigurationParserUtils.create("jni", true, conditionResolver, (ReflectionRegistry)this.runtimeSupport, null, access.getImageClassLoader());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurationsFromCombinedFile(parser, access.getImageClassLoader(), "JNI");
        ReflectionConfigurationParser<ConfigurationCondition, Class<?>> legacyParser = ConfigurationParserUtils.create(null, false, conditionResolver, (ReflectionRegistry)this.runtimeSupport, null, access.getImageClassLoader());
        this.loadedConfigurations += ConfigurationParserUtils.parseAndRegisterConfigurations(legacyParser, access.getImageClassLoader(), "JNI", ConfigurationFiles.Options.JNIConfigurationFiles, ConfigurationFiles.Options.JNIConfigurationResources, ConfigurationFile.JNI.getFileName());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)arg;
        for (CallVariant variant : CallVariant.values()) {
            JNIAccessFeature.registerJavaCallTrampoline(access, variant, false);
            JNIAccessFeature.registerJavaCallTrampoline(access, variant, true);
        }
        JNIAccessFeature.singleton().runtimeSupport.setAnalysisAccess(access);
    }

    private static void registerJavaCallTrampoline(FeatureImpl.BeforeAnalysisAccessImpl access, CallVariant variant, boolean nonVirtual) {
        MetaAccessProvider originalMetaAccess = access.getMetaAccess().getWrapped();
        ResolvedJavaField field = JNIAccessibleMethod.getCallVariantWrapperField(originalMetaAccess, variant, nonVirtual);
        access.registerAsAccessed(access.getUniverse().lookup((JavaField)field), "it is registered for JNI accessed");
        String name = JNIJavaCallTrampolineHolder.getTrampolineName(variant, nonVirtual);
        Method method = ReflectionUtil.lookupMethod(JNIJavaCallTrampolineHolder.class, (String)name, (Class[])new Class[0]);
        access.registerAsRoot(method, true, "Registered in " + String.valueOf(JNIAccessFeature.class), new MultiMethod.MultiMethodKey[0]);
    }

    public JNICallTrampolineMethod getCallTrampolineMethod(CallVariant variant, boolean nonVirtual) {
        String name = JNIJavaCallTrampolineHolder.getTrampolineName(variant, nonVirtual);
        return this.getCallTrampolineMethod(name);
    }

    public JNICallTrampolineMethod getCallTrampolineMethod(String trampolineName) {
        JNICallTrampolineMethod trampoline = this.trampolineMethods.get(trampolineName);
        assert (trampoline != null);
        return trampoline;
    }

    public JNICallTrampolineMethod getOrCreateCallTrampolineMethod(MetaAccessProvider metaAccess, String trampolineName) {
        return this.trampolineMethods.computeIfAbsent(trampolineName, name -> {
            Method reflectionMethod = ReflectionUtil.lookupMethod(JNIJavaCallTrampolineHolder.class, (String)name, (Class[])new Class[0]);
            boolean nonVirtual = JNIJavaCallTrampolineHolder.isNonVirtual(name);
            ResolvedJavaField field = JNIAccessibleMethod.getCallVariantWrapperField(metaAccess, JNIJavaCallTrampolineHolder.getVariant(name), nonVirtual);
            ResolvedJavaMethod method = metaAccess.lookupJavaMethod((Executable)reflectionMethod);
            return new JNICallTrampolineMethod(method, field, nonVirtual);
        });
    }

    public JNINativeLinkage makeLinkage(String declaringClass, String name, String descriptor) {
        UserError.guarantee(!this.sealed, "All linkages for JNI calls must be created before the analysis has completed.%nOffending class: %s name: %s descriptor: %s", declaringClass, name, descriptor);
        assert (declaringClass.startsWith("L") && declaringClass.endsWith(";")) : declaringClass;
        JNINativeLinkage key = new JNINativeLinkage(declaringClass, name, descriptor);
        if (Options.PrintJNIMethods.getValue().booleanValue()) {
            System.out.println("Creating a new JNINativeLinkage: " + String.valueOf(key));
        }
        return this.nativeLinkages.computeIfAbsent(key, linkage -> {
            this.newLinkages.put((JNINativeLinkage)linkage, (JNINativeLinkage)linkage);
            return linkage;
        });
    }

    private boolean wereElementsAdded() {
        return !this.newClasses.isEmpty() || !this.newMethods.isEmpty() || !this.newFields.isEmpty() || !this.newLinkages.isEmpty() || !this.newNegativeClassLookups.isEmpty() || !this.newNegativeFieldLookups.isEmpty() || !this.newNegativeMethodLookups.isEmpty();
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        if (!this.wereElementsAdded()) {
            return;
        }
        for (Class<?> clazz2 : this.newClasses) {
            JNIAccessFeature.addClass(clazz2, access);
        }
        this.newClasses.clear();
        for (String className : this.newNegativeClassLookups) {
            JNIAccessFeature.addNegativeClassLookup(className);
        }
        this.newNegativeClassLookups.clear();
        for (Executable method : this.newMethods) {
            this.addMethod(method, access);
        }
        this.newMethods.clear();
        this.newNegativeMethodLookups.forEach((clazz, signatures) -> {
            for (Pair signature : signatures) {
                JNIAccessFeature.addNegativeMethodLookup(clazz, (String)signature.getLeft(), (Class[])signature.getRight(), access);
            }
        });
        this.newNegativeMethodLookups.clear();
        this.newFields.forEach((field, writable) -> JNIAccessFeature.addField(field, writable, access));
        this.newFields.clear();
        this.newNegativeFieldLookups.forEach((clazz, fieldNames) -> {
            for (String fieldName : fieldNames) {
                JNIAccessFeature.addNegativeFieldLookup(clazz, fieldName, access);
            }
        });
        this.newNegativeFieldLookups.clear();
        JNIReflectionDictionary.singleton().addLinkages(this.newLinkages);
        this.newLinkages.clear();
        access.requireAnalysisIteration();
    }

    private static JNIAccessibleClass addClass(Class<?> classObj, FeatureImpl.DuringAnalysisAccessImpl access) {
        if (classObj.isPrimitive()) {
            return null;
        }
        if (SubstitutionReflectivityFilter.shouldExclude(classObj, access.getMetaAccess(), access.getUniverse())) {
            return null;
        }
        return JNIReflectionDictionary.singleton().addClassIfAbsent(classObj, c -> {
            AnalysisType analysisClass = access.getMetaAccess().lookupJavaType(classObj);
            if (analysisClass.isInterface() || analysisClass.isInstanceClass() && analysisClass.isAbstract()) {
                analysisClass.registerAsReachable((Object)"is accessed via JNI");
            } else {
                analysisClass.registerAsInstantiated((Object)"is accessed via JNI");
            }
            return new JNIAccessibleClass(classObj);
        });
    }

    private static void addNegativeClassLookup(String className) {
        JNIReflectionDictionary.singleton().addNegativeClassLookupIfAbsent(className);
    }

    public void addMethod(Executable method, FeatureImpl.DuringAnalysisAccessImpl access) {
        if (SubstitutionReflectivityFilter.shouldExclude(method, access.getMetaAccess(), access.getUniverse())) {
            return;
        }
        JNIAccessibleClass jniClass = JNIAccessFeature.addClass(method.getDeclaringClass(), access);
        JNIAccessibleMethodDescriptor descriptor = JNIAccessibleMethodDescriptor.of(method);
        jniClass.addMethodIfAbsent(descriptor, d -> {
            AnalysisUniverse universe = access.getUniverse();
            MetaAccessProvider originalMetaAccess = universe.getOriginalMetaAccess();
            ResolvedJavaMethod targetMethod = originalMetaAccess.lookupJavaMethod(method);
            JNIJavaCallWrapperMethod.Factory factory = (JNIJavaCallWrapperMethod.Factory)ImageSingletons.lookup(JNIJavaCallWrapperMethod.Factory.class);
            AnalysisMethod aTargetMethod = universe.lookup((JavaMethod)targetMethod);
            if (!targetMethod.isConstructor() || factory.canInvokeConstructorOnObject(targetMethod, originalMetaAccess)) {
                access.registerAsRoot(aTargetMethod, false, "JNI method, registered in " + String.valueOf(JNIAccessFeature.class), new MultiMethod.MultiMethodKey[0]);
            }
            ResolvedJavaMethod newObjectMethod = null;
            if (targetMethod.isConstructor() && !targetMethod.getDeclaringClass().isAbstract()) {
                AnalysisMethod aFactoryMethod = FactoryMethodSupport.singleton().lookup(access.getMetaAccess(), aTargetMethod, false);
                access.registerAsRoot(aFactoryMethod, true, "JNI constructor, registered in " + String.valueOf(JNIAccessFeature.class), new MultiMethod.MultiMethodKey[0]);
                access.registerAsUnsafeAllocated(aTargetMethod.getDeclaringClass());
                newObjectMethod = aFactoryMethod.getWrapped();
            }
            ResolvedSignature<ResolvedJavaType> compatibleSignature = JNIJavaCallWrapperMethod.getGeneralizedSignatureForTarget(targetMethod, originalMetaAccess);
            JNIJavaCallWrapperMethod callWrapperMethod = this.javaCallWrapperMethods.computeIfAbsent(compatibleSignature, signature -> factory.create((ResolvedSignature<ResolvedJavaType>)signature, originalMetaAccess, access.getBigBang().getWordTypes()));
            access.registerAsRoot(universe.lookup((JavaMethod)callWrapperMethod), true, "JNI call wrapper, registered in " + String.valueOf(JNIAccessFeature.class), new MultiMethod.MultiMethodKey[0]);
            JNIJavaCallVariantWrapperGroup variantWrappers = this.createJavaCallVariantWrappers(access, callWrapperMethod.getSignature(), false, method);
            JNIJavaCallVariantWrapperGroup nonvirtualVariantWrappers = null;
            if (!Modifier.isStatic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
                nonvirtualVariantWrappers = this.createJavaCallVariantWrappers(access, callWrapperMethod.getSignature(), true, method);
            }
            JNIAccessibleMethod jniMethod = new JNIAccessibleMethod(jniClass, method.getModifiers());
            this.calledJavaMethods.add(new JNICallableJavaMethod(descriptor, jniMethod, targetMethod, callWrapperMethod, newObjectMethod, variantWrappers, nonvirtualVariantWrappers));
            return jniMethod;
        });
    }

    private static void addNegativeMethodLookup(Class<?> declaringClass, String methodName, Class<?>[] parameterTypes, FeatureImpl.DuringAnalysisAccessImpl access) {
        JNIAccessibleClass jniClass = JNIAccessFeature.addClass(declaringClass, access);
        JNIAccessibleMethodDescriptor descriptor = JNIAccessibleMethodDescriptor.of(methodName, parameterTypes);
        jniClass.addMethodIfAbsent(descriptor, d -> JNIAccessibleMethod.negativeMethodQuery(jniClass));
    }

    private JNIJavaCallVariantWrapperGroup createJavaCallVariantWrappers(FeatureImpl.DuringAnalysisAccessImpl access, ResolvedSignature<ResolvedJavaType> wrapperSignature, boolean nonVirtual, Executable method) {
        Map<ResolvedSignature<ResolvedJavaType>, JNIJavaCallVariantWrapperGroup> map = nonVirtual ? this.nonvirtualCallVariantWrappers : this.callVariantWrappers;
        return map.computeIfAbsent(wrapperSignature, signature -> {
            MetaAccessProvider originalMetaAccess = access.getUniverse().getOriginalMetaAccess();
            WordTypes wordTypes = access.getBigBang().getWordTypes();
            JNIJavaCallVariantWrapperMethod varargs = new JNIJavaCallVariantWrapperMethod(method, (ResolvedSignature<ResolvedJavaType>)signature, CallVariant.VARARGS, nonVirtual, originalMetaAccess, wordTypes);
            JNIJavaCallVariantWrapperMethod array = new JNIJavaCallVariantWrapperMethod(method, (ResolvedSignature<ResolvedJavaType>)signature, CallVariant.ARRAY, nonVirtual, originalMetaAccess, wordTypes);
            JNIJavaCallVariantWrapperMethod valist = new JNIJavaCallVariantWrapperMethod(method, (ResolvedSignature<ResolvedJavaType>)signature, CallVariant.VA_LIST, nonVirtual, originalMetaAccess, wordTypes);
            Stream<JNIJavaCallVariantWrapperMethod> wrappers = Stream.of(varargs, array, valist);
            CEntryPointData unpublished = CEntryPointData.createCustomUnpublished();
            wrappers.forEach(wrapper -> {
                AnalysisMethod analysisWrapper = access.getUniverse().lookup((JavaMethod)wrapper);
                access.getBigBang().addRootMethod(analysisWrapper, true, (Object)("Registerd in " + String.valueOf(JNIAccessFeature.class)), new MultiMethod.MultiMethodKey[0]);
                analysisWrapper.registerAsEntryPoint((Object)unpublished);
            });
            return new JNIJavaCallVariantWrapperGroup(varargs, array, valist);
        });
    }

    private static void addField(Field reflField, boolean writable, FeatureImpl.DuringAnalysisAccessImpl access) {
        if (SubstitutionReflectivityFilter.shouldExclude(reflField, access.getMetaAccess(), access.getUniverse())) {
            return;
        }
        JNIAccessibleClass jniClass = JNIAccessFeature.addClass(reflField.getDeclaringClass(), access);
        AnalysisField field = access.getMetaAccess().lookupJavaField(reflField);
        jniClass.addFieldIfAbsent(field.getName(), name -> new JNIAccessibleField(jniClass, field.getJavaKind(), field.getModifiers()));
        field.registerAsRead((Object)"it is registered for as JNI accessed");
        if (writable) {
            field.registerAsWritten((Object)"it is registered as JNI writable");
            AnalysisType fieldType = field.getType();
            if (fieldType.isArray() && !access.isReachable(fieldType)) {
                access.registerReachabilityHandler(a -> fieldType.registerAsInstantiated((Object)"Is accessed via JNI."), fieldType.getElementalType().getJavaClass());
            }
        } else if (field.isStatic() && field.isFinal()) {
            MaterializedConstantFields.singleton().register(field);
        }
        BigBang bb = access.getBigBang();
        bb.registerAsJNIAccessed(field, writable);
    }

    private static void addNegativeFieldLookup(Class<?> declaringClass, String fieldName, FeatureImpl.DuringAnalysisAccessImpl access) {
        JNIAccessibleClass jniClass = JNIAccessFeature.addClass(declaringClass, access);
        jniClass.addFieldIfAbsent(fieldName, d -> JNIAccessibleField.negativeFieldQuery(jniClass));
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
        if (this.wereElementsAdded()) {
            this.abortIfSealed();
        }
        int numClasses = 0;
        int numFields = 0;
        int numMethods = 0;
        for (JNIAccessibleClass clazz : JNIReflectionDictionary.singleton().getClasses()) {
            ++numClasses;
            UnmodifiableMapCursor<CharSequence, JNIAccessibleField> fieldsCursor = clazz.getFields();
            while (fieldsCursor.advance()) {
                if (((JNIAccessibleField)fieldsCursor.getValue()).isNegativeHosted()) continue;
                ++numFields;
            }
            MapCursor<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> methodsCursor = clazz.getMethods();
            while (methodsCursor.advance()) {
                if (((JNIAccessibleMethod)methodsCursor.getValue()).isNegative()) continue;
                ++numMethods;
            }
        }
        ProgressReporter.singleton().setJNIInfo(numClasses, numFields, numMethods);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FallbackFeature.FallbackImageRequest jniFallback;
        if (ImageSingletons.contains(FallbackFeature.class) && (jniFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).jniFallback) != null && this.loadedConfigurations == 0) {
            throw jniFallback;
        }
        FeatureImpl.CompilationAccessImpl access = (FeatureImpl.CompilationAccessImpl)a;
        DynamicHubLayout dynamicHubLayout = DynamicHubLayout.singleton();
        for (JNIAccessibleClass clazz : JNIReflectionDictionary.singleton().getClasses()) {
            UnmodifiableMapCursor<CharSequence, JNIAccessibleField> cursor = clazz.getFields();
            while (cursor.advance()) {
                String name = (String)cursor.getKey();
                JNIAccessFeature.finishFieldBeforeCompilation(name, (JNIAccessibleField)cursor.getValue(), access, dynamicHubLayout);
            }
        }
        for (JNICallableJavaMethod method : this.calledJavaMethods) {
            JNIAccessFeature.finishMethodBeforeCompilation(method, access);
            access.registerAsImmutable(method.jniMethod);
        }
    }

    private static void finishMethodBeforeCompilation(JNICallableJavaMethod method, FeatureImpl.CompilationAccessImpl access) {
        int vtableOffset;
        int interfaceTypeID;
        HostedUniverse hUniverse = access.getUniverse();
        AnalysisUniverse aUniverse = access.getUniverse().getBigBang().getUniverse();
        HostedMethod hTarget = hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)method.targetMethod));
        if (SubstrateOptions.useClosedTypeWorldHubLayout()) {
            interfaceTypeID = -3;
            vtableOffset = hTarget.canBeStaticallyBound() ? -1 : KnownOffsets.singleton().getVTableOffset(hTarget.getVTableIndex(), true);
        } else if (hTarget.canBeStaticallyBound()) {
            vtableOffset = -1;
            interfaceTypeID = -3;
        } else {
            vtableOffset = KnownOffsets.singleton().getVTableOffset(hTarget.getVTableIndex(), false);
            HostedType declaringClass = hTarget.getDeclaringClass();
            interfaceTypeID = declaringClass.isInterface() ? declaringClass.getTypeID() : -1;
        }
        MethodPointer nonvirtualTarget = new MethodPointer(hTarget);
        MethodPointer newObjectTarget = null;
        if (method.newObjectMethod != null) {
            newObjectTarget = new MethodPointer(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)method.newObjectMethod)));
        } else if (method.targetMethod.isConstructor()) {
            assert (method.targetMethod.getDeclaringClass().isAbstract());
            newObjectTarget = (PointerBase)WordFactory.signed((int)-1);
        }
        MethodPointer callWrapper = new MethodPointer(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)method.callWrapper)));
        MethodPointer varargs = new MethodPointer(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)method.variantWrappers.varargs)));
        MethodPointer array = new MethodPointer(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)method.variantWrappers.array)));
        MethodPointer valist = new MethodPointer(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)method.variantWrappers.valist)));
        MethodPointer varargsNonvirtual = null;
        MethodPointer arrayNonvirtual = null;
        MethodPointer valistNonvirtual = null;
        if (method.nonvirtualVariantWrappers != null) {
            varargsNonvirtual = new MethodPointer(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)method.nonvirtualVariantWrappers.varargs)));
            arrayNonvirtual = new MethodPointer(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)method.nonvirtualVariantWrappers.array)));
            valistNonvirtual = new MethodPointer(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)method.nonvirtualVariantWrappers.valist)));
        }
        EconomicSet<Class<?>> hidingSubclasses = JNIAccessFeature.findHidingSubclasses(hTarget.getDeclaringClass(), sub -> JNIAccessFeature.anyMethodMatchesIgnoreReturnType(sub, method.descriptor));
        method.jniMethod.finishBeforeCompilation(hidingSubclasses, vtableOffset, interfaceTypeID, (CodePointer)nonvirtualTarget, (PointerBase)newObjectTarget, (CodePointer)callWrapper, (CodePointer)varargs, (CodePointer)array, (CodePointer)valist, (CodePointer)varargsNonvirtual, (CodePointer)arrayNonvirtual, (CodePointer)valistNonvirtual);
    }

    private static boolean anyMethodMatchesIgnoreReturnType(ResolvedJavaType sub, JNIAccessibleMethodDescriptor descriptor) {
        try {
            for (ResolvedJavaMethod method : sub.getDeclaredMethods(false)) {
                if (!descriptor.matchesIgnoreReturnType(method)) continue;
                return true;
            }
            return false;
        }
        catch (LinkageError ex) {
            return false;
        }
    }

    private static EconomicSet<Class<?>> findHidingSubclasses(HostedType type, Predicate<ResolvedJavaType> predicate) {
        return JNIAccessFeature.findHidingSubclasses0(type, predicate, null, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static EconomicSet<Class<?>> findHidingSubclasses0(HostedType type, Predicate<ResolvedJavaType> predicate, EconomicSet<Class<?>> existing, Set<HostedType> visitedTypes) {
        EconomicSet<Class<?>> map = existing;
        for (HostedType subType : type.getSubTypes()) {
            if (visitedTypes.contains(subType)) continue;
            visitedTypes.add(subType);
            if (subType.isInstantiated() || subType.getWrapped().isReachable()) {
                ResolvedJavaType originalType = subType.getWrapped().getWrapped();
                assert (!(originalType instanceof WrappedJavaType)) : "need fully unwrapped type for member lookups";
                if (predicate.test(originalType)) {
                    if (map == null) {
                        map = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
                    }
                    map.add(subType.getJavaClass());
                    continue;
                }
                map = JNIAccessFeature.findHidingSubclasses0(subType, predicate, map, visitedTypes);
                continue;
            }
            assert (JNIAccessFeature.findHidingSubclasses0(subType, predicate, null, visitedTypes) == null) : "Class hiding a member exists in the image, but its superclass does not";
        }
        return map;
    }

    private static void finishFieldBeforeCompilation(String name, JNIAccessibleField field, FeatureImpl.CompilationAccessImpl access, DynamicHubLayout dynamicHubLayout) {
        try {
            int offset = -1;
            EconomicSet<Class<?>> hidingSubclasses = null;
            if (!field.isNegativeHosted()) {
                Class<?> declaringClass = field.getDeclaringClass().getClassObject();
                Field reflField = declaringClass.getDeclaredField(name);
                HostedField hField = access.getMetaAccess().lookupJavaField(reflField);
                if (dynamicHubLayout.isInlinedField(hField)) {
                    throw VMError.shouldNotReachHere("DynamicHub inlined fields are not accessible %s", hField);
                }
                if (HybridLayout.isHybridField(hField)) {
                    assert (!hField.hasLocation());
                    HybridLayout hybridLayout = new HybridLayout((HostedInstanceClass)hField.getDeclaringClass(), (ObjectLayout)ImageSingletons.lookup(ObjectLayout.class), (MetaAccessProvider)access.getMetaAccess());
                    assert (hField.equals(hybridLayout.getArrayField())) : "JNI access to hybrid objects is implemented only for the array field";
                    offset = hybridLayout.getArrayBaseOffset();
                } else {
                    assert (hField.hasLocation());
                    offset = hField.getLocation();
                }
                hidingSubclasses = JNIAccessFeature.findHidingSubclasses(hField.getDeclaringClass(), sub -> JNIAccessFeature.anyFieldMatches(sub, name));
            }
            field.finishBeforeCompilation(offset, hidingSubclasses);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean anyFieldMatches(ResolvedJavaType sub, String name) {
        try {
            return Stream.concat(Stream.of(sub.getInstanceFields(false)), Stream.of(sub.getStaticFields())).anyMatch(f -> f.getName().equals(name));
        }
        catch (LinkageError ex) {
            return false;
        }
    }

    private static void requireNonNull(Object[] values, String kind) {
        for (Object value : values) {
            Objects.requireNonNull(value, () -> JNIAccessFeature.nullErrorMessage(kind));
        }
    }

    private static String nullErrorMessage(String kind) {
        return "Cannot register null value as " + kind + " for JNI access. Please ensure that all values you register are not null.";
    }

    private class JNIRuntimeAccessibilitySupportImpl
    extends ConditionalConfigurationRegistry
    implements RuntimeJNIAccessSupport {
        private JNIRuntimeAccessibilitySupportImpl() {
        }

        public void register(ConfigurationCondition condition, boolean unsafeAllocated, Class<?> clazz) {
            assert (!unsafeAllocated) : "unsafeAllocated can be only set via Unsafe.allocateInstance, not via JNI.";
            Objects.requireNonNull(clazz, () -> JNIAccessFeature.nullErrorMessage("class"));
            JNIAccessFeature.this.abortIfSealed();
            this.registerConditionalConfiguration(condition, cnd -> JNIAccessFeature.this.newClasses.add(clazz));
        }

        public void register(ConfigurationCondition condition, boolean queriedOnly, Executable ... executables) {
            JNIAccessFeature.requireNonNull(executables, "executable");
            JNIAccessFeature.this.abortIfSealed();
            if (!queriedOnly) {
                this.registerConditionalConfiguration(condition, cnd -> JNIAccessFeature.this.newMethods.addAll(Arrays.asList(executables)));
            }
        }

        public void register(ConfigurationCondition condition, boolean finalIsWritable, Field ... fields) {
            JNIAccessFeature.requireNonNull(fields, "field");
            JNIAccessFeature.this.abortIfSealed();
            this.registerConditionalConfiguration(condition, cnd -> this.registerFields(finalIsWritable, fields));
        }

        private void registerFields(boolean finalIsWritable, Field[] fields) {
            for (Field field : fields) {
                boolean writable = finalIsWritable || !Modifier.isFinal(field.getModifiers());
                JNIAccessFeature.this.newFields.put(field, writable);
            }
        }

        public void registerClassLookup(ConfigurationCondition condition, String typeName) {
            try {
                this.register(condition, false, Class.forName(typeName));
            }
            catch (ClassNotFoundException e) {
                JNIAccessFeature.this.newNegativeClassLookups.add(typeName);
            }
        }

        public void registerFieldLookup(ConfigurationCondition condition, Class<?> declaringClass, String fieldName) {
            try {
                this.register(condition, false, declaringClass.getDeclaredField(fieldName));
            }
            catch (NoSuchFieldException e) {
                JNIAccessFeature.this.newNegativeFieldLookups.computeIfAbsent(declaringClass, clazz -> new HashSet()).add(fieldName);
            }
        }

        public void registerMethodLookup(ConfigurationCondition condition, Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
            try {
                this.register(condition, false, declaringClass.getDeclaredMethod(methodName, parameterTypes));
            }
            catch (NoSuchMethodException e) {
                JNIAccessFeature.this.newNegativeMethodLookups.computeIfAbsent(declaringClass, clazz -> new HashSet()).add(Pair.create((Object)methodName, parameterTypes));
            }
        }

        public void registerConstructorLookup(ConfigurationCondition condition, Class<?> declaringClass, Class<?> ... parameterTypes) {
            try {
                this.register(condition, false, declaringClass.getDeclaredConstructor(parameterTypes));
            }
            catch (NoSuchMethodException e) {
                JNIAccessFeature.this.newNegativeMethodLookups.computeIfAbsent(declaringClass, clazz -> new HashSet()).add(Pair.create((Object)"<init>", parameterTypes));
            }
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PrintJNIMethods = new HostedOptionKey<Boolean>(false);
    }

    static final class JNIJavaCallVariantWrapperGroup {
        final JNIJavaCallVariantWrapperMethod varargs;
        final JNIJavaCallVariantWrapperMethod array;
        final JNIJavaCallVariantWrapperMethod valist;

        JNIJavaCallVariantWrapperGroup(JNIJavaCallVariantWrapperMethod varargs, JNIJavaCallVariantWrapperMethod array, JNIJavaCallVariantWrapperMethod valist) {
            this.varargs = varargs;
            this.array = array;
            this.valist = valist;
        }
    }

    static final class JNICallableJavaMethod {
        final JNIAccessibleMethodDescriptor descriptor;
        final JNIAccessibleMethod jniMethod;
        final ResolvedJavaMethod targetMethod;
        final JNIJavaCallWrapperMethod callWrapper;
        final ResolvedJavaMethod newObjectMethod;
        final JNIJavaCallVariantWrapperGroup variantWrappers;
        final JNIJavaCallVariantWrapperGroup nonvirtualVariantWrappers;

        JNICallableJavaMethod(JNIAccessibleMethodDescriptor descriptor, JNIAccessibleMethod jniMethod, ResolvedJavaMethod targetMethod, JNIJavaCallWrapperMethod callWrapper, ResolvedJavaMethod newObjectMethod, JNIJavaCallVariantWrapperGroup variantWrappers, JNIJavaCallVariantWrapperGroup nonvirtualVariantWrappers) {
            this.descriptor = descriptor;
            assert ((targetMethod.isStatic() || targetMethod.isAbstract()) == (nonvirtualVariantWrappers == null));
            this.jniMethod = jniMethod;
            this.targetMethod = targetMethod;
            this.callWrapper = callWrapper;
            this.newObjectMethod = newObjectMethod;
            this.variantWrappers = variantWrappers;
            this.nonvirtualVariantWrappers = nonvirtualVariantWrappers;
        }
    }
}

