/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.jdk.VarHandleInfo;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;

final class StaticVarHandleInfo
extends VarHandleInfo {
    final Function<Object, Object> baseGetter;

    StaticVarHandleInfo(Function<Object, JavaKind> kindGetter, ToLongFunction<Object> offsetGetter, Function<Object, Object> baseGetter) {
        super(kindGetter, offsetGetter);
        this.baseGetter = baseGetter;
    }

    @Override
    ResolvedJavaField findOriginalField(Object varHandle) {
        long offset = this.offsetGetter.applyAsLong(varHandle);
        Object base = this.baseGetter.apply(varHandle);
        JavaKind kind = (JavaKind)this.kindGetter.apply(varHandle);
        JavaConstant baseHandle = GraalAccess.getOriginalProviders().getSnippetReflection().forObject(base);
        ResolvedJavaField result = GraalAccess.getOriginalProviders().getMetaAccessExtensionProvider().getStaticFieldForAccess(baseHandle, offset, kind);
        if (result == null) {
            throw VMError.shouldNotReachHere("Could not find static field referenced in VarHandle: base = " + String.valueOf(base) + ", offset = " + offset + ", kind = " + String.valueOf(kind));
        }
        return result;
    }
}

