/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import java.util.List;
import jdk.graal.compiler.debug.Assertions;
import org.graalvm.collections.EconomicMap;

class ImageSingletonWriterImpl
implements ImageSingletonWriter {
    private final EconomicMap<String, Object> keyValueStore = EconomicMap.create();

    ImageSingletonWriterImpl() {
    }

    EconomicMap<String, Object> getKeyValueStore() {
        return this.keyValueStore;
    }

    @Override
    public void writeBoolList(String keyName, List<Boolean> value) {
        List<Integer> internalValue = value.stream().map(e -> e != false ? 1 : 0).toList();
        Object previous = this.keyValueStore.put((Object)keyName, List.of("B(", internalValue));
        assert (previous == null) : previous;
    }

    @Override
    public void writeInt(String keyName, int value) {
        Object previous = this.keyValueStore.put((Object)keyName, List.of("I", Integer.valueOf(value)));
        assert (previous == null) : previous;
    }

    @Override
    public void writeIntList(String keyName, List<Integer> value) {
        Object previous = this.keyValueStore.put((Object)keyName, List.of("I(", value));
        assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{keyName, previous});
    }

    @Override
    public void writeLong(String keyName, long value) {
        Object previous = this.keyValueStore.put((Object)keyName, List.of("L", Long.valueOf(value)));
        assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{keyName, previous});
    }

    @Override
    public void writeString(String keyName, String value) {
        Object previous = this.keyValueStore.put((Object)keyName, List.of("S", value));
        assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{keyName, previous});
    }

    @Override
    public void writeStringList(String keyName, List<String> value) {
        Object previous = this.keyValueStore.put((Object)keyName, List.of("S(", value));
        assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{keyName, previous});
    }
}

