/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.pltgot.amd64;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.amd64.AMD64SnippetsFeature;
import com.oracle.svm.graal.pltgot.PLTGOTNonSnippetLowerings;
import com.oracle.svm.hosted.pltgot.PLTGOTOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.AMD64.class})
public class PLTGOTAMD64Lowerings
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return PLTGOTOptions.EnablePLTGOT.getValue();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(AMD64SnippetsFeature.class);
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        if (hosted) {
            PLTGOTNonSnippetLowerings.registerLowerings(runtimeConfig, lowerings);
        }
    }
}

