/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.SpeculationReasonEncodingClone;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import jdk.graal.compiler.util.Digest;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

final class IsolatedSpeculationReasonEncoding
extends ByteArrayOutputStream
implements SpeculationReasonEncodingClone {
    private DataOutputStream dos = new DataOutputStream(this);
    private byte[] result;
    private static final int NULL_METHOD = -1;
    private static final int NULL_TYPE = -2;
    private static final int NULL_STRING = -3;

    IsolatedSpeculationReasonEncoding() {
    }

    private void checkOpen() {
        if (this.result != null) {
            throw new IllegalArgumentException("Cannot update closed speculation encoding");
        }
    }

    @Override
    public void addByte(int value) {
        this.checkOpen();
        try {
            this.dos.writeByte(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public void addShort(int value) {
        this.checkOpen();
        try {
            this.dos.writeShort(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public void addMethod(ResolvedJavaMethod method) {
        ResolvedJavaMethod original = method;
        if (method instanceof SharedRuntimeMethod) {
            original = ((SharedRuntimeMethod)method).getOriginal();
        }
        this.addImageHeapObject(original, -1);
    }

    @Override
    public void addType(ResolvedJavaType type) {
        this.addImageHeapObject(type, -2);
    }

    private void addImageHeapObject(Object object, int nullValue) {
        this.checkOpen();
        if (!this.addNull(object, nullValue)) {
            try {
                this.dos.writeLong(ImageHeapObjects.ref(object).rawValue());
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
        }
    }

    @Override
    public void addString(String value) {
        this.checkOpen();
        if (!this.addNull(value, -3)) {
            try {
                this.dos.writeChars(value);
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
        }
    }

    @Override
    public void addInt(int value) {
        this.checkOpen();
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public void addLong(long value) {
        this.checkOpen();
        try {
            this.dos.writeLong(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    private boolean addNull(Object o, int nullValue) {
        if (o == null) {
            this.addInt(nullValue);
            return true;
        }
        return false;
    }

    byte[] getByteArray() {
        if (this.result == null) {
            this.result = this.count > 22 ? Digest.digestAsByteArray((byte[])this.buf, (int)0, (int)this.count) : Arrays.copyOf(this.buf, this.count);
            this.dos = null;
        }
        return this.result;
    }
}

