/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util.coder;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.util.coder.ByteStream;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class NativeCoder {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int readU1(Pointer ptr) {
        return ptr.readInt(0) & 0xFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int readU2(Pointer ptr) {
        return ptr.readShort(0) & 0xFFFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long readU4(Pointer ptr) {
        return (long)ptr.readInt(0) & 0xFFFFFFFFL;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord readU8(Pointer ptr) {
        return WordFactory.unsigned((long)ptr.readLong(0));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static byte readByte(ByteStream data) {
        Pointer position = data.getPosition();
        byte result = position.readByte(0);
        data.setPosition(position.add(1));
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int readInt(ByteStream data) {
        Pointer position = data.getPosition();
        int result = position.readInt(0);
        data.setPosition(position.add(4));
        return result;
    }
}

