/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.thread.SafepointListener;
import java.util.Arrays;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public class SafepointListenerSupport {
    private SafepointListener[] listeners = new SafepointListener[0];

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SafepointListenerSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void register(SafepointListener listener) {
        assert (listener != null);
        int oldLength = this.listeners.length;
        this.listeners = Arrays.copyOf(this.listeners, oldLength + 1);
        this.listeners[oldLength] = listener;
    }

    @Fold
    public static SafepointListenerSupport singleton() {
        return (SafepointListenerSupport)ImageSingletons.lookup(SafepointListenerSupport.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void beforeSlowpathSafepointCheck() {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].beforeSlowPathSafepointCheck();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void afterFreezeAtSafepoint() {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].afterFreezeAtSafepoint();
        }
    }
}

