/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.attach;

import com.oracle.svm.core.attach.AttachListenerThread;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.attach.AttachHelper;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.BasedOnJDKFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class PosixAttachListenerThread
extends AttachListenerThread {
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/os/posix/attachListener_posix.cpp#L84")
    private static final String PROTOCOL_VERSION = "1";
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/os/posix/attachListener_posix.cpp#L259")
    private static final int VERSION_SIZE = 8;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/os/posix/attachListener_posix.cpp#L87")
    private static final int ATTACH_ERROR_BAD_VERSION = 101;
    private static final int EXPECTED_STRING_COUNT = 5;
    private static final int MAX_REQUEST_LEN = 3101;
    private final int listener;

    public PosixAttachListenerThread(int listener) {
        this.listener = listener;
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/os/posix/attachListener_posix.cpp#L354-L411")
    protected PosixAttachOperation dequeue() {
        PosixAttachOperation op;
        while (true) {
            int socket;
            if ((socket = AttachHelper.waitForRequest(this.listener)) == -1) {
                return null;
            }
            op = PosixAttachListenerThread.readRequest(socket);
            if (op != null) break;
            Unistd.NoTransitions.close(socket);
        }
        return op;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/os/posix/attachListener_posix.cpp#L258-L347")
    private static PosixAttachOperation readRequest(int socket) {
        int strCount = 0;
        int[] stringEnds = new int[5];
        Pointer buf = (Pointer)StackValue.get((int)3101);
        int offset = 0;
        do {
            int n;
            if ((n = PosixUtils.readUninterruptibly(socket, buf, 3101, offset)) == -1) {
                return null;
            }
            if (n == 0) break;
            int end = offset + n;
            while (offset < end) {
                if (buf.readByte(offset) == 0) {
                    stringEnds[strCount] = offset;
                    ++strCount;
                }
                ++offset;
            }
        } while (offset < 3101 && strCount < 5);
        if (strCount != 5) {
            return null;
        }
        String version = PosixAttachListenerThread.decodeString(buf, stringEnds, 0);
        if (!PROTOCOL_VERSION.equals(version)) {
            PosixAttachListenerThread.complete(socket, 101, null);
            return null;
        }
        String name = PosixAttachListenerThread.decodeString(buf, stringEnds, 1);
        if (name.length() > 16) {
            return null;
        }
        String arg0 = PosixAttachListenerThread.decodeString(buf, stringEnds, 2);
        if (arg0.length() > 1024) {
            return null;
        }
        String arg1 = PosixAttachListenerThread.decodeString(buf, stringEnds, 3);
        if (arg1.length() > 1024) {
            return null;
        }
        String arg2 = PosixAttachListenerThread.decodeString(buf, stringEnds, 4);
        if (arg2.length() > 1024) {
            return null;
        }
        return new PosixAttachOperation(name, arg0, arg1, arg2, socket);
    }

    private static String decodeString(Pointer buf, int[] stringEnds, int index) {
        int start = index == 0 ? 0 : stringEnds[index - 1] + 1;
        int length = stringEnds[index] - start;
        assert (length >= 0);
        return CTypeConversion.toJavaString((CCharPointer)((CCharPointer)buf.add(start)), (UnsignedWord)WordFactory.unsigned((int)length), (Charset)StandardCharsets.UTF_8);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/os/posix/attachListener_posix.cpp#L436-L455")
    private static void complete(int socket, int code, String response) {
        byte[] returnCodeData = Integer.toString(code).getBytes(StandardCharsets.UTF_8);
        PosixAttachListenerThread.sendData(socket, returnCodeData);
        byte[] lineBreak = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
        PosixAttachListenerThread.sendData(socket, lineBreak);
        if (response != null && !response.isEmpty()) {
            byte[] responseBytes = response.getBytes(StandardCharsets.UTF_8);
            PosixAttachListenerThread.sendData(socket, responseBytes);
            PosixAttachListenerThread.sendData(socket, lineBreak);
        }
        AttachHelper.shutdownSocket(socket);
        Unistd.NoTransitions.close(socket);
    }

    private static void sendData(int socket, byte[] data) {
        PosixUtils.writeUninterruptibly(socket, data);
    }

    private static class PosixAttachOperation
    extends AttachListenerThread.AttachOperation {
        private final int socket;

        PosixAttachOperation(String name, String arg0, String arg1, String arg2, int socket) {
            super(name, arg0, arg1, arg2);
            this.socket = socket;
        }

        @Override
        public void complete(int code, String response) {
            PosixAttachListenerThread.complete(this.socket, code, response);
        }
    }
}

