/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Time;
import java.io.Console;
import org.graalvm.nativeimage.StackValue;

@TargetClass(value=System.class)
final class Target_java_lang_System_Posix {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    static volatile Console cons;

    Target_java_lang_System_Posix() {
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long currentTimeMillis() {
        Time.timespec ts = (Time.timespec)StackValue.get(Time.timespec.class);
        int status = PosixUtils.clock_gettime(Time.CLOCK_REALTIME(), ts);
        PosixUtils.checkStatusIs0(status, "System.currentTimeMillis(): clock_gettime(CLOCK_REALTIME) failed.");
        return ts.tv_sec() * 1000L + ts.tv_nsec() / 1000000L;
    }
}

