/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nmt;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

class NmtMallocMemoryInfo {
    private final UninterruptibleUtils.AtomicLong count = new UninterruptibleUtils.AtomicLong(0L);
    private final UninterruptibleUtils.AtomicLong used = new UninterruptibleUtils.AtomicLong(0L);
    private final UninterruptibleUtils.AtomicLong countAtPeakUsage = new UninterruptibleUtils.AtomicLong(0L);
    private final UninterruptibleUtils.AtomicLong peakUsed = new UninterruptibleUtils.AtomicLong(0L);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    NmtMallocMemoryInfo() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void track(UnsignedWord allocationSize) {
        long newUsed = this.used.addAndGet(allocationSize.rawValue());
        long newCount = this.count.incrementAndGet();
        this.updatePeak(newUsed, newCount);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void updatePeak(long newUsed, long newCount) {
        long oldUsed = this.peakUsed.get();
        while (oldUsed < newUsed) {
            if (this.peakUsed.compareAndSet(oldUsed, newUsed)) {
                this.countAtPeakUsage.set(newCount);
                return;
            }
            oldUsed = this.peakUsed.get();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void untrack(UnsignedWord allocationSize) {
        long lastCount = this.count.decrementAndGet();
        long lastSize = this.used.addAndGet(-allocationSize.rawValue());
        assert (lastSize >= 0L && lastCount >= 0L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long getUsed() {
        return this.used.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long getCount() {
        return this.count.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long getPeakUsed() {
        return this.peakUsed.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long getCountAtPeakUsage() {
        return this.countAtPeakUsage.get();
    }
}

