/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.events.JavaMonitorEnterEvent;
import com.oracle.svm.core.monitor.JavaMonitorQueuedSynchronizer;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.util.BasedOnJDKClass;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.locks.ReentrantLock;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.internal.misc.Unsafe;

@BasedOnJDKClass.List(value={@BasedOnJDKClass(value=ReentrantLock.class), @BasedOnJDKClass(value=ReentrantLock.class, innerClass={"Sync"})})
public class JavaMonitor
extends JavaMonitorQueuedSynchronizer {
    protected long latestJfrTid = 0L;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long CONDITION_FIELD_OFFSET = U.objectFieldOffset(JavaMonitor.class, "condition");
    private JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject condition;
    protected int acquisitions = 1;

    public void monitorEnter(Object obj) {
        if (!this.tryLock()) {
            long startTicks = JfrTicks.elapsedTicks();
            this.acquire(1L);
            JavaMonitorEnterEvent.emit(obj, this.latestJfrTid, startTicks);
        }
        this.latestJfrTid = SubstrateJVM.getCurrentThreadId();
    }

    public void monitorExit() {
        this.release(1L);
    }

    public boolean isHeldByCurrentThread() {
        return this.isHeldExclusively();
    }

    protected JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject getOrCreateCondition(boolean createIfNotExisting) {
        JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject existingCondition = this.condition;
        if (existingCondition != null || !createIfNotExisting) {
            return existingCondition;
        }
        JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject newCondition = new JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject(this);
        if (!U.compareAndSetReference(this, CONDITION_FIELD_OFFSET, null, newCondition)) {
            newCondition = this.condition;
        }
        return newCondition;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void relockObject() {
        long currentThread = JavaMonitor.getCurrentThreadIdentity();
        long ownerThread = this.getState();
        if (ownerThread == 0L) {
            boolean success = this.compareAndSetState(0L, currentThread);
            VMError.guarantee(success && this.acquisitions == 1, "Could not re-lock object during deoptimization");
        } else {
            VMError.guarantee(ownerThread == currentThread, "Object that needs re-locking during deoptimization is already locked by another thread");
            ++this.acquisitions;
            VMError.guarantee(this.acquisitions > 0, "Maximum lock count exceeded");
        }
    }

    @Override
    protected long getAcquisitions() {
        return this.acquisitions;
    }

    @Override
    protected boolean tryAcquire(long acquires) {
        assert (acquires > 0L && acquires == (long)((int)acquires));
        if (BranchProbabilityNode.probability((double)0.09999999999999998, (this.getState() == 0L ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.9, (boolean)this.compareAndSetState(0L, JavaMonitor.getCurrentThreadIdentity()))) {
            assert (this.acquisitions == 1);
            this.acquisitions = (int)acquires;
            return true;
        }
        return false;
    }

    protected boolean tryLock() {
        long current = JavaMonitor.getCurrentThreadIdentity();
        long c = this.getState();
        if (c == 0L) {
            if (this.compareAndSetState(0L, current)) {
                assert (this.acquisitions == 1);
                return true;
            }
        } else if (c == current) {
            int r = this.acquisitions + 1;
            if (r < 0) {
                throw new Error("Maximum lock count exceeded");
            }
            this.acquisitions = r;
            return true;
        }
        return false;
    }

    @Override
    protected boolean tryRelease(long releases) {
        boolean free;
        assert (releases > 0L);
        long current = JavaMonitor.getCurrentThreadIdentity();
        long c = this.getState();
        if (c != current) {
            throw new IllegalMonitorStateException();
        }
        boolean bl = free = (long)this.acquisitions == releases;
        if (free) {
            this.acquisitions = 1;
            this.setState(0L);
        } else {
            assert (releases < (long)this.acquisitions);
            this.acquisitions -= (int)releases;
        }
        return free;
    }

    @Override
    protected boolean isHeldExclusively() {
        return this.getState() == JavaMonitor.getCurrentThreadIdentity();
    }

    boolean isLocked() {
        return this.getState() != 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static long getCurrentThreadIdentity() {
        return JavaThreads.getCurrentThreadId();
    }

    protected static long getThreadIdentity(Thread thread) {
        return JavaThreads.getThreadId(thread);
    }
}

