/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.jvmti.headers.JvmtiInterface;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class JvmtiFunctionTable {
    private final CFunctionPointer[] readOnlyFunctionTable;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JvmtiFunctionTable() {
        int length = JvmtiFunctionTable.bytesToWords(SizeOf.get(JvmtiInterface.class));
        this.readOnlyFunctionTable = new CFunctionPointer[length];
    }

    @Fold
    public static JvmtiFunctionTable singleton() {
        return (JvmtiFunctionTable)ImageSingletons.lookup(JvmtiFunctionTable.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void init(int offsetInBytes, CFunctionPointer functionPointer) {
        int index = JvmtiFunctionTable.bytesToWords(offsetInBytes);
        this.readOnlyFunctionTable[index] = functionPointer;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int bytesToWords(int bytes) {
        assert (bytes % ConfigurationValues.getTarget().wordSize == 0);
        return bytes / ConfigurationValues.getTarget().wordSize;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public CFunctionPointer[] getReadOnlyFunctionTable() {
        return this.readOnlyFunctionTable;
    }

    public static JvmtiInterface allocateFunctionTable() {
        UnsignedWord size = SizeOf.unsigned(JvmtiInterface.class);
        JvmtiInterface result = (JvmtiInterface)NullableNativeMemory.malloc(size, NmtCategory.JVMTI);
        if (result.isNonNull()) {
            NonmovableObjectArray readOnlyData = NonmovableArrays.fromImageHeap(JvmtiFunctionTable.singleton().readOnlyFunctionTable);
            assert (size.equal(NonmovableArrays.lengthOf(readOnlyData) * ConfigurationValues.getTarget().wordSize));
            UnmanagedMemoryUtil.copyForward(NonmovableArrays.getArrayBase(readOnlyData), (Pointer)result, size);
        }
        return result;
    }

    public static void freeFunctionTable(JvmtiInterface table) {
        NullableNativeMemory.free(table);
    }
}

