/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntryBase;
import com.oracle.svm.core.jdk.resources.Target_jdk_nio_zipfs_ZipUtils;
import java.io.InputStream;
import java.util.Arrays;

public final class NativeImageResourceFileSystemUtil {
    private NativeImageResourceFileSystemUtil() {
    }

    public static byte[] getBytes(String resourceName, boolean readOnly) {
        ResourceStorageEntryBase entry = Resources.singleton().getAtRuntime(resourceName, true);
        if (entry == null) {
            return new byte[0];
        }
        byte[] bytes = ((ResourceStorageEntry)entry).getData().get(0);
        if (readOnly) {
            return bytes;
        }
        return Arrays.copyOf(bytes, bytes.length);
    }

    public static int getSize(String resourceName) {
        ResourceStorageEntryBase entry = Resources.singleton().getAtRuntime(resourceName, true);
        if (entry == null) {
            return 0;
        }
        return ((ResourceStorageEntry)entry).getData().get(0).length;
    }

    public static String toRegexPattern(String globPattern) {
        return Target_jdk_nio_zipfs_ZipUtils.toRegexPattern(globPattern);
    }

    public static byte[] inputStreamToByteArray(InputStream is) {
        return Resources.inputStreamToByteArray(is);
    }
}

