/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.UnsupportedFeatureError;
import com.oracle.svm.core.jdk.VMErrorSubstitutions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(value=VMError.class)
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
final class Target_com_oracle_svm_core_util_VMError {
    Target_com_oracle_svm_core_util_VMError() {
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHereSubstitution() {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), "should not reach here: substitution reached at runtime", null);
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHereOverrideInChild() {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), "should not reach here: method should have been overridden in child", null);
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHereAtRuntime() {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), "should not reach here: this code is expected to be unreachable at runtime", null);
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHereUnexpectedInput(Object input) {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), "should not reach here: unexpected input could not be handled", null);
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere(String msg) {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), msg, null);
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere(Throwable ex) {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), null, ex);
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere(String msg, Throwable ex) {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), msg, ex);
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException unsupportedPlatform() {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), "should not reach here: unsupported platform", null);
    }

    @Substitute
    private static RuntimeException intentionallyUnimplemented() {
        return Target_com_oracle_svm_core_util_VMError.unsupportedFeature("unimplemented: this method has intentionally not been implemented");
    }

    @Substitute
    private static RuntimeException unsupportedFeature(String msg) {
        throw new UnsupportedFeatureError(msg);
    }
}

