/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.dcmd.AbstractDCmd;
import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdArguments;
import com.oracle.svm.core.log.StringBuilderLog;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticCommand.hpp#L219-L233")
public class VMUptimeDmd
extends AbstractDCmd {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMUptimeDmd() {
        super("VM.uptime", "Print VM uptime.", DCmd.Impact.Low);
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticCommand.cpp#L393-L400")
    public String execute(DCmdArguments args) throws Throwable {
        StringBuilderLog log = new StringBuilderLog();
        log.rational(Isolates.getUptimeMillis(), 1000L, 3L).string(" s").newline();
        return log.getResult();
    }
}

