/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.x509;

import com.oracle.jipher.pki.x509.GeneralName;
import java.security.cert.CRLReason;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class DistributionPoint {
    private List<GeneralName> fullName;
    private List<CRLReason> reasons;
    private List<GeneralName> issuer;
    private X500Principal relativeName;

    DistributionPoint(List<GeneralName> fullName, X500Principal relativeName, List<CRLReason> reasons, List<GeneralName> issuer) {
        this.fullName = fullName;
        this.relativeName = relativeName;
        this.reasons = reasons;
        this.issuer = issuer;
    }

    public List<GeneralName> getFullName() {
        if (this.fullName == null) {
            return null;
        }
        return Collections.unmodifiableList(this.fullName);
    }

    public X500Principal getRelativeName() {
        if (this.relativeName == null) {
            return null;
        }
        return this.relativeName;
    }

    public List<CRLReason> getReasons() {
        if (this.reasons == null) {
            return null;
        }
        return Collections.unmodifiableList(this.reasons);
    }

    public List<GeneralName> getCrlIssuer() {
        if (this.issuer == null) {
            return this.issuer;
        }
        return Collections.unmodifiableList(this.issuer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.fullName != null) {
            sb.append("fullName=").append(this.fullName).append(",");
        }
        if (this.relativeName != null) {
            sb.append("relativeName=").append(this.relativeName.getName()).append(",");
        }
        if (this.reasons != null) {
            sb.append("reasons=").append(this.reasons);
        }
        if (this.issuer != null) {
            sb.append("cRLIssuer=").append(this.issuer);
        }
        return sb.toString();
    }
}

