/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.EvpKdf;
import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.spi.InternalTlsSpec;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class TlsMasterSecretGenerator
extends KeyGeneratorSpi {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final byte[] MASTER_SECRET_LABEL = "master secret".getBytes(US_ASCII);
    private static final byte[] EXTENDED_MASTER_SECRET_LABEL = "extended master secret".getBytes(US_ASCII);
    private static final int MASTER_SECRET_KEY_LEN = 48;
    private static final String MSG = "TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec";
    private static final int TLS1_2_VER = 771;
    private InternalTlsSpec.MasterSecretParameterSpec paramSpec;
    private MdAlg md;

    @Override
    protected void engineInit(int keySize, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.paramSpec = null;
        InternalTlsSpec.MasterSecretParameterSpec pSpec = new InternalTlsSpec.MasterSecretParameterSpec(algorithmParameterSpec);
        if (!"RAW".equals(pSpec.getPremasterSecret().getFormat())) {
            throw new InvalidAlgorithmParameterException("Key encoding format must be RAW");
        }
        int protocolVersion = pSpec.getMajorVersion() << 8 | pSpec.getMinorVersion();
        if (protocolVersion != 771) {
            throw new InvalidAlgorithmParameterException("Only TLS 1.2 supported");
        }
        this.md = MdAlg.byName(pSpec.getPRFHashAlg());
        if (this.md == null) {
            throw new InvalidAlgorithmParameterException("Unsupported PRF hash algorithm");
        }
        this.paramSpec = pSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateKey() {
        if (this.paramSpec == null) {
            throw new IllegalStateException("TlsMasterSecretGenerator must be initialized");
        }
        byte[] extendedMasterSecretSessionHash = this.paramSpec.getExtendedMasterSecretSessionHash();
        SecretKey premasterKey = this.paramSpec.getPremasterSecret();
        byte[] premaster = premasterKey.getEncoded();
        try {
            int premasterMinor;
            int premasterMajor;
            if (premasterKey.getAlgorithm().equals("TlsRsaPremasterSecret")) {
                premasterMajor = premaster[0] & 0xFF;
                premasterMinor = premaster[1] & 0xFF;
            } else {
                premasterMajor = -1;
                premasterMinor = -1;
            }
            byte[] master = extendedMasterSecretSessionHash.length != 0 ? EvpKdf.tls1PrfDerive(premaster, EXTENDED_MASTER_SECRET_LABEL, extendedMasterSecretSessionHash, null, this.md, 48) : EvpKdf.tls1PrfDerive(premaster, MASTER_SECRET_LABEL, this.paramSpec.getClientRandom(), this.paramSpec.getServerRandom(), this.md, 48);
            SecretKey secretKey = InternalTlsSpec.newTlsMasterSecretKey(master, premasterMajor, premasterMinor);
            return secretKey;
        }
        finally {
            Util.clearArray(premaster);
        }
    }
}

