/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.TripleDesUtil;
import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.spi.CipherAlg;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class SymmKeyFactory
extends SecretKeyFactorySpi {
    final CipherAlg alg;

    SymmKeyFactory(CipherAlg alg) {
        this.alg = alg;
    }

    abstract SecretKey createKey(byte[] var1);

    KeySpec createKeySpec(byte[] key, Class<?> keySpec) throws InvalidKeySpecException {
        if (keySpec != null && keySpec.isAssignableFrom(SecretKeySpec.class)) {
            if (this.alg.isValidKeySize(key.length)) {
                return new SecretKeySpec(key, this.alg.getName());
            }
            throw new InvalidKeySpecException("Invalid key length");
        }
        throw new InvalidKeySpecException("Expected KeySpec to be assignable from SecretKeySpec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class<?> keySpec) throws InvalidKeySpecException {
        if (secretKey.getAlgorithm().equalsIgnoreCase(this.alg.getName()) && secretKey.getFormat().equalsIgnoreCase("RAW")) {
            byte[] encoded = secretKey.getEncoded();
            try {
                KeySpec keySpec2 = this.createKeySpec(encoded, keySpec);
                return keySpec2;
            }
            finally {
                Util.clearArray(encoded);
            }
        }
        throw new InvalidKeySpecException("Invalid key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SecretKeySpec) {
            byte[] key = ((SecretKeySpec)keySpec).getEncoded();
            try {
                if (!this.alg.isValidKeySize(key.length)) {
                    throw new InvalidKeySpecException("Invalid key size for " + this.alg.getName());
                }
                SecretKey secretKey = this.createKey(key);
                return secretKey;
            }
            finally {
                Util.clearArray(key);
            }
        }
        throw new InvalidKeySpecException("KeySpec not acceptable for " + this.alg.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        byte[] key = secretKey.getEncoded();
        try {
            if (!this.alg.isValidKeySize(key.length)) {
                throw new InvalidKeyException("Invalid key size for " + this.alg.getName());
            }
            SecretKey secretKey2 = this.createKey(key);
            return secretKey2;
        }
        finally {
            Util.clearArray(key);
        }
    }

    public static final class DESede
    extends SymmKeyFactory {
        public DESede() {
            super(new CipherAlg.DesEde());
        }

        @Override
        SecretKey createKey(byte[] key) {
            TripleDesUtil.setParityBits(key);
            return new SecretKeySpec(key, this.alg.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DESedeKeySpec) {
                DESedeKeySpec spec = (DESedeKeySpec)keySpec;
                byte[] key = spec.getKey();
                try {
                    SecretKey secretKey = this.createKey(key);
                    return secretKey;
                }
                finally {
                    Util.clearArray(key);
                }
            }
            return super.engineGenerateSecret(keySpec);
        }

        @Override
        KeySpec createKeySpec(byte[] key, Class<?> keySpec) throws InvalidKeySpecException {
            try {
                if (keySpec != null && keySpec.isAssignableFrom(DESedeKeySpec.class)) {
                    return new DESedeKeySpec(key);
                }
                return super.createKeySpec(key, keySpec);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Invalid key");
            }
        }
    }

    public static final class AES
    extends SymmKeyFactory {
        public AES() {
            super(new CipherAlg.AES());
        }

        @Override
        SecretKey createKey(byte[] key) {
            return new SecretKeySpec(key, this.alg.getName());
        }
    }
}

