/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Debug;
import com.oracle.jipher.internal.common.ToolkitProperties;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.crypto.Cipher;

public class KeySizeConfiguration {
    private static final Debug DEBUG = Debug.getInstance("jipher");
    private static final Function<Integer, Boolean> AES_FILTER = t -> {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") >= t;
        }
        catch (NoSuchAlgorithmException e) {
            return true;
        }
    };
    private static final AtomicReference<ImmutableKeySizeHolder> KEY_SIZES = new AtomicReference<ImmutableKeySizeHolder>(ImmutableKeySizeHolder.DEF_INSTANCE);

    private static void update() {
        String propValue = ToolkitProperties.getJavaKeyLengths();
        KEY_SIZES.set(KEY_SIZES.get().getInstance(propValue));
    }

    public static int getRSAKeySize() {
        KeySizeConfiguration.update();
        return KEY_SIZES.get().rsaSize;
    }

    public static int getECKeySize() {
        KeySizeConfiguration.update();
        return KEY_SIZES.get().ecSize;
    }

    public static int getAESKeySize() {
        KeySizeConfiguration.update();
        return KEY_SIZES.get().aesSize;
    }

    public static int getDHKeySize() {
        KeySizeConfiguration.update();
        return KEY_SIZES.get().dhSize;
    }

    public static int getDSAKeySize() {
        KeySizeConfiguration.update();
        return KEY_SIZES.get().dsaSize;
    }

    static /* synthetic */ Function access$000() {
        return AES_FILTER;
    }

    private static class ImmutableKeySizeHolder {
        private final String propValue;
        private final int rsaSize;
        private final int ecSize;
        private final int aesSize;
        private final int dhSize;
        private final int dsaSize;
        public static final ImmutableKeySizeHolder DEF_INSTANCE = new ImmutableKeySizeHolder(null, CryptoAlgo.RSA.getSize(), CryptoAlgo.EC.getSize(), CryptoAlgo.AES.getSize(), CryptoAlgo.DH.getSize(), CryptoAlgo.DSA.getSize());

        private ImmutableKeySizeHolder(String propValue, int rsaSize, int ecSize, int aesSize, int dhSize, int dsaSize) {
            this.propValue = propValue;
            this.rsaSize = rsaSize;
            this.ecSize = ecSize;
            this.aesSize = aesSize;
            this.dhSize = dhSize;
            this.dsaSize = dsaSize;
        }

        public ImmutableKeySizeHolder getInstance(String inPropValue) {
            if (Objects.equals(this.propValue, inPropValue)) {
                return this;
            }
            DEBUG.println("Property value change detected, updating default key sizes");
            Map<CryptoAlgo, Integer> sizeMap = this.parse(inPropValue);
            return new ImmutableKeySizeHolder(inPropValue, sizeMap.getOrDefault((Object)CryptoAlgo.RSA, CryptoAlgo.RSA.getSize()), sizeMap.getOrDefault((Object)CryptoAlgo.EC, CryptoAlgo.EC.getSize()), sizeMap.getOrDefault((Object)CryptoAlgo.AES, CryptoAlgo.AES.getSize()), sizeMap.getOrDefault((Object)CryptoAlgo.DH, CryptoAlgo.DH.getSize()), sizeMap.getOrDefault((Object)CryptoAlgo.DSA, CryptoAlgo.DSA.getSize()));
        }

        private Map<CryptoAlgo, Integer> parse(String propValue) {
            HashMap<CryptoAlgo, Integer> sizeMap = new HashMap<CryptoAlgo, Integer>();
            if (propValue != null) {
                String[] pairs;
                for (String p : pairs = propValue.split(",")) {
                    String[] algoAndValue = p.split(":");
                    if (algoAndValue.length != 2) {
                        if (DEBUG == null) continue;
                        DEBUG.println("Ignoring invalid pair in " + p);
                        continue;
                    }
                    String algoName = algoAndValue[0].trim().toUpperCase();
                    int value = -1;
                    try {
                        value = Integer.parseInt(algoAndValue[1].trim());
                    }
                    catch (NumberFormatException nfe) {
                        if (DEBUG == null) continue;
                        DEBUG.println("Ignoring invalid value in " + p);
                        continue;
                    }
                    try {
                        CryptoAlgo algo = CryptoAlgo.valueOf(algoName);
                        if (!algo.isPermitted(value)) continue;
                        sizeMap.put(algo, value);
                    }
                    catch (IllegalArgumentException e) {
                        DEBUG.println("Ignoring unsupported algo in " + p);
                    }
                }
            }
            return sizeMap;
        }
    }

    private static enum CryptoAlgo {
        RSA(3072, 2048, 4096),
        EC(256, 384, 521),
        AES(KeySizeConfiguration.access$000(), 256, 192, 128),
        DH(3072, 2048, 4096),
        DSA(2048, 3072);

        private final int defaultValue;
        private final List<Integer> permittedValues;

        private CryptoAlgo(int ... sizeValues) {
            this.defaultValue = sizeValues[0];
            this.permittedValues = new LinkedList<Integer>();
            for (int val : sizeValues) {
                this.permittedValues.add(val);
            }
        }

        private CryptoAlgo(Function<Integer, Boolean> valFilter, int ... sizeValues) {
            this.permittedValues = new LinkedList<Integer>();
            for (int val : sizeValues) {
                boolean isValid = valFilter.apply(val);
                if (!isValid) continue;
                this.permittedValues.add(val);
            }
            this.defaultValue = this.permittedValues.get(0);
        }

        int getSize() {
            return this.defaultValue;
        }

        boolean isPermitted(int value) {
            return this.permittedValues.contains(value);
        }
    }
}

