/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.List;
import javax.crypto.spec.GCMParameterSpec;

public class GcmParameters
extends AlgorithmParametersSpi {
    private GCMParameterSpec gcmSpec;

    @Override
    protected byte[] engineGetEncoded() {
        return Asn1.newSequence(Asn1.newOctetString(this.gcmSpec.getIV()), Asn1.newInteger(this.gcmSpec.getTLen() / 8)).encodeDerOctets();
    }

    @Override
    protected byte[] engineGetEncoded(String format) {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec != null && paramSpec.isAssignableFrom(GCMParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.gcmSpec));
        }
        throw new InvalidParameterSpecException("Expected ParameterSpec class to be assignable from GCMParameterSpec");
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        try {
            Asn1BerValue gcmParams = Asn1.decodeOne(params);
            Util.assertAllUniversal(gcmParams);
            List<Asn1BerValue> gcmPValues = gcmParams.count(2).sequence();
            int tLenBytes = gcmPValues.get(1).getInteger().intValueExact();
            if (tLenBytes < 12 || tLenBytes > 16) {
                throw new IOException("Tag length is not supported");
            }
            this.gcmSpec = new GCMParameterSpec(tLenBytes * 8, gcmPValues.get(0).getOctetString());
        }
        catch (Asn1DecodeException | ArithmeticException ex) {
            throw new IOException("Invalid encoding of GCM parameters", ex);
        }
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected String engineToString() {
        return "GCM Parameters [ tagLen = " + this.gcmSpec.getTLen() + ", iv = " + Util.bytesToHex(this.gcmSpec.getIV()) + "]";
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof GCMParameterSpec)) {
            throw new InvalidParameterSpecException("Invalid parameter spec, expected GCMParameterSpec");
        }
        this.gcmSpec = (GCMParameterSpec)paramSpec;
    }
}

