/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.Rand;
import com.oracle.jipher.internal.spi.KeySizeConfiguration;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AesKeyGenerator
extends KeyGeneratorSpi {
    private static final int DEFAULT_KEY_SIZE = KeySizeConfiguration.getAESKeySize() >>> 3;
    protected int keySize = DEFAULT_KEY_SIZE;

    @Override
    protected void engineInit(int i, SecureRandom secureRandom) {
        if (i != 128 && i != 192 && i != 256) {
            throw new InvalidParameterException("Invalid key size, must be 128, 192 or 256.");
        }
        this.keySize = i >>> 3;
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        this.keySize = DEFAULT_KEY_SIZE;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("AES key generation does not take any parameters");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        byte[] bytes = Rand.generate(this.keySize);
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(bytes, "AES");
            return secretKeySpec;
        }
        finally {
            Util.clearArray(bytes);
        }
    }

    public static final class Aes256
    extends AesFixed {
        public Aes256() {
            super(256);
        }
    }

    public static final class Aes192
    extends AesFixed {
        public Aes192() {
            super(192);
        }
    }

    public static final class Aes128
    extends AesFixed {
        public Aes128() {
            super(128);
        }
    }

    static abstract class AesFixed
    extends AesKeyGenerator {
        protected AesFixed(int keySizeBits) {
            this.keySize = keySizeBits >>> 3;
        }

        @Override
        protected void engineInit(int i, SecureRandom secureRandom) {
            if (this.keySize != i >>> 3) {
                throw new InvalidParameterException("Incorrect key size");
            }
        }

        @Override
        protected void engineInit(SecureRandom secureRandom) {
        }
    }
}

