/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

import com.oracle.jipher.internal.openssl.AlgType;
import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.openssl.OpenSsl;
import com.oracle.jipher.internal.openssl.OpenSslException;
import com.oracle.jipher.internal.openssl.OsslFactory;
import com.oracle.jipher.internal.openssl.OsslObject;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class MacCtx
extends OsslObject {
    private static final ConcurrentMap<String, Long> PREFETCHED_MACS = new ConcurrentHashMap<String, Long>();

    private MacCtx(State state) {
        super(state);
    }

    static void clearPrefetchCache() {
        PREFETCHED_MACS.clear();
    }

    static long fetch(OpenSsl openssl, String macAlg) {
        try {
            return openssl.evpFetch(AlgType.MAC.ordinal(), macAlg);
        }
        catch (OpenSslException e) {
            throw new ProviderException("Internal error", e);
        }
    }

    public void init(byte[] key) throws InvalidKeyException {
        try {
            this.openssl.evpMacInit(this, key);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public void update(byte[] in, int off, int len) {
        try {
            this.openssl.evpMacUpdate(this, in, off, len);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public int mac(byte[] out, int off) {
        try {
            return this.openssl.evpMacFinal(this, out, off);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public static final class Hmac
    extends MacCtx {
        public Hmac(MdAlg md) {
            super(Hmac.newState(md.getAlg()));
        }

        static State newState(String mdAlg) {
            OpenSsl openssl = OsslFactory.get();
            try {
                long evpMac = PREFETCHED_MACS.computeIfAbsent("HMAC", alg -> Hmac.fetch(openssl, alg));
                long ptr = openssl.evpMacCtxNewHmacEx(evpMac, mdAlg);
                return new State(openssl, ptr);
            }
            catch (OpenSslException e) {
                throw new ProviderException("Failed to create OpenSSL object", e);
            }
        }
    }

    static class State
    extends OsslObject.BaseState {
        State(OpenSsl openssl, long ptr) {
            super(openssl, ptr);
        }

        @Override
        void free(long ptr) {
            this.openssl.evpMacCtxFree(ptr);
        }
    }
}

