/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

import com.oracle.jipher.internal.openssl.OpenSsl;
import com.oracle.jipher.internal.openssl.OpenSslException;
import com.oracle.jipher.internal.openssl.OsslFactory;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyType;
import java.security.InvalidKeyException;

public class DerHelper {
    public static byte[] privDerEncode(Pkey pkey) throws OpenSslException {
        return pkey.openssl.jphPkeyPriv2Der(pkey);
    }

    public static byte[] pubDerEncode(Pkey pkey) throws OpenSslException {
        return pkey.openssl.jphPkeyPub2Der(pkey);
    }

    public static Pkey decodePublic(byte[] pubDer, PkeyType expected) throws InvalidKeyException {
        OpenSsl openssl = OsslFactory.get();
        return new Pkey(openssl, openssl.jphDer2PkeyPub(expected.nid(), pubDer), expected);
    }

    public static Pkey decodePrivate(byte[] privDer, PkeyType expected) throws InvalidKeyException {
        OpenSsl openssl = OsslFactory.get();
        return new Pkey(openssl, openssl.jphDer2PkeyPriv(expected.nid(), privDer), expected);
    }
}

