/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationMethod;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.core.util.VMError;
import java.util.List;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

public class ParserConfigurationAdapter
implements ReflectionConfigurationParserDelegate<UnresolvedConfigurationCondition, ConfigurationType> {
    private final TypeConfiguration configuration;

    public ParserConfigurationAdapter(TypeConfiguration configuration) {
        this.configuration = configuration;
    }

    public TypeResult<ConfigurationType> resolveType(UnresolvedConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives) {
        ConfigurationType type = this.configuration.get(condition, typeDescriptor);
        ConfigurationType result = type != null ? type : new ConfigurationType(condition, typeDescriptor, false);
        return TypeResult.forType((String)typeDescriptor.toString(), (Object)result);
    }

    public void registerType(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        VMError.guarantee((boolean)condition.equals((Object)type.getCondition()), (String)"condition is already a part of the type");
        this.configuration.add(type);
    }

    public void registerField(UnresolvedConfigurationCondition condition, ConfigurationType type, String fieldName, boolean finalButWritable) {
        VMError.guarantee((boolean)condition.equals((Object)type.getCondition()), (String)"condition is already a part of the type");
        type.addField(fieldName, ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, finalButWritable);
    }

    public boolean registerAllMethodsWithName(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type, String methodName) {
        VMError.guarantee((boolean)condition.equals((Object)type.getCondition()), (String)"condition is already a part of the type");
        type.addMethodsWithName(methodName, ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
        return true;
    }

    public boolean registerAllConstructors(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        VMError.guarantee((boolean)condition.equals((Object)type.getCondition()), (String)"condition is already a part of the type");
        type.addMethodsWithName("<init>", ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
        return true;
    }

    public void registerUnsafeAllocated(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        VMError.guarantee((boolean)condition.equals((Object)type.getCondition()), (String)"condition is here part of the type");
        type.setUnsafeAllocated();
    }

    public void registerMethod(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type, String methodName, List<ConfigurationType> methodParameterTypes) {
        VMError.guarantee((boolean)condition.equals((Object)type.getCondition()), (String)"condition is already a part of the type");
        type.addMethod(methodName, ConfigurationMethod.toInternalParamsSignature(methodParameterTypes), ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerConstructor(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type, List<ConfigurationType> methodParameterTypes) {
        VMError.guarantee((boolean)condition.equals((Object)type.getCondition()), (String)"condition is already a part of the type");
        type.addMethod("<init>", ConfigurationMethod.toInternalParamsSignature(methodParameterTypes), ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerPublicClasses(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllPublicClasses();
    }

    public void registerDeclaredClasses(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllDeclaredClasses();
    }

    public void registerRecordComponents(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllRecordComponents();
    }

    public void registerPermittedSubclasses(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllPermittedSubclasses();
    }

    public void registerNestMembers(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllNestMembers();
    }

    public void registerSigners(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllSigners();
    }

    public void registerPublicFields(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllPublicFields(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerDeclaredFields(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllDeclaredFields(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerPublicMethods(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllPublicMethods(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerDeclaredMethods(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllDeclaredMethods(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerPublicConstructors(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllPublicConstructors(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerDeclaredConstructors(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        VMError.guarantee((condition.isAlwaysTrue() || condition.equals((Object)type.getCondition()) ? 1 : 0) != 0, (String)"condition is already a part of the type");
        type.setAllDeclaredConstructors(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public String getTypeName(ConfigurationType type) {
        return type.getTypeDescriptor().toString();
    }

    public String getSimpleName(ConfigurationType type) {
        return this.getTypeName(type);
    }
}

