/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jdk.graal.compiler.phases.common.LazyValue;

public class ConfigurationFileCollection {
    public static final Function<IOException, Exception> FAIL_ON_EXCEPTION = e -> e;
    private final Set<URI> reachabilityMetadataPaths = new LinkedHashSet<URI>();
    private final Set<URI> jniConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> reflectConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> proxyConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> resourceConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> serializationConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> predefinedClassesConfigPaths = new LinkedHashSet<URI>();
    private Set<URI> lockFilePaths;

    public void addDirectory(Path path) {
        this.reachabilityMetadataPaths.add(path.resolve(ConfigurationFile.REACHABILITY_METADATA.getFileName()).toUri());
        this.jniConfigPaths.add(path.resolve(ConfigurationFile.JNI.getFileName()).toUri());
        this.reflectConfigPaths.add(path.resolve(ConfigurationFile.REFLECTION.getFileName()).toUri());
        this.proxyConfigPaths.add(path.resolve(ConfigurationFile.DYNAMIC_PROXY.getFileName()).toUri());
        this.resourceConfigPaths.add(path.resolve(ConfigurationFile.RESOURCES.getFileName()).toUri());
        this.serializationConfigPaths.add(path.resolve(ConfigurationFile.SERIALIZATION.getFileName()).toUri());
        this.predefinedClassesConfigPaths.add(path.resolve(ConfigurationFile.PREDEFINED_CLASSES_NAME.getFileName()).toUri());
        this.detectAgentLock(path.resolve(".lock"), x$0 -> Files.exists(x$0, new LinkOption[0]), Path::toUri);
    }

    private <T> void detectAgentLock(T location, Predicate<T> exists, Function<T, URI> toUri) {
        if (exists.test(location)) {
            if (this.lockFilePaths == null) {
                this.lockFilePaths = new LinkedHashSet<URI>();
            }
            this.lockFilePaths.add(toUri.apply(location));
        }
    }

    public void addDirectory(Function<String, URI> fileResolver) {
        ConfigurationFileCollection.addFile(this.reachabilityMetadataPaths, fileResolver, ConfigurationFile.REACHABILITY_METADATA);
        ConfigurationFileCollection.addFile(this.jniConfigPaths, fileResolver, ConfigurationFile.JNI);
        ConfigurationFileCollection.addFile(this.reflectConfigPaths, fileResolver, ConfigurationFile.REFLECTION);
        ConfigurationFileCollection.addFile(this.proxyConfigPaths, fileResolver, ConfigurationFile.DYNAMIC_PROXY);
        ConfigurationFileCollection.addFile(this.resourceConfigPaths, fileResolver, ConfigurationFile.RESOURCES);
        ConfigurationFileCollection.addFile(this.serializationConfigPaths, fileResolver, ConfigurationFile.SERIALIZATION);
        ConfigurationFileCollection.addFile(this.predefinedClassesConfigPaths, fileResolver, ConfigurationFile.PREDEFINED_CLASSES_NAME);
        this.detectAgentLock(fileResolver.apply(".lock"), Objects::nonNull, Function.identity());
    }

    private static void addFile(Set<URI> metadataPaths, Function<String, URI> fileResolver, ConfigurationFile configurationFile) {
        URI uri = fileResolver.apply(configurationFile.getFileName());
        if (uri != null) {
            metadataPaths.add(uri);
        }
    }

    public Set<URI> getDetectedAgentLockPaths() {
        return this.lockFilePaths != null ? this.lockFilePaths : Collections.emptySet();
    }

    public boolean isEmpty() {
        return this.reachabilityMetadataPaths.isEmpty() && this.jniConfigPaths.isEmpty() && this.reflectConfigPaths.isEmpty() && this.proxyConfigPaths.isEmpty() && this.resourceConfigPaths.isEmpty() && this.serializationConfigPaths.isEmpty() && this.predefinedClassesConfigPaths.isEmpty();
    }

    public Set<Path> getPaths(ConfigurationFile configurationFile) {
        return (switch (configurationFile) {
            case ConfigurationFile.REACHABILITY_METADATA -> this.getReachabilityMetadataPaths();
            case ConfigurationFile.DYNAMIC_PROXY -> this.getProxyConfigPaths();
            case ConfigurationFile.RESOURCES -> this.getResourceConfigPaths();
            case ConfigurationFile.JNI -> this.getJniConfigPaths();
            case ConfigurationFile.REFLECTION -> this.getReflectConfigPaths();
            case ConfigurationFile.SERIALIZATION -> this.getSerializationConfigPaths();
            case ConfigurationFile.PREDEFINED_CLASSES_NAME -> this.getPredefinedClassesConfigPaths();
            default -> throw VMError.shouldNotReachHere((String)("Cannot get paths for configuration file " + String.valueOf(configurationFile)));
        }).stream().map(Paths::get).collect(Collectors.toSet());
    }

    public Set<URI> getReachabilityMetadataPaths() {
        return this.reachabilityMetadataPaths;
    }

    public Set<URI> getJniConfigPaths() {
        return this.jniConfigPaths;
    }

    public Set<URI> getReflectConfigPaths() {
        return this.reflectConfigPaths;
    }

    public Set<URI> getProxyConfigPaths() {
        return this.proxyConfigPaths;
    }

    public Set<URI> getResourceConfigPaths() {
        return this.resourceConfigPaths;
    }

    public Set<URI> getSerializationConfigPaths() {
        return this.serializationConfigPaths;
    }

    public Set<URI> getPredefinedClassesConfigPaths() {
        return this.predefinedClassesConfigPaths;
    }

    public TypeConfiguration loadJniConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        return this.loadTypeConfig("jni", this.jniConfigPaths, exceptionHandler);
    }

    public TypeConfiguration loadReflectConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        return this.loadTypeConfig("reflection", this.reflectConfigPaths, exceptionHandler);
    }

    public ProxyConfiguration loadProxyConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        ConfigurationFileCollection.loadConfig(this.proxyConfigPaths, proxyConfiguration.createParser(false), exceptionHandler);
        return proxyConfiguration;
    }

    public PredefinedClassesConfiguration loadPredefinedClassesConfig(List<LazyValue<Path>> classDestinationDirs, Predicate<String> shouldExcludeClassesWithHash, Function<IOException, Exception> exceptionHandler) throws Exception {
        PredefinedClassesConfiguration predefinedClassesConfiguration = new PredefinedClassesConfiguration(classDestinationDirs, shouldExcludeClassesWithHash);
        ConfigurationFileCollection.loadConfig(this.predefinedClassesConfigPaths, predefinedClassesConfiguration.createParser(false), exceptionHandler);
        return predefinedClassesConfiguration;
    }

    public ResourceConfiguration loadResourceConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        ResourceConfiguration resourceConfiguration = new ResourceConfiguration();
        ConfigurationFileCollection.loadConfig(this.reachabilityMetadataPaths, resourceConfiguration.createParser(true), exceptionHandler);
        ConfigurationFileCollection.loadConfig(this.resourceConfigPaths, resourceConfiguration.createParser(false), exceptionHandler);
        return resourceConfiguration;
    }

    public SerializationConfiguration loadSerializationConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        SerializationConfiguration serializationConfiguration = new SerializationConfiguration();
        ConfigurationFileCollection.loadConfig(this.reachabilityMetadataPaths, serializationConfiguration.createParser(true), exceptionHandler);
        ConfigurationFileCollection.loadConfig(this.serializationConfigPaths, serializationConfiguration.createParser(false), exceptionHandler);
        return serializationConfiguration;
    }

    public ConfigurationSet loadConfigurationSet(Function<IOException, Exception> exceptionHandler, List<LazyValue<Path>> predefinedConfigClassDestinationDirs, Predicate<String> predefinedConfigClassWithHashExclusionPredicate) throws Exception {
        return new ConfigurationSet(this.loadReflectConfig(exceptionHandler), this.loadJniConfig(exceptionHandler), this.loadResourceConfig(exceptionHandler), this.loadProxyConfig(exceptionHandler), this.loadSerializationConfig(exceptionHandler), this.loadPredefinedClassesConfig(predefinedConfigClassDestinationDirs, predefinedConfigClassWithHashExclusionPredicate, exceptionHandler));
    }

    private TypeConfiguration loadTypeConfig(String combinedFileKey, Collection<URI> uris, Function<IOException, Exception> exceptionHandler) throws Exception {
        TypeConfiguration configuration = new TypeConfiguration(combinedFileKey);
        ConfigurationFileCollection.loadConfig(this.reachabilityMetadataPaths, configuration.createParser(true), exceptionHandler);
        ConfigurationFileCollection.loadConfig(uris, configuration.createParser(false), exceptionHandler);
        return configuration;
    }

    private static void loadConfig(Collection<URI> configPaths, ConfigurationParser configurationParser, Function<IOException, Exception> exceptionHandler) throws Exception {
        for (URI uri : configPaths) {
            try {
                configurationParser.parseAndRegister(uri);
            }
            catch (IOException ioe) {
                Exception e = ioe;
                if (exceptionHandler != null) {
                    e = exceptionHandler.apply(ioe);
                }
                if (e == null) continue;
                throw e;
            }
        }
    }
}

