/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.graal.code.SubstrateCompilationIdentifier;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.truffle.TruffleCompilationIdentifier;

public final class SubstrateTruffleCompilationIdentifier
extends SubstrateCompilationIdentifier
implements TruffleCompilationIdentifier {
    private final TruffleCompilationTask task;
    private final TruffleCompilable compilable;

    public SubstrateTruffleCompilationIdentifier(TruffleCompilationTask task, TruffleCompilable compilable) {
        this.task = task;
        this.compilable = compilable;
    }

    protected StringBuilder buildString(StringBuilder sb, CompilationIdentifier.Verbosity verbosity) {
        switch (verbosity) {
            case ID: {
                this.buildID(sb);
                break;
            }
            case NAME: {
                this.buildName(sb);
                break;
            }
            case DETAILED: {
                this.buildID(sb);
                sb.append('[');
                this.buildName(sb);
                sb.append(']');
                break;
            }
            default: {
                throw new GraalError("Unknown verbosity: " + String.valueOf(verbosity));
            }
        }
        return sb;
    }

    protected void buildName(StringBuilder sb) {
        sb.append(this.compilable.toString());
    }

    public TruffleCompilationTask getTask() {
        return this.task;
    }

    public TruffleCompilable getCompilable() {
        return this.compilable;
    }
}

